/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.opencomputers;

import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityCrusher;
import blusunrize.immersiveengineering.common.util.compat.opencomputers.ManagedEnvironmentIE;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.DriverTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CrusherDriver
extends DriverTileEntity {
    public ManagedEnvironment createEnvironment(World w, int x, int y, int z) {
        int pos;
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileEntityCrusher && (pos = ((TileEntityCrusher)te).pos) == 9) {
            TileEntityCrusher crush = (TileEntityCrusher)te;
            return new CrusherEnvironment(w, crush.field_145851_c - crush.offset[0], crush.field_145848_d - crush.offset[1], crush.field_145849_e - crush.offset[2], TileEntityCrusher.class);
        }
        return null;
    }

    public Class<?> getTileEntityClass() {
        return TileEntityCrusher.class;
    }

    public class CrusherEnvironment
    extends ManagedEnvironmentIE<TileEntityCrusher> {
        public CrusherEnvironment(World w, int x, int y, int z, Class<? extends TileEntityIEBase> teClass) {
            super(w, x, y, z, teClass);
        }

        @Callback(doc="function(enable:boolean) -- enable or disable the crusher")
        public Object[] setEnabled(Context context, Arguments args) {
            ((TileEntityCrusher)this.getTileEntity()).computerOn = args.checkBoolean(0);
            return null;
        }

        @Callback(doc="function():number -- get energy storage capacity")
        public Object[] getEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityCrusher)this.getTileEntity()).energyStorage.getEnergyStored()};
        }

        @Callback(doc="function():number -- get currently stored energy")
        public Object[] getMaxEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityCrusher)this.getTileEntity()).energyStorage.getMaxEnergyStored()};
        }

        @Callback(doc="function():boolean -- get whether the crusher is currently crushing items")
        public Object[] isActive(Context context, Arguments args) {
            return new Object[]{((TileEntityCrusher)this.getTileEntity()).active};
        }

        @Callback(doc="function(n:int):table -- get the n'th stack in the input queue")
        public Object[] getInputStack(Context context, Arguments args) {
            int slot = args.checkInteger(0);
            TileEntityCrusher master = (TileEntityCrusher)this.getTileEntity();
            if (slot < 1 || slot > master.inputs.size()) {
                throw new IllegalArgumentException("The requested place in the queue does not exist");
            }
            return new Object[]{master.inputs.get(slot - 1)};
        }

        @Callback(doc="function():int -- get the current grinding progress in RF")
        public Object[] getCurrentProgress(Context context, Arguments args) {
            TileEntityCrusher master = (TileEntityCrusher)this.getTileEntity();
            if (master.inputs.isEmpty()) {
                throw new IllegalArgumentException("The crusher doesn't have any inputs");
            }
            int time = master.getRecipeTime(master.inputs.get(0)) - master.process;
            if (time <= 0) {
                throw new IllegalArgumentException("The current crusher recipe is invalid");
            }
            return new Object[]{time};
        }

        @Callback(doc="function():int -- get the grinding progress in RF at which the current grinding will be done")
        public Object[] getCurrentMaxProgress(Context context, Arguments args) {
            TileEntityCrusher master = (TileEntityCrusher)this.getTileEntity();
            if (master.inputs.isEmpty()) {
                throw new IllegalArgumentException("The crusher doesn't have any inputs");
            }
            int time = master.getRecipeTime(master.inputs.get(0));
            if (time <= 0) {
                throw new IllegalArgumentException("The current crusher recipe is invalid");
            }
            return new Object[]{time};
        }

        @Callback(doc="function():int -- get the length of the input queue")
        public Object[] getQueueLength(Context context, Arguments args) {
            return new Object[]{((TileEntityCrusher)this.getTileEntity()).inputs.size()};
        }

        public String preferredName() {
            return "ie_crusher";
        }

        public int priority() {
            return 1000;
        }

        public void onConnect(Node node) {
            TileEntityCrusher te = (TileEntityCrusher)this.getTileEntity();
            if (te != null) {
                te.computerControlled = true;
                te.computerOn = true;
            }
        }

        public void onDisconnect(Node node) {
            TileEntityCrusher te = (TileEntityCrusher)this.getTileEntity();
            if (te != null) {
                te.computerControlled = false;
            }
        }
    }
}

