/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class IEVillagerTradeHandler
implements VillagerRegistry.IVillageTradeHandler {
    float baseChance;
    ArrayList<MerchantDeal> dealList = new ArrayList();
    public static IEVillagerTradeHandler instance;
    boolean doneShaderTrades = false;

    public IEVillagerTradeHandler() {
        this.addDeal(0.6f, new ItemStack((Item)IEContent.itemMaterial, 1, 6), 10, 16, Items.field_151166_bC);
        this.addDeal(0.6f, Items.field_151166_bC, new ItemStack((Item)IEContent.itemMaterial, 1, 6), 10, 16);
        this.addDeal(0.6f, Items.field_151042_j, 2, 4, new ItemStack((Item)IEContent.itemMaterial, 1, 0), 16, 32);
        this.addDeal(0.6f, new ItemStack((Item)IEContent.itemMaterial, 1, 0), 16, 32, Items.field_151042_j, 2, 4);
        this.addDeal(0.5f, new Object[]{Items.field_151014_N, 8, 12, IEContent.itemSeeds, 2, 8});
        this.addDeal(0.3f, Items.field_151166_bC, 1, 2, new ItemStack((Item)IEContent.itemMetal, 1, 5), 2, 6);
        this.addDeal(0.3f, new ItemStack((Item)IEContent.itemMetal, 1, 5), 2, 6, Items.field_151166_bC, 1, 2);
        this.addDeal(0.3f, Items.field_151166_bC, 1, 2, new ItemStack((Item)IEContent.itemMetal, 1, 6), 2, 5);
        this.addDeal(0.3f, new ItemStack((Item)IEContent.itemMetal, 1, 6), 2, 5, Items.field_151166_bC, 1, 2);
        this.addDeal(0.3f, Items.field_151166_bC, 1, 2, new ItemStack((Item)IEContent.itemMetal, 1, 7), 2, 4);
        this.addDeal(0.3f, new ItemStack((Item)IEContent.itemMetal, 1, 7), 2, 4, Items.field_151166_bC, 1, 2);
        this.addDeal(0.2f, Items.field_151043_k, 2, 4, new ItemStack((Item)IEContent.itemTool, 1, 0));
        this.addDeal(0.2f, Items.field_151043_k, 2, 4, new ItemStack((Item)IEContent.itemTool, 1, 1));
        this.addDeal(0.2f, Items.field_151043_k, 2, 4, new ItemStack((Item)IEContent.itemTool, 1, 2));
        this.addDeal(0.4f, Items.field_151166_bC, new ItemStack((Item)IEContent.itemWireCoil, 1, 0), 12, 20);
        this.addDeal(0.4f, new ItemStack((Item)IEContent.itemWireCoil, 1, 0), 12, 20, Items.field_151166_bC);
        this.addDeal(0.3f, Items.field_151166_bC, 1, 3, new ItemStack((Item)IEContent.itemWireCoil, 1, 1), 12, 20);
        this.addDeal(0.3f, new ItemStack((Item)IEContent.itemWireCoil, 1, 1), 12, 20, Items.field_151166_bC, 1, 3);
        this.addDeal(0.2f, Items.field_151166_bC, 1, 3, new ItemStack((Item)IEContent.itemWireCoil, 1, 2), 6, 12);
        this.addDeal(0.2f, new ItemStack((Item)IEContent.itemWireCoil, 1, 2), 6, 12, Items.field_151166_bC, 1, 3);
        this.addDeal(0.4f, Items.field_151166_bC, 1, 3, new ItemStack((Item)IEContent.itemMaterial, 1, 11), 2, 6);
        this.addDeal(0.4f, new ItemStack((Item)IEContent.itemMaterial, 1, 11), 2, 6, Items.field_151166_bC, 1, 3);
        this.addDeal(0.4f, Items.field_151166_bC, 2, 4, new ItemStack((Item)IEContent.itemMaterial, 1, 12), 2, 6);
        this.addDeal(0.4f, new ItemStack((Item)IEContent.itemMaterial, 1, 12), 2, 6, Items.field_151166_bC, 2, 4);
        String[] blueprintCategories = IEContent.itemBlueprint.getSubNames();
        for (int i = 0; i < blueprintCategories.length; ++i) {
            if (BlueprintCraftingRecipe.villagerPrices.get(blueprintCategories[i]) == null) continue;
            ItemStack price = BlueprintCraftingRecipe.villagerPrices.get(blueprintCategories[i]);
            int min = Math.max(1, price.field_77994_a - 2);
            int max = Math.min(64, price.field_77994_a + 2);
            this.addDeal(0.4f, price, min, max, new ItemStack((Item)IEContent.itemBlueprint, 1, i));
            ItemStack special = new ItemStack((Item)IEContent.itemBlueprint, 1, i);
            special.func_151001_c("Super Special BluPrintz");
            ItemNBTHelper.setLore(special, "Congratulations!", "You have found an easter egg!");
            this.addDeal(0.05f, price, min, max, special);
        }
    }

    public void addShaderTrades() {
        if (!this.doneShaderTrades) {
            this.doneShaderTrades = true;
            int highestRarityWeight = ShaderRegistry.rarityWeightMap.get(ShaderRegistry.sortedRarityMap.get(ShaderRegistry.sortedRarityMap.size() - 1));
            for (EnumRarity rarity : ShaderRegistry.sortedRarityMap) {
                if (!ShaderRegistry.totalWeight.containsKey(rarity) || ShaderRegistry.totalWeight.get(rarity) <= 0) continue;
                int w = ShaderRegistry.rarityWeightMap.get(rarity);
                int price = highestRarityWeight - w;
                ItemStack bag = new ItemStack((Item)IEContent.itemShaderBag);
                ItemNBTHelper.setString(bag, "rarity", rarity.toString());
                this.addDeal(0.75f * ((float)w / (float)highestRarityWeight), Items.field_151166_bC, price, price + 3, bag, 1, 1);
            }
        }
    }

    void addDeal(float chance, Object ... objects) {
        MerchantItem[] items = new MerchantItem[3];
        int currentObject = 0;
        int lastType = -1;
        Object tempItem = null;
        int val0 = 1;
        int val1 = 1;
        for (Object o : objects) {
            if (o == null) continue;
            if (o instanceof Integer) {
                if (lastType == 0) {
                    val0 = (Integer)o;
                } else if (lastType == 1) {
                    val1 = (Integer)o;
                }
                lastType = (byte)(lastType + 1);
            } else if (o instanceof Item || o instanceof Block || o instanceof ItemStack) {
                if (tempItem != null) {
                    int n = currentObject;
                    currentObject = (byte)(currentObject + 1);
                    items[n] = new MerchantItem(tempItem, val0, val1);
                }
                tempItem = o;
                lastType = 0;
                val0 = 1;
                val1 = 1;
            } else if (o instanceof MerchantItem) {
                if (tempItem != null) {
                    int n = currentObject;
                    currentObject = (byte)(currentObject + 1);
                    items[n] = new MerchantItem(tempItem, val0, val1);
                    tempItem = null;
                }
                if (currentObject >= items.length) break;
                int n = currentObject;
                currentObject = (byte)(currentObject + 1);
                items[n] = (MerchantItem)o;
            }
            if (currentObject >= items.length) break;
        }
        if (tempItem != null) {
            int n = currentObject;
            currentObject = (byte)(currentObject + 1);
            items[n] = new MerchantItem(tempItem, val0, val1);
        }
        if (items[0] != null && items[1] != null) {
            if (items[2] != null) {
                this.dealList.add(new MerchantDeal(chance, items[0], items[1], items[2]));
            } else {
                this.dealList.add(new MerchantDeal(chance, items[0], null, items[1]));
            }
        }
    }

    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
        this.baseChance = ((Float)ObfuscationReflectionHelper.getPrivateValue(EntityVillager.class, (Object)villager, (String[])new String[]{"field_82191_bN"})).floatValue();
        for (MerchantDeal deal : this.dealList) {
            deal.addToList(recipeList, random);
        }
    }

    private float adjustProbability(float chance) {
        float f1 = chance + this.baseChance;
        return f1 > 0.9f ? 0.9f - (f1 - 0.9f) : f1;
    }

    public static class MerchantItem {
        protected final ItemStack item;
        protected final int minAmount;
        protected final int maxAmount;

        public MerchantItem(Object item, int minAmount, int maxAmount) {
            this.item = item instanceof Item ? new ItemStack((Item)item) : (item instanceof Block ? new ItemStack((Block)item) : (ItemStack)item);
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
        }

        public MerchantItem(Object item, int amount) {
            this(item, amount, amount);
        }

        public ItemStack getItem(Random rand) {
            if (this.minAmount == this.maxAmount) {
                return this.item;
            }
            int dif = this.maxAmount - this.minAmount;
            return Utils.copyStackWithAmount(this.item, this.minAmount + rand.nextInt(dif + 1));
        }
    }

    class MerchantDeal {
        float chance;
        MerchantItem input0;
        MerchantItem input1;
        MerchantItem sale;

        public MerchantDeal(float chance, MerchantItem input0, MerchantItem input1, MerchantItem sale) {
            this.chance = chance;
            this.input0 = input0;
            this.input1 = input1;
            this.sale = sale;
        }

        public void addToList(MerchantRecipeList recipeList, Random rand) {
            if (rand.nextFloat() < IEVillagerTradeHandler.this.adjustProbability(this.chance)) {
                if (this.input1 != null) {
                    recipeList.add((Object)new MerchantRecipe(this.input0.getItem(rand), this.input1.getItem(rand), this.sale.getItem(rand)));
                } else {
                    recipeList.add((Object)new MerchantRecipe(this.input0.getItem(rand), this.sale.getItem(rand)));
                }
            }
        }
    }
}

