/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.ModelIEObj;
import blusunrize.immersiveengineering.client.render.TileRenderIE;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityDieselGenerator;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.model.obj.Vertex;
import org.lwjgl.opengl.GL11;

public class TileRenderDieselGenerator
extends TileRenderIE {
    ModelIEObj model = new ModelIEObj("immersiveengineering:models/dieselGenerator.obj"){

        @Override
        public IIcon getBlockIcon(String groupName) {
            return IEContent.blockMetalMultiblocks.func_149691_a(0, 1);
        }
    };

    @Override
    public void renderStatic(TileEntity tile, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix) {
        TileEntityDieselGenerator gen = (TileEntityDieselGenerator)tile;
        translationMatrix.translate(0.5, 0.5, 0.5);
        rotationMatrix.rotate(Math.toRadians(gen.facing == 3 ? 180.0 : (gen.facing == 4 ? 90.0 : (gen.facing == 5 ? -90.0 : 0.0))), 0.0, 1.0, 0.0);
        if (gen.mirrored) {
            translationMatrix.scale(new Vertex(gen.facing < 4 ? -1.0f : 1.0f, 1.0f, gen.facing > 3 ? -1.0f : 1.0f));
        }
        this.model.render(tile, tes, translationMatrix, rotationMatrix, 0, gen.mirrored, "base");
    }

    @Override
    public void renderDynamic(TileEntity tile, double x, double y, double z, float f) {
        TileEntityDieselGenerator gen = (TileEntityDieselGenerator)tile;
        if (!gen.formed || gen.pos != 31) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        GL11.glRotatef((float)(gen.facing == 3 ? 180.0f : (gen.facing == 4 ? 90.0f : (gen.facing == 5 ? -90.0f : 0.0f))), (float)0.0f, (float)1.0f, (float)0.0f);
        if (gen.mirrored) {
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2884);
        }
        ClientUtils.bindAtlas(0);
        GL11.glTranslated((double)0.0, (double)0.1875, (double)2.96875);
        GL11.glRotatef((float)(gen.fanRotation + gen.fanRotationStep * f), (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.model.renderOnly(new String[]{"fan"});
        if (gen.mirrored) {
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2884);
        }
        GL11.glPopMatrix();
    }
}

