/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.visnet.VisNetHandler;
import thaumcraft.common.tiles.TileMirror;
import tuhljin.automagy.Automagy;
import tuhljin.automagy.codechicken.lib.math.MathHelper;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.FilteringItemList;
import tuhljin.automagy.lib.inventory.IItemMap;
import tuhljin.automagy.lib.inventory.MappedItemsOrderedByTimeAdded;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;
import tuhljin.automagy.network.MessageGUIInventariumBookPref;
import tuhljin.automagy.tiles.IHasItemList;
import tuhljin.automagy.tiles.IInventariumBookLinksMirror;
import tuhljin.automagy.tiles.IInventariumMemoryUser;
import tuhljin.automagy.tiles.IMirrorVariant;
import tuhljin.automagy.tiles.TileEntityInventarium;
import tuhljin.automagy.tiles.TileMirrorWrapper;
import tuhljin.automagy.tiles.TileWithEyes;

public class TileEntityRequisitionTome
extends TileWithEyes
implements IInventariumMemoryUser,
IInventariumBookLinksMirror,
IHasItemList {
    public static int MIRROR_RANGE = 5;
    public static double BOOK_MAXY = 0.1;
    public int linkX;
    public int linkY = -1;
    public int linkZ;
    protected int poweredTime = 0;
    public float openedAmt;
    public double bookY;
    public float page;
    private boolean bookGoingUp = true;
    private FilteringItemList requestsFilterable = null;
    public HashSet<String> sortByNameUsers = new HashSet();

    public TileEntityRequisitionTome() {
        super("Mirror Settings", 2, 0);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.requestsFilterable = null;
            int prevPower = this.poweredTime;
            if (this.poweredTime > 0) {
                --this.poweredTime;
            }
            if (this.poweredTime < 1) {
                int amt;
                int n = amt = this.linkY != -1 ? VisNetHandler.drainVis((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (Aspect)Aspect.ORDER, (int)10) : 0;
                if (amt > 0) {
                    this.poweredTime = amt * 2;
                    if (prevPower < 1) {
                        this.markDirty(true);
                    } else {
                        this.markDirty(false);
                    }
                } else if (prevPower > 0) {
                    this.markDirty(true);
                }
            }
        } else {
            if (this.poweredTime > 0) {
                if (this.openedAmt < 1.0f) {
                    this.openedAmt += 0.02f;
                    if (this.openedAmt > 1.0f) {
                        this.openedAmt = 1.0f;
                    }
                    if (this.bookY < BOOK_MAXY) {
                        this.bookY = MathHelper.retreatExp(this.bookY, BOOK_MAXY, 0.0, 0.18, 0.025);
                        this.bookGoingUp = true;
                    }
                } else if (this.bookGoingUp) {
                    if (this.bookY >= BOOK_MAXY) {
                        this.bookGoingUp = false;
                    } else {
                        this.bookY = MathHelper.retreatExp(this.bookY, BOOK_MAXY, 0.0, 0.007, 0.025);
                    }
                } else if (this.bookY <= 0.0) {
                    this.bookGoingUp = true;
                } else {
                    this.bookY = MathHelper.retreatExp(this.bookY, 0.0, BOOK_MAXY, 0.007, 0.025);
                }
            } else if (this.openedAmt > 0.0f) {
                this.openedAmt -= 0.02f;
                if (this.openedAmt < 0.0f) {
                    this.openedAmt = 0.0f;
                }
            }
            if (this.page > 0.0f) {
                this.page += 0.1f;
                if (this.page > 1.0f) {
                    this.page = this.poweredTime > 0 && this.openedAmt >= 1.0f && this.field_145850_b.field_73012_v.nextInt(4) == 0 ? 0.1f : 0.0f;
                }
            } else if (!(this.openedAmt < 1.0f) && this.field_145850_b.field_73012_v.nextInt(200) == 0) {
                this.page = 0.1f;
                if (this.field_145850_b.field_73012_v.nextInt(16) == 0) {
                    this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.0, (double)this.field_145849_e + 0.5, "thaumcraft:page", 0.1f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f, false);
                }
            }
        }
    }

    @Override
    public void breakLink() {
        this.linkY = -1;
        this.func_70296_d();
    }

    @Override
    public void setLink(TileEntityInventarium teInv) {
        this.linkX = teInv.field_145851_c;
        this.linkY = teInv.field_145848_d;
        this.linkZ = teInv.field_145849_e;
        this.func_70296_d();
    }

    @Override
    public boolean isLinkedTo(TileEntityInventarium teInv) {
        return teInv.field_145851_c == this.linkX && teInv.field_145848_d == this.linkY && teInv.field_145849_e == this.linkZ;
    }

    @Override
    public boolean isInventariumLoaded() {
        return this.linkY != -1 && TjUtil.isChunkLoaded(this.field_145850_b, this.linkX, this.linkZ);
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.linkY == -1 || this.poweredTime < 1) {
            return false;
        }
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public WorldSpecificCoordinates getLinkCoord() {
        return new WorldSpecificCoordinates(this.field_145850_b, this.linkX, this.linkY, this.linkZ);
    }

    @Override
    public WorldSpecificCoordinates getRequesterCoord() {
        return new WorldSpecificCoordinates(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean hasLocalItems() {
        return false;
    }

    @Override
    public boolean canRequestItems() {
        return true;
    }

    private WorldSpecificCoordinates getMirrorCoordIfInRange(int index) {
        double d;
        WorldSpecificCoordinates coord = this.eyesContainingInventory.getCoordinates(index);
        if (coord != null && coord.dim == this.field_145850_b.field_73011_w.field_76574_g && (d = TjUtil.getDistanceBetweenPoints_squared(this.field_145851_c, this.field_145848_d, this.field_145849_e, coord.x, coord.y, coord.z)) <= (double)(MIRROR_RANGE * MIRROR_RANGE)) {
            return coord;
        }
        return null;
    }

    private IMirrorVariant getMirror(int index) {
        WorldSpecificCoordinates coord = this.getMirrorCoordIfInRange(index);
        if (coord != null) {
            World w = Automagy.proxy.getWorldByID(coord.dim);
            if (w == null) {
                return null;
            }
            TileEntity te = w.func_147438_o(coord.x, coord.y, coord.z);
            if (te instanceof TileMirror) {
                return new TileMirrorWrapper((TileMirror)te);
            }
            if (te instanceof IMirrorVariant) {
                return (IMirrorVariant)te;
            }
        }
        return null;
    }

    @Override
    public boolean isInputMirrorInRange() {
        return this.getMirrorCoordIfInRange(0) != null;
    }

    @Override
    public boolean isOutputMirrorInRange() {
        return this.getMirrorCoordIfInRange(1) != null;
    }

    @Override
    public boolean hasInputEye() {
        return this.eyesContainingInventory.func_70301_a(0) != null;
    }

    @Override
    public boolean hasOutputEye() {
        return this.eyesContainingInventory.func_70301_a(1) != null;
    }

    @Override
    public IMirrorVariant getInputMirror() {
        return this.getMirror(0);
    }

    @Override
    public IMirrorVariant getOutputMirror() {
        return this.getMirror(1);
    }

    @Override
    public IInventory getMirrorSettingsInventory() {
        return this.eyesContainingInventory;
    }

    @Override
    public boolean isTrackingDestinations() {
        TileEntity te = this.field_145850_b.func_147438_o(this.linkX, this.linkY, this.linkZ);
        if (te instanceof TileEntityInventarium) {
            return ((TileEntityInventarium)te).isTrackingDestinations();
        }
        return false;
    }

    @Override
    public IItemMap getLocalItemList() {
        return null;
    }

    @Override
    public FilteringItemList getInventariumItemList() {
        TileEntity te = this.field_145850_b.func_147438_o(this.linkX, this.linkY, this.linkZ);
        if (te instanceof TileEntityInventarium) {
            return ((TileEntityInventarium)te).getItemList();
        }
        return null;
    }

    @Override
    public MappedItemsOrderedByTimeAdded getInventariumRequestedItemList() {
        TileEntity te = this.field_145850_b.func_147438_o(this.linkX, this.linkY, this.linkZ);
        if (te instanceof TileEntityInventarium) {
            return ((TileEntityInventarium)te).getRequestedItems();
        }
        return null;
    }

    @Override
    public FilteringItemList getItemList() {
        MappedItemsOrderedByTimeAdded list;
        if (this.requestsFilterable == null && (list = this.getInventariumRequestedItemList()) != null) {
            this.requestsFilterable = new FilteringItemList(list);
        }
        return this.requestsFilterable;
    }

    @Override
    public void setPlayerLocalViewPreference(EntityPlayer player, boolean local) {
    }

    @Override
    public void setPlayerSortingPreference(EntityPlayer player, boolean byName) {
        if (this.field_145850_b.field_72995_K) {
            MessageGUIInventariumBookPref.sendToServer(1, byName);
        } else {
            String name = player.func_70005_c_();
            if (byName) {
                if (name != "Rcon") {
                    this.sortByNameUsers.add(name);
                }
            } else if (this.sortByNameUsers.contains(name)) {
                this.sortByNameUsers.remove(name);
            }
            this.func_70296_d();
        }
    }

    @Override
    public boolean doesPlayerPreferLocalView(EntityPlayer player) {
        return false;
    }

    @Override
    public boolean doesPlayerPreferSortByName(EntityPlayer player) {
        return this.sortByNameUsers.contains(player.func_70005_c_());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1));
        return bb;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.func_74768_a("poweredTime", this.poweredTime);
        nbttagcompound.func_74768_a("linkX", this.linkX);
        nbttagcompound.func_74768_a("linkY", this.linkY);
        nbttagcompound.func_74768_a("linkZ", this.linkZ);
        NBTTagList nbttaglist = new NBTTagList();
        for (String name : this.sortByNameUsers) {
            if (name == null || name.isEmpty()) continue;
            NBTTagCompound tagList = new NBTTagCompound();
            tagList.func_74778_a("User", name);
            nbttaglist.func_74742_a((NBTBase)tagList);
        }
        nbttagcompound.func_74782_a("sortByNameUsers", (NBTBase)nbttaglist);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.poweredTime = nbttagcompound.func_74762_e("poweredTime");
        this.linkX = nbttagcompound.func_74762_e("linkX");
        this.linkY = nbttagcompound.func_74762_e("linkY");
        this.linkZ = nbttagcompound.func_74762_e("linkZ");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("sortByNameUsers", 10);
        this.sortByNameUsers.clear();
        int size = nbttaglist.func_74745_c();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tagList = nbttaglist.func_150305_b(i);
            String name = tagList.func_74779_i("User");
            if (name == null || name.isEmpty()) continue;
            this.sortByNameUsers.add(name);
        }
    }

    @Override
    public void onEyesInventoryChanged(int slot, ItemStack prevStack) {
        super.onEyesInventoryChanged(slot, prevStack);
    }
}

