/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client;

import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Iterator;
import java.util.List;
import net.blay09.mods.waystones.CommonProxy;
import net.blay09.mods.waystones.PlayerWaystoneData;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.client.gui.GuiButtonWarp;
import net.blay09.mods.waystones.client.gui.GuiConfirmReturn;
import net.blay09.mods.waystones.client.gui.GuiWarpStone;
import net.blay09.mods.waystones.client.gui.GuiWaystoneName;
import net.blay09.mods.waystones.client.render.RenderWaystone;
import net.blay09.mods.waystones.client.render.WaystoneBlockRenderer;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    private GuiButtonWarp buttonWarp;
    private static final List<String> tmpTooltip = Lists.newArrayList();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.bindTileEntitySpecialRenderer(TileWaystone.class, (TileEntitySpecialRenderer)new RenderWaystone());
        RenderingRegistry.registerBlockHandler((int)WaystoneBlockRenderer.RENDER_ID, (ISimpleBlockRenderingHandler)new WaystoneBlockRenderer());
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (Waystones.getConfig().teleportButton && event.gui instanceof GuiInventory) {
            this.buttonWarp = new GuiButtonWarp((GuiContainer)event.gui);
            event.buttonList.add(this.buttonWarp);
        }
    }

    @SubscribeEvent
    public void onActionPerformed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.button instanceof GuiButtonWarp) {
            EntityClientPlayerMP entityPlayer = FMLClientHandler.instance().getClientPlayerEntity();
            if (PlayerWaystoneData.canFreeWarp((EntityPlayer)entityPlayer) && PlayerWaystoneData.getLastWaystone((EntityPlayer)entityPlayer) != null) {
                if (Waystones.getConfig().teleportButtonReturnOnly) {
                    event.gui.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmReturn());
                } else {
                    Waystones.proxy.openWaystoneSelection(true);
                }
            } else {
                event.gui.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("random.click"), (float)0.5f));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.gui instanceof GuiInventory && this.buttonWarp != null && this.buttonWarp.isHovered()) {
            tmpTooltip.clear();
            long timeSince = System.currentTimeMillis() - PlayerWaystoneData.getLastFreeWarp((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
            int secondsLeft = (int)(((long)(Waystones.getConfig().warpStoneCooldown * 1000) - timeSince) / 1000L);
            if (Waystones.getConfig().teleportButtonReturnOnly) {
                tmpTooltip.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.waystones:returnToWaystone", (Object[])new Object[0]));
                WaystoneEntry lastEntry = PlayerWaystoneData.getLastWaystone((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
                if (lastEntry != null) {
                    tmpTooltip.add(EnumChatFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:boundTo", (Object[])new Object[]{EnumChatFormatting.DARK_AQUA + lastEntry.getName()}));
                } else {
                    tmpTooltip.add(EnumChatFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:boundTo", (Object[])new Object[]{I18n.func_135052_a((String)"tooltip.waystones:none", (Object[])new Object[0])}));
                }
                if (secondsLeft > 0) {
                    tmpTooltip.add("");
                    tmpTooltip.add(EnumChatFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:cooldownLeft", (Object[])new Object[]{secondsLeft}));
                }
            } else {
                tmpTooltip.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.waystones:openWaystoneMenu", (Object[])new Object[0]));
                if (secondsLeft > 0) {
                    tmpTooltip.add(EnumChatFormatting.GRAY + I18n.func_135052_a((String)"tooltip.waystones:cooldownLeft", (Object[])new Object[]{secondsLeft}));
                }
            }
            event.gui.func_146283_a(tmpTooltip, event.mouseX, event.mouseY);
        }
    }

    @SubscribeEvent
    public void onFOV(FOVUpdateEvent event) {
        if (event.entity.func_71011_bu() != null && event.entity.func_71011_bu().func_77973_b() == Waystones.itemReturnScroll) {
            event.newfov = (float)event.entity.func_71057_bx() / 64.0f * 2.0f + 0.5f;
        }
    }

    @Override
    public void openWaystoneNameEdit(TileWaystone tileEntity) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWaystoneName(tileEntity));
    }

    @Override
    public void openWaystoneSelection(boolean isFree) {
        WaystoneEntry[] playerWaystones = PlayerWaystoneData.fromPlayer((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity()).getWaystones();
        WaystoneEntry[] combinedWaystones = new WaystoneEntry[WaystoneManager.getServerWaystones().size() + playerWaystones.length];
        int i = 0;
        Iterator<WaystoneEntry> iterator = WaystoneManager.getServerWaystones().iterator();
        while (iterator.hasNext()) {
            WaystoneEntry entry;
            combinedWaystones[i] = entry = iterator.next();
            ++i;
        }
        System.arraycopy(playerWaystones, 0, combinedWaystones, i, playerWaystones.length);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiWarpStone(combinedWaystones, isFree));
    }

    @Override
    public void printChatMessage(int id, IChatComponent chatComponent) {
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a(chatComponent, id);
    }

    @Override
    public void playSound(String soundName, float pitch) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation(soundName), (float)pitch));
    }
}

