/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Collection;
import java.util.Map;
import net.blay09.mods.waystones.PlayerWaystoneData;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.network.NetworkHandler;
import net.blay09.mods.waystones.network.message.MessageTeleportEffect;
import net.blay09.mods.waystones.network.message.MessageWaystones;
import net.blay09.mods.waystones.util.BlockPos;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class WaystoneManager {
    private static final Map<String, WaystoneEntry> serverWaystones = Maps.newHashMap();
    private static final Map<String, WaystoneEntry> knownWaystones = Maps.newHashMap();

    public static void activateWaystone(EntityPlayer player, TileWaystone waystone) {
        WaystoneEntry serverWaystone = WaystoneManager.getServerWaystone(waystone.getWaystoneName());
        if (serverWaystone != null) {
            PlayerWaystoneData.setLastServerWaystone(player, serverWaystone);
            WaystoneManager.sendPlayerWaystones(player);
            return;
        }
        PlayerWaystoneData.resetLastServerWaystone(player);
        WaystoneManager.removePlayerWaystone(player, new WaystoneEntry(waystone));
        WaystoneManager.addPlayerWaystone(player, waystone);
        WaystoneManager.sendPlayerWaystones(player);
    }

    public static void sendPlayerWaystones(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            PlayerWaystoneData waystoneData = PlayerWaystoneData.fromPlayer(player);
            NetworkHandler.channel.sendTo((IMessage)new MessageWaystones(waystoneData.getWaystones(), WaystoneManager.getServerWaystones().toArray(new WaystoneEntry[WaystoneManager.getServerWaystones().size()]), waystoneData.getLastServerWaystoneName(), waystoneData.getLastFreeWarp(), waystoneData.getLastWarpStoneUse()), (EntityPlayerMP)player);
        }
    }

    public static void addPlayerWaystone(EntityPlayer player, TileWaystone waystone) {
        NBTTagCompound tagCompound = PlayerWaystoneData.getOrCreateWaystonesTag(player);
        NBTTagList tagList = tagCompound.func_150295_c("WaystoneList", 10);
        tagList.func_74742_a((NBTBase)new WaystoneEntry(waystone).writeToNBT());
        tagCompound.func_74782_a("WaystoneList", (NBTBase)tagList);
    }

    public static boolean removePlayerWaystone(EntityPlayer player, WaystoneEntry waystone) {
        NBTTagCompound tagCompound = PlayerWaystoneData.getWaystonesTag(player);
        NBTTagList tagList = tagCompound.func_150295_c("WaystoneList", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound entryCompound = tagList.func_150305_b(i);
            if (!WaystoneEntry.read(entryCompound).equals(waystone)) continue;
            tagList.func_74744_a(i);
            return true;
        }
        return false;
    }

    public static boolean checkAndUpdateWaystone(EntityPlayer player, WaystoneEntry waystone) {
        WaystoneEntry serverEntry = WaystoneManager.getServerWaystone(waystone.getName());
        if (serverEntry != null) {
            if (WaystoneManager.getWaystoneInWorld(serverEntry) == null) {
                WaystoneManager.removeServerWaystone(serverEntry);
                return false;
            }
            if (WaystoneManager.removePlayerWaystone(player, waystone)) {
                WaystoneManager.sendPlayerWaystones(player);
            }
            return true;
        }
        NBTTagCompound tagCompound = PlayerWaystoneData.getWaystonesTag(player);
        NBTTagList tagList = tagCompound.func_150295_c("WaystoneList", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound entryCompound = tagList.func_150305_b(i);
            if (!WaystoneEntry.read(entryCompound).equals(waystone)) continue;
            TileWaystone tileEntity = WaystoneManager.getWaystoneInWorld(waystone);
            if (tileEntity != null) {
                if (!entryCompound.func_74779_i("Name").equals(tileEntity.getWaystoneName())) {
                    entryCompound.func_74778_a("Name", tileEntity.getWaystoneName());
                    WaystoneManager.sendPlayerWaystones(player);
                }
                return true;
            }
            WaystoneManager.removePlayerWaystone(player, waystone);
            WaystoneManager.sendPlayerWaystones(player);
            return false;
        }
        return false;
    }

    public static TileWaystone getWaystoneInWorld(WaystoneEntry waystone) {
        WorldServer targetWorld = MinecraftServer.func_71276_C().func_71218_a(waystone.getDimensionId());
        TileEntity tileEntity = targetWorld.func_147438_o(waystone.getPos().getX(), waystone.getPos().getY(), waystone.getPos().getZ());
        if (tileEntity instanceof TileWaystone) {
            return (TileWaystone)tileEntity;
        }
        return null;
    }

    public static boolean teleportToWaystone(EntityPlayer player, WaystoneEntry waystone) {
        boolean dimensionWarp;
        if (!WaystoneManager.checkAndUpdateWaystone(player, waystone)) {
            ChatComponentTranslation chatComponent = new ChatComponentTranslation("waystones:waystoneBroken", new Object[0]);
            chatComponent.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            player.func_146105_b((IChatComponent)chatComponent);
            return false;
        }
        WaystoneEntry serverEntry = WaystoneManager.getServerWaystone(waystone.getName());
        WorldServer targetWorld = MinecraftServer.func_71276_C().func_71218_a(waystone.getDimensionId());
        int x = waystone.getPos().getX();
        int y = waystone.getPos().getY();
        int z = waystone.getPos().getZ();
        ForgeDirection facing = ForgeDirection.getOrientation((int)targetWorld.func_72805_g(x, y, z));
        BlockPos targetPos = waystone.getPos().offset(facing);
        boolean bl = dimensionWarp = waystone.getDimensionId() != player.func_130014_f_().field_73011_w.field_76574_g;
        if (dimensionWarp && !Waystones.getConfig().interDimension && serverEntry != null && Waystones.getConfig().globalInterDimension) {
            player.func_146105_b((IChatComponent)new ChatComponentTranslation("waystones:noDimensionWarp", new Object[0]));
            return false;
        }
        WaystoneManager.sendTeleportEffect(player.field_70170_p, new BlockPos(player));
        player.func_70690_d(new PotionEffect(Potion.field_76440_q.func_76396_c(), 20, 3));
        if (dimensionWarp) {
            player.func_71027_c(waystone.getDimensionId());
        }
        player.field_70177_z = WaystoneManager.getRotationYaw(facing);
        player.func_70634_a((double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5);
        WaystoneManager.sendTeleportEffect(player.field_70170_p, targetPos);
        return true;
    }

    public static void sendTeleportEffect(World world, BlockPos pos) {
        NetworkHandler.channel.sendToAllAround((IMessage)new MessageTeleportEffect(pos), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 64.0));
    }

    public static float getRotationYaw(ForgeDirection facing) {
        switch (facing) {
            case NORTH: {
                return 180.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case EAST: {
                return -90.0f;
            }
        }
        return 0.0f;
    }

    public static void addServerWaystone(WaystoneEntry entry) {
        serverWaystones.put(entry.getName(), entry);
        WaystoneConfig.storeServerWaystones(Waystones.configuration, serverWaystones.values());
    }

    public static void removeServerWaystone(WaystoneEntry entry) {
        serverWaystones.remove(entry.getName());
        WaystoneConfig.storeServerWaystones(Waystones.configuration, serverWaystones.values());
    }

    public static void setServerWaystones(WaystoneEntry[] entries) {
        serverWaystones.clear();
        for (WaystoneEntry entry : entries) {
            serverWaystones.put(entry.getName(), entry);
        }
    }

    public static void setKnownWaystones(WaystoneEntry[] entries) {
        knownWaystones.clear();
        for (WaystoneEntry entry : entries) {
            knownWaystones.put(entry.getName(), entry);
        }
    }

    public static WaystoneEntry getKnownWaystone(String name) {
        return knownWaystones.get(name);
    }

    public static Collection<WaystoneEntry> getServerWaystones() {
        return serverWaystones.values();
    }

    public static WaystoneEntry getServerWaystone(String name) {
        return serverWaystones.get(name);
    }
}

