/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.utils;

import java.util.Random;

public class PerlinNoise {
    private Random rand;
    private final int B = 4096;
    private final int BM = 255;
    private final int N = 4096;
    private final int NP = 12;
    private final int NM = 4095;
    private final int DEFAULT_SAMPLE_SIZE = 256;
    private final float LOG_HALF = (float)Math.log(0.5);
    private int[] p_imp = new int[512];
    private int[] p;
    private float[][] g3;
    private float[][] g2;
    private float[] g1;

    public PerlinNoise() {
        this(100L);
    }

    public PerlinNoise(long seed) {
        int i;
        this.rand = new Random(seed);
        for (i = 0; i < 256; ++i) {
            this.p_imp[i] = i;
        }
        while (--i > 0) {
            int k = this.p_imp[i];
            int j = (int)(this.rand.nextLong() & 0x100L);
            this.p_imp[i] = this.p_imp[j];
            this.p_imp[j] = k;
        }
        this.initPerlin1();
    }

    public double improvedNoise(double x, double y, double z) {
        int uc_x = (int)Math.floor(x) & 0xFF;
        int uc_y = (int)Math.floor(y) & 0xFF;
        int uc_z = (int)Math.floor(z) & 0xFF;
        double xo = x - Math.floor(x);
        double yo = y - Math.floor(y);
        double zo = z - Math.floor(z);
        double u = this.fade(xo);
        double v = this.fade(yo);
        double w = this.fade(zo);
        int a = this.p_imp[uc_x] + uc_y;
        int aa = this.p_imp[a] + uc_z;
        int ab = this.p_imp[a + 1] + uc_z;
        int b = this.p_imp[uc_x + 1] + uc_y;
        int ba = this.p_imp[b] + uc_z;
        int bb = this.p_imp[b + 1] + uc_z;
        double c1 = this.grad(this.p_imp[aa], xo, yo, zo);
        double c2 = this.grad(this.p_imp[ba], xo - 1.0, yo, zo);
        double c3 = this.grad(this.p_imp[ab], xo, yo - 1.0, zo);
        double c4 = this.grad(this.p_imp[bb], xo - 1.0, yo - 1.0, zo);
        double c5 = this.grad(this.p_imp[aa + 1], xo, yo, zo - 1.0);
        double c6 = this.grad(this.p_imp[ba + 1], xo - 1.0, yo, zo - 1.0);
        double c7 = this.grad(this.p_imp[ab + 1], xo, yo - 1.0, zo - 1.0);
        double c8 = this.grad(this.p_imp[bb + 1], xo - 1.0, yo - 1.0, zo - 1.0);
        return this.lerp(w, this.lerp(v, this.lerp(u, c1, c2), this.lerp(u, c3, c4)), this.lerp(v, this.lerp(u, c5, c6), this.lerp(u, c7, c8)));
    }

    public float noise1(float x) {
        float t = x + 4096.0f;
        int bx0 = (int)t & 0xFF;
        int bx1 = bx0 + 1 & 0xFF;
        float rx0 = t - (float)((int)t);
        float rx1 = rx0 - 1.0f;
        float sx = this.sCurve(rx0);
        float u = rx0 * this.g1[this.p[bx0]];
        float v = rx1 * this.g1[this.p[bx1]];
        return this.lerp(sx, u, v);
    }

    public float noise2(float x, float y) {
        float t = x + 4096.0f;
        int bx0 = (int)t & 0xFF;
        int bx1 = bx0 + 1 & 0xFF;
        float rx0 = t - (float)((int)t);
        float rx1 = rx0 - 1.0f;
        t = y + 4096.0f;
        int by0 = (int)t & 0xFF;
        int by1 = by0 + 1 & 0xFF;
        float ry0 = t - (float)((int)t);
        float ry1 = ry0 - 1.0f;
        int i = this.p[bx0];
        int j = this.p[bx1];
        int b00 = this.p[i + by0];
        int b10 = this.p[j + by0];
        int b01 = this.p[i + by1];
        int b11 = this.p[j + by1];
        float sx = this.sCurve(rx0);
        float sy = this.sCurve(ry0);
        float[] q = this.g2[b00];
        float u = rx0 * q[0] + ry0 * q[1];
        q = this.g2[b10];
        float v = rx1 * q[0] + ry0 * q[1];
        float a = this.lerp(sx, u, v);
        q = this.g2[b01];
        u = rx0 * q[0] + ry1 * q[1];
        q = this.g2[b11];
        v = rx1 * q[0] + ry1 * q[1];
        float b = this.lerp(sx, u, v);
        return this.lerp(sy, a, b);
    }

    public float noise3(float x, float y, float z) {
        float t = x + 4096.0f;
        int bx0 = (int)t & 0xFF;
        int bx1 = bx0 + 1 & 0xFF;
        float rx0 = t - (float)((int)t);
        float rx1 = rx0 - 1.0f;
        t = y + 4096.0f;
        int by0 = (int)t & 0xFF;
        int by1 = by0 + 1 & 0xFF;
        float ry0 = t - (float)((int)t);
        float ry1 = ry0 - 1.0f;
        t = z + 4096.0f;
        int bz0 = (int)t & 0xFF;
        int bz1 = bz0 + 1 & 0xFF;
        float rz0 = t - (float)((int)t);
        float rz1 = rz0 - 1.0f;
        int i = this.p[bx0];
        int j = this.p[bx1];
        int b00 = this.p[i + by0];
        int b10 = this.p[j + by0];
        int b01 = this.p[i + by1];
        int b11 = this.p[j + by1];
        t = this.sCurve(rx0);
        float sy = this.sCurve(ry0);
        float sz = this.sCurve(rz0);
        float[] q = this.g3[b00 + bz0];
        float u = rx0 * q[0] + ry0 * q[1] + rz0 * q[2];
        q = this.g3[b10 + bz0];
        float v = rx1 * q[0] + ry0 * q[1] + rz0 * q[2];
        float a = this.lerp(t, u, v);
        q = this.g3[b01 + bz0];
        u = rx0 * q[0] + ry1 * q[1] + rz0 * q[2];
        q = this.g3[b11 + bz0];
        v = rx1 * q[0] + ry1 * q[1] + rz0 * q[2];
        float b = this.lerp(t, u, v);
        float c = this.lerp(sy, a, b);
        q = this.g3[b00 + bz1];
        u = rx0 * q[0] + ry0 * q[1] + rz1 * q[2];
        q = this.g3[b10 + bz1];
        v = rx1 * q[0] + ry0 * q[1] + rz1 * q[2];
        a = this.lerp(t, u, v);
        q = this.g3[b01 + bz1];
        u = rx0 * q[0] + ry1 * q[1] + rz1 * q[2];
        q = this.g3[b11 + bz1];
        v = rx1 * q[0] + ry1 * q[1] + rz1 * q[2];
        b = this.lerp(t, u, v);
        float d = this.lerp(sy, a, b);
        return this.lerp(sz, c, d);
    }

    public double imporvedTurbulence(double x, double y, double z, float loF, float hiF) {
        double p_x = x + (double)123.456f;
        double p_y = y;
        double p_z = z;
        double t = 0.0;
        for (double f = (double)loF; f < (double)hiF; f *= 2.0) {
            t += Math.abs(this.improvedNoise(p_x, p_y, p_z)) / f;
            p_x *= 2.0;
            p_y *= 2.0;
            p_z *= 2.0;
        }
        return t - 0.3;
    }

    public float turbulence2(float x, float y, float freq) {
        float t = 0.0f;
        do {
            t += this.noise2(freq * x, freq * y) / freq;
        } while ((freq *= 0.5f) >= 1.0f);
        return t;
    }

    public float turbulence3(float x, float y, float z, float freq) {
        float t = 0.0f;
        do {
            t += this.noise3(freq * x, freq * y, freq * z) / freq;
        } while ((freq *= 0.5f) >= 1.0f);
        return t;
    }

    public float tileableNoise1(float x, float w) {
        return (this.noise1(x) * (w - x) + this.noise1(x - w) * x) / w;
    }

    public float tileableNoise2(float x, float y, float w, float h) {
        return (this.noise2(x, y) * (w - x) * (h - y) + this.noise2(x - w, y) * x * (h - y) + this.noise2(x, y - h) * (w - x) * y + this.noise2(x - w, y - h) * x * y) / (w * h);
    }

    public float tileableNoise3(float x, float y, float z, float w, float h, float d) {
        return (this.noise3(x, y, z) * (w - x) * (h - y) * (d - z) + this.noise3(x - w, y, z) * x * (h - y) * (d - z) + this.noise3(x, y - h, z) * (w - x) * y * (d - z) + this.noise3(x - w, y - h, z) * x * y * (d - z) + this.noise3(x, y, z - d) * (w - x) * (h - y) * z + this.noise3(x - w, y, z - d) * x * (h - y) * z + this.noise3(x, y - h, z - d) * (w - x) * y * z + this.noise3(x - w, y - h, z - d) * x * y * z) / (w * h * d);
    }

    public float tileableTurbulence2(float x, float y, float w, float h, float freq) {
        float t = 0.0f;
        do {
            t += this.tileableNoise2(freq * x, freq * y, w * freq, h * freq) / freq;
        } while ((freq *= 0.5f) >= 1.0f);
        return t;
    }

    public float tileableTurbulence3(float x, float y, float z, float w, float h, float d, float freq) {
        float t = 0.0f;
        do {
            t += this.tileableNoise3(freq * x, freq * y, freq * z, w * freq, h * freq, d * freq) / freq;
        } while ((freq *= 0.5f) >= 1.0f);
        return t;
    }

    private double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    private float lerp(float t, float a, float b) {
        return a + t * (b - a);
    }

    private double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    private double grad(int hash, double x, double y, double z) {
        int h = hash & 0xF;
        double u = h < 8 || h == 12 || h == 13 ? x : y;
        double v = h < 4 || h == 12 || h == 13 ? y : z;
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }

    private float bias(float a, float b) {
        return (float)Math.pow(a, Math.log(b) / (double)this.LOG_HALF);
    }

    private float gain(float a, float b) {
        if (a < 0.001f) {
            return 0.0f;
        }
        if (a > 0.999f) {
            return 1.0f;
        }
        double p = Math.log(1.0f - b) / (double)this.LOG_HALF;
        if (a < 0.5f) {
            return (float)(Math.pow(2.0f * a, p) / 2.0);
        }
        return 1.0f - (float)(Math.pow(2.0f * (1.0f - a), p) / 2.0);
    }

    private float sCurve(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    private void normalize2(float[] v) {
        float s = (float)(1.0 / Math.sqrt(v[0] * v[0] + v[1] * v[1]));
        v[0] = v[0] * s;
        v[1] = v[1] * s;
    }

    private void normalize3(float[] v) {
        float s = (float)(1.0 / Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]));
        v[0] = v[0] * s;
        v[1] = v[1] * s;
        v[2] = v[2] * s;
    }

    private void initPerlin1() {
        int j;
        int i;
        this.p = new int[8194];
        this.g3 = new float[8194][3];
        this.g2 = new float[8194][2];
        this.g1 = new float[8194];
        for (i = 0; i < 4096; ++i) {
            this.p[i] = i;
            this.g1[i] = (float)(this.rand.nextDouble() * 2.147483647E9 % 8192.0 - 4096.0) / 4096.0f;
            for (j = 0; j < 2; ++j) {
                this.g2[i][j] = (float)(this.rand.nextDouble() * 2.147483647E9 % 8192.0 - 4096.0) / 4096.0f;
            }
            this.normalize2(this.g2[i]);
            for (j = 0; j < 3; ++j) {
                this.g3[i][j] = (float)(this.rand.nextDouble() * 2.147483647E9 % 8192.0 - 4096.0) / 4096.0f;
            }
            this.normalize3(this.g3[i]);
        }
        while (--i > 0) {
            int k = this.p[i];
            j = (int)(this.rand.nextDouble() * 2.147483647E9 % 4096.0);
            this.p[i] = this.p[j];
            this.p[j] = k;
        }
        for (i = 0; i < 4098; ++i) {
            this.p[4096 + i] = this.p[i];
            this.g1[4096 + i] = this.g1[i];
            for (j = 0; j < 2; ++j) {
                this.g2[4096 + i][j] = this.g2[i][j];
            }
            for (j = 0; j < 3; ++j) {
                this.g3[4096 + i][j] = this.g3[i][j];
            }
        }
    }
}

