/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import juuxel.adorn.util.NbtConvertible;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0012\u0012\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b04\u00a2\u0006\u0004\b:\u0010;B\u000f\u0012\u0006\u00102\u001a\u00020\u0019\u00a2\u0006\u0004\b:\u0010<J)\u0010\u0006\u001a\u00020\u00042\u0014\b\u0004\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u0003H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u0019\u0010\u0013\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b!\u0010\u0016J\u0017\u0010$\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010'\u001a\n &*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b'\u0010\u001eJ'\u0010'\u001a\n &*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b'\u0010)J\u001f\u0010*\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b*\u0010+J\u000f\u0010,\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b,\u0010-J\u0015\u0010.\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b.\u0010\u000fJ\u0015\u0010/\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b/\u0010\u000fJ\u0017\u00100\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b0\u00101R\u0014\u00102\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u001a\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020\b078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006="}, d2={"Ljuuxel/adorn/util/InventoryComponent;", "Lnet/minecraft/world/Container;", "Ljuuxel/adorn/util/NbtConvertible;", "Lkotlin/Function1;", "", "block", "addListener", "(Lkotlin/jvm/functions/Function1;)V", "Lnet/minecraft/world/ContainerListener;", "listener", "(Lnet/minecraft/world/ContainerListener;)V", "Lnet/minecraft/world/item/ItemStack;", "stack", "", "canExtract", "(Lnet/minecraft/world/item/ItemStack;)Z", "canInsert", "Lnet/minecraft/world/entity/player/Player;", "player", "canPlayerUse", "(Lnet/minecraft/world/entity/player/Player;)Z", "clear", "()V", "copy", "()Ljuuxel/adorn/util/InventoryComponent;", "", "getAmountWithNbt", "(Lnet/minecraft/world/item/ItemStack;)I", "slot", "getStack", "(I)Lnet/minecraft/world/item/ItemStack;", "isEmpty", "()Z", "markDirty", "Lnet/minecraft/nbt/CompoundTag;", "nbt", "readNbt", "(Lnet/minecraft/nbt/CompoundTag;)V", "kotlin.jvm.PlatformType", "removeStack", "count", "(II)Lnet/minecraft/world/item/ItemStack;", "setStack", "(ILnet/minecraft/world/item/ItemStack;)V", "size", "()I", "tryExtract", "tryInsert", "writeNbt", "(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;", "invSize", "I", "Lnet/minecraft/core/NonNullList;", "items", "Lnet/minecraft/core/NonNullList;", "", "listeners", "Ljava/util/List;", "<init>", "(Lnet/minecraft/core/NonNullList;)V", "(I)V", "Adorn"})
public class InventoryComponent
implements Container,
NbtConvertible {
    private final int invSize;
    @NotNull
    private final List<ContainerListener> listeners;
    @NotNull
    private final NonNullList<ItemStack> items;

    public InventoryComponent(int invSize) {
        this.invSize = invSize;
        this.listeners = new ArrayList();
        NonNullList nonNullList = NonNullList.m_122780_((int)this.invSize, (Object)ItemStack.f_41583_);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"ofSize(invSize, ItemStack.EMPTY)");
        this.items = nonNullList;
    }

    private InventoryComponent(NonNullList<ItemStack> items) {
        this(items.size());
        Iterator iterator = items.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            ItemStack item = (ItemStack)iterator.next();
            this.items.set(i, (Object)item);
        }
    }

    @NotNull
    public final InventoryComponent copy() {
        return new InventoryComponent(this.items);
    }

    public final boolean canExtract(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int remainingAmount = stack.m_41613_();
        for (ItemStack invStack : this.items) {
            if (!invStack.m_41726_(stack) || (remainingAmount -= invStack.m_41613_()) > 0) continue;
            return true;
        }
        return false;
    }

    public final boolean tryExtract(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int remainingAmount = stack.m_41613_();
        for (ItemStack invStack : this.items) {
            if (!invStack.m_41726_(stack) || !Intrinsics.areEqual((Object)invStack.m_41783_(), (Object)stack.m_41783_())) continue;
            int invStackAmount = invStack.m_41613_();
            invStack.m_41774_(Math.min(invStackAmount, remainingAmount));
            if ((remainingAmount -= invStackAmount) > 0) continue;
            return true;
        }
        return false;
    }

    public final boolean canInsert(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int remainingAmount = stack.m_41613_();
        for (ItemStack invStack : this.items) {
            int insertionAmount;
            if (!(invStack.m_41726_(stack) && invStack.m_41613_() < invStack.m_41741_() && Intrinsics.areEqual((Object)stack.m_41783_(), (Object)invStack.m_41783_()) ? (remainingAmount -= (insertionAmount = Math.min(invStack.m_41741_() - invStack.m_41613_(), remainingAmount))) <= 0 : invStack.m_41619_())) continue;
            return true;
        }
        return false;
    }

    public final boolean tryInsert(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int remainingAmount = stack.m_41613_();
        Iterator iterator = this.items.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int slot = n++;
            ItemStack invStack = (ItemStack)iterator.next();
            if (invStack.m_41726_(stack) && invStack.m_41613_() < invStack.m_41741_() && Intrinsics.areEqual((Object)invStack.m_41783_(), (Object)stack.m_41783_())) {
                int insertionAmount = Math.min(invStack.m_41741_() - invStack.m_41613_(), remainingAmount);
                invStack.m_41769_(insertionAmount);
                if ((remainingAmount -= insertionAmount) > 0) continue;
                return true;
            }
            if (!invStack.m_41619_()) continue;
            this.items.set(slot, (Object)stack.m_41777_());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int getAmountWithNbt(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Iterable iterable = (Iterable)this.items;
        int n = 0;
        for (Object t : iterable) {
            void it;
            ItemStack itemStack = (ItemStack)t;
            int n2 = n;
            boolean bl = false;
            int n3 = Intrinsics.areEqual((Object)stack.m_41720_(), (Object)it.m_41720_()) && Intrinsics.areEqual((Object)stack.m_41783_(), (Object)it.m_41783_()) ? it.m_41613_() : 0;
            n = n2 + n3;
        }
        return n;
    }

    @Override
    @NotNull
    public CompoundTag writeNbt(@NotNull CompoundTag nbt) {
        CompoundTag compoundTag;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        CompoundTag $this$writeNbt_u24lambda_u2d1 = compoundTag = nbt;
        boolean bl = false;
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        return compoundTag;
    }

    @Override
    public void readNbt(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        Object object = this.items.get(slot);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"items[slot]");
        return (ItemStack)object;
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.items.set(slot, (Object)stack);
    }

    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_((List)((List)this.items), (int)slot);
    }

    public boolean m_6542_(@Nullable Player player) {
        return true;
    }

    public int m_6643_() {
        return this.invSize;
    }

    public ItemStack m_7407_(int slot, int count) {
        ItemStack itemStack;
        ItemStack it = itemStack = ContainerHelper.m_18969_((List)((List)this.items), (int)slot, (int)count);
        boolean bl = false;
        if (!it.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    public boolean m_7983_() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = (Iterable)this.items;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    if (it.m_41619_()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public void m_6596_() {
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ContainerListener it = (ContainerListener)element$iv;
            boolean bl = false;
            it.m_5757_((Container)this);
        }
    }

    public final void addListener(@NotNull ContainerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ((Collection)this.listeners).add(listener);
    }

    public final void addListener(@NotNull Function1<? super Container, Unit> block2) {
        Intrinsics.checkNotNullParameter(block2, (String)"block");
        boolean $i$f$addListener = false;
        this.addListener(new ContainerListener(block2){
            final /* synthetic */ Function1<Container, Unit> $block;
            {
                this.$block = $block;
            }

            public final void m_5757_(Container it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.$block.invoke((Object)it);
            }
        });
    }
}

