/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.entity;

import juuxel.adorn.block.SeatBlock;
import juuxel.adorn.platform.PlatformBridges;
import juuxel.adorn.util.NbtExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010(\u001a\u0006\u0012\u0002\b\u00030'\u0012\u0006\u0010*\u001a\u00020)\u00a2\u0006\u0004\b+\u0010,J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0004J\u000f\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0004J\u000f\u0010\u0017\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0017\u0010\u000eJ\u0017\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001d\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010\"\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\b\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0018H\u0014\u00a2\u0006\u0004\b$\u0010\u001bR\u0016\u0010%\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&\u00a8\u0006-"}, d2={"Ljuuxel/adorn/entity/SeatEntity;", "Lnet/minecraft/world/entity/Entity;", "", "collides", "()Z", "Lnet/minecraft/network/protocol/Packet;", "createSpawnPacket", "()Lnet/minecraft/network/protocol/Packet;", "", "getMountedHeightOffset", "()D", "hasNoGravity", "", "initDataTracker", "()V", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/InteractionHand;", "hand", "Lnet/minecraft/world/InteractionResult;", "interact", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;", "isInvisible", "kill", "Lnet/minecraft/nbt/CompoundTag;", "tag", "readCustomDataFromNbt", "(Lnet/minecraft/nbt/CompoundTag;)V", "entity", "removePassenger", "(Lnet/minecraft/world/entity/Entity;)V", "Lnet/minecraft/core/BlockPos;", "pos", "blockOffset", "setPos", "(Lnet/minecraft/core/BlockPos;D)V", "writeCustomDataToNbt", "seatPos", "Lnet/minecraft/core/BlockPos;", "Lnet/minecraft/world/entity/EntityType;", "type", "Lnet/minecraft/world/level/Level;", "world", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "Adorn"})
public final class SeatEntity
extends Entity {
    @NotNull
    private BlockPos seatPos;

    public SeatEntity(@NotNull EntityType<?> type, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(type, world);
        this.f_19794_ = true;
        this.m_20331_(true);
        this.seatPos = new BlockPos(this.m_20182_());
    }

    public final void setPos(@NotNull BlockPos pos, double blockOffset) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!(!this.f_19853_.f_46443_)) {
            boolean bl = false;
            String string = "setPos must be called on the logical server";
            throw new IllegalStateException(string.toString());
        }
        this.m_20248_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25 + blockOffset, (double)pos.m_123343_() + 0.5);
        this.seatPos = pos;
    }

    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        player.m_20329_((Entity)this);
        return InteractionResult.SUCCESS;
    }

    protected void m_20351_(@Nullable Entity entity) {
        super.m_20351_(entity);
        this.m_6074_();
    }

    public void m_6074_() {
        this.m_20153_();
        if (!this.f_19853_.f_46443_) {
            PlatformBridges.Companion this_$iv = PlatformBridges.Companion;
            boolean $i$f$getNetwork = false;
            this_$iv.get().getNetwork().sendToTracking(this, (Packet)new ClientboundSetPassengersPacket((Entity)this));
        }
        super.m_6074_();
        BlockState state = this.f_19853_.m_8055_(this.seatPos);
        if (state.m_60734_() instanceof SeatBlock) {
            this.f_19853_.m_46597_(this.seatPos, (BlockState)state.m_61124_((Property)SeatBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public double m_6048_() {
        return 0.0;
    }

    @NotNull
    public Packet<?> m_5654_() {
        PlatformBridges.Companion this_$iv = PlatformBridges.Companion;
        boolean $i$f$getNetwork = false;
        return this_$iv.get().getNetwork().createEntitySpawnPacket(this);
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_20145_() {
        return true;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.seatPos = NbtExtensionsKt.getBlockPos(tag, "SeatPos");
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        NbtExtensionsKt.putBlockPos(tag, "SeatPos", this.seatPos);
    }
}

