/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import juuxel.adorn.block.SeatBlock;
import juuxel.adorn.block.property.OptionalProperty;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b)\u0010*J#\u0010\u0007\u001a\u00020\u00062\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J?\u0010\u001e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\nH\u0016\u00a2\u0006\u0004\b \u0010!J1\u0010%\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010$\u001a\u0004\u0018\u00010#H\u0016\u00a2\u0006\u0004\b%\u0010&\u00a8\u0006,"}, d2={"Ljuuxel/adorn/block/CarpetedBlock;", "Ljuuxel/adorn/block/SeatBlock;", "Lnet/minecraft/state/StateManager$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "builder", "", "appendProperties", "(Lnet/minecraft/world/level/block/state/StateDefinition$Builder;)V", "state", "", "canStateBeCarpeted", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/loot/context/LootContext$Builder;", "", "Lnet/minecraft/world/item/ItemStack;", "getDroppedStacks", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/storage/loot/LootContext$Builder;)Ljava/util/List;", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "context", "getPlacementState", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/core/Direction;", "direction", "neighborState", "Lnet/minecraft/world/level/LevelAccessor;", "world", "Lnet/minecraft/core/BlockPos;", "pos", "neighborPos", "getStateForNeighborUpdate", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", "isCarpetingEnabled", "()Z", "Lnet/minecraft/server/level/ServerLevel;", "Lnet/minecraft/util/RandomSource;", "random", "scheduledTick", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V", "Lnet/minecraft/block/AbstractBlock$Settings;", "settings", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "Companion", "Adorn"})
public abstract class CarpetedBlock
extends SeatBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final OptionalProperty<DyeColor> CARPET;
    private static final VoxelShape CARPET_SHAPE;
    @NotNull
    private static final Map<DyeColor, Block> COLORS_TO_BLOCKS;

    public CarpetedBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        if (this.isCarpetingEnabled()) {
            this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)CARPET, (Comparable)CARPET.getNone()));
        }
    }

    @Override
    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super.m_7926_(builder);
        if (this.isCarpetingEnabled()) {
            Property[] propertyArray = new Property[]{CARPET};
            builder.m_61104_(propertyArray);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isCarpetingEnabled()) {
            OptionalProperty.Value<DyeColor> value2;
            BlockState blockState2 = super.m_5573_(context);
            BlockState blockState3 = blockState2;
            Intrinsics.checkNotNull((Object)blockState2);
            Property property = CARPET;
            DyeColor dyeColor = CarpetedBlock.Companion.getCarpetColor(context);
            if (dyeColor == null) {
                value2 = null;
            } else {
                void p0;
                DyeColor dyeColor2 = dyeColor;
                OptionalProperty<DyeColor> optionalProperty = CARPET;
                DyeColor dyeColor3 = dyeColor2;
                Property property2 = property;
                BlockState blockState4 = blockState3;
                boolean bl = false;
                OptionalProperty.Value<DyeColor> value3 = optionalProperty.wrap((DyeColor)((Enum)p0));
                blockState3 = blockState4;
                property = property2;
                value2 = value3;
            }
            OptionalProperty.Value<DyeColor> value4 = value2;
            if (value2 == null) {
                value4 = (OptionalProperty.Value<DyeColor>)CARPET.getNone();
            }
            blockState = (BlockState)blockState3.m_61124_(property, (Comparable)value4);
        } else {
            blockState = super.m_5573_(context);
        }
        return blockState;
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel world, @NotNull BlockPos pos, @Nullable RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!this.isCarpetingEnabled()) {
            return;
        }
        OptionalProperty.Value carpet = (OptionalProperty.Value)state.m_61143_((Property)CARPET);
        if (carpet.isPresent()) {
            Block block2 = COLORS_TO_BLOCKS.get(carpet.getValue());
            if (block2 == null) {
                throw new IllegalStateException(("Unknown carpet state: " + carpet).toString());
            }
            Block carpetBlock = block2;
            if (!carpetBlock.m_49966_().m_60710_((LevelReader)world, pos)) {
                carpetBlock.m_5707_((Level)world, pos, state, null);
                Block.m_49950_((BlockState)carpetBlock.m_49966_(), (Level)((Level)world), (BlockPos)pos);
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)CARPET, (Comparable)CARPET.getNone()));
            }
        }
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        OptionalProperty.Value carpet;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (this.isCarpetingEnabled() && (carpet = (OptionalProperty.Value)state.m_61143_((Property)CARPET)).isPresent()) {
            Block block2 = COLORS_TO_BLOCKS.get(carpet.getValue());
            Intrinsics.checkNotNull((Object)block2);
            if (!block2.m_49966_().m_60710_((LevelReader)world, pos)) {
                world.m_186460_(pos, (Block)this, 1);
            }
        }
        BlockState blockState = super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"super.getStateForNeighbo\u2026 world, pos, neighborPos)");
        return blockState;
    }

    @NotNull
    public List<ItemStack> m_7381_(@NotNull BlockState state, @NotNull LootContext.Builder builder) {
        List list;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (this.isCarpetingEnabled()) {
            List list2;
            List list3 = super.m_7381_(state, builder);
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"super.getDroppedStacks(state, builder)");
            Collection collection = list3;
            Block block2 = COLORS_TO_BLOCKS.get(((OptionalProperty.Value)state.m_61143_((Property)CARPET)).getValue());
            if (block2 == null) {
                list2 = null;
            } else {
                BlockState blockState = block2.m_49966_();
                list2 = blockState == null ? null : blockState.m_60724_(builder);
            }
            list = CollectionsKt.plus((Collection)collection, (Iterable)(list2 == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)list2));
        } else {
            List list4 = super.m_7381_(state, builder);
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"{\n            super.getD\u2026state, builder)\n        }");
            list = list4;
        }
        return list;
    }

    public boolean isCarpetingEnabled() {
        return true;
    }

    public boolean canStateBeCarpeted(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.isCarpetingEnabled() && Intrinsics.areEqual((Object)state.m_61143_((Property)CARPET), CARPET.getNone());
    }

    static {
        Pair[] pairArray = EnumProperty.m_61587_((String)"carpet", DyeColor.class);
        Intrinsics.checkNotNullExpressionValue((Object)pairArray, (String)"of(\"carpet\", DyeColor::class.java)");
        CARPET = new OptionalProperty(pairArray);
        CARPET_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        pairArray = new Pair[]{TuplesKt.to((Object)DyeColor.WHITE, (Object)Blocks.f_50336_), TuplesKt.to((Object)DyeColor.ORANGE, (Object)Blocks.f_50337_), TuplesKt.to((Object)DyeColor.MAGENTA, (Object)Blocks.f_50338_), TuplesKt.to((Object)DyeColor.LIGHT_BLUE, (Object)Blocks.f_50339_), TuplesKt.to((Object)DyeColor.YELLOW, (Object)Blocks.f_50340_), TuplesKt.to((Object)DyeColor.LIME, (Object)Blocks.f_50341_), TuplesKt.to((Object)DyeColor.PINK, (Object)Blocks.f_50342_), TuplesKt.to((Object)DyeColor.GRAY, (Object)Blocks.f_50343_), TuplesKt.to((Object)DyeColor.LIGHT_GRAY, (Object)Blocks.f_50344_), TuplesKt.to((Object)DyeColor.CYAN, (Object)Blocks.f_50345_), TuplesKt.to((Object)DyeColor.PURPLE, (Object)Blocks.f_50346_), TuplesKt.to((Object)DyeColor.BLUE, (Object)Blocks.f_50347_), TuplesKt.to((Object)DyeColor.BROWN, (Object)Blocks.f_50348_), TuplesKt.to((Object)DyeColor.GREEN, (Object)Blocks.f_50349_), TuplesKt.to((Object)DyeColor.RED, (Object)Blocks.f_50350_), TuplesKt.to((Object)DyeColor.BLACK, (Object)Blocks.f_50351_)};
        COLORS_TO_BLOCKS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\"\u0010\t\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00040\u00040\u00078\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u001f\u0010\f\u001a\n \b*\u0004\u0018\u00010\u000b0\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR#\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u00108\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Ljuuxel/adorn/block/CarpetedBlock$Companion;", "", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "context", "Lnet/minecraft/world/item/DyeColor;", "getCarpetColor", "(Lnet/minecraft/world/item/context/BlockPlaceContext;)Lnet/minecraft/world/item/DyeColor;", "Ljuuxel/adorn/block/property/OptionalProperty;", "kotlin.jvm.PlatformType", "CARPET", "Ljuuxel/adorn/block/property/OptionalProperty;", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "CARPET_SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getCARPET_SHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "", "Lnet/minecraft/world/level/block/Block;", "COLORS_TO_BLOCKS", "Ljava/util/Map;", "getCOLORS_TO_BLOCKS", "()Ljava/util/Map;", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public final VoxelShape getCARPET_SHAPE() {
            return CARPET_SHAPE;
        }

        @NotNull
        public final Map<DyeColor, Block> getCOLORS_TO_BLOCKS() {
            return COLORS_TO_BLOCKS;
        }

        private final DyeColor getCarpetColor(BlockPlaceContext context) {
            Block block2 = context.m_43725_().m_8055_(context.m_8083_()).m_60734_();
            return block2 instanceof WoolCarpetBlock ? ((WoolCarpetBlock)block2).m_58309_() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

