/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.integration.voicechat;

import com.sonicether.soundphysics.SoundPhysics;
import com.sonicether.soundphysics.SoundPhysicsMod;
import com.sonicether.soundphysics.integration.voicechat.AudioChannel;
import de.maxhenkel.voicechat.api.ForgeVoicechatPlugin;
import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.VoicechatApi;
import de.maxhenkel.voicechat.api.VoicechatPlugin;
import de.maxhenkel.voicechat.api.events.ClientVoicechatConnectionEvent;
import de.maxhenkel.voicechat.api.events.CreateOpenALContextEvent;
import de.maxhenkel.voicechat.api.events.EventRegistration;
import de.maxhenkel.voicechat.api.events.OpenALSoundEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_243;
import org.lwjgl.openal.EXTThreadLocalContext;

@ForgeVoicechatPlugin
public class SimpleVoiceChatPlugin
implements VoicechatPlugin {
    private final Map<UUID, AudioChannel> audioChannels = new HashMap<UUID, AudioChannel>();

    public String getPluginId() {
        return "sound_physics_remastered";
    }

    public void initialize(VoicechatApi api) {
        SoundPhysics.LOGGER.info("Initializing Simple Voice Chat integration");
        this.audioChannels.clear();
    }

    public void registerEvents(EventRegistration registration) {
        registration.registerEvent(CreateOpenALContextEvent.class, this::onCreateALContext);
        registration.registerEvent(OpenALSoundEvent.class, this::onOpenALSound);
        registration.registerEvent(ClientVoicechatConnectionEvent.class, this::onConnection);
    }

    private void onCreateALContext(CreateOpenALContextEvent event) {
        long oldContext = EXTThreadLocalContext.alcGetThreadContext();
        EXTThreadLocalContext.alcSetThreadContext((long)event.getContext());
        SoundPhysics.LOGGER.info("Initializing sound physics for voice chat audio");
        SoundPhysics.init();
        EXTThreadLocalContext.alcSetThreadContext((long)oldContext);
    }

    private void onConnection(ClientVoicechatConnectionEvent event) {
        SoundPhysics.DEBUG_LOGGER.info("Clearing unused audio channels");
        this.audioChannels.values().removeIf(AudioChannel::canBeRemoved);
    }

    private void onOpenALSound(OpenALSoundEvent event) {
        if (!SoundPhysicsMod.CONFIG.simpleVoiceChatIntegration.get().booleanValue()) {
            return;
        }
        Position position = event.getPosition();
        UUID channelId = event.getChannelId();
        if (channelId == null) {
            return;
        }
        AudioChannel audioChannel = this.audioChannels.get(channelId);
        if (audioChannel == null) {
            audioChannel = new AudioChannel(channelId);
            this.audioChannels.put(channelId, audioChannel);
        }
        audioChannel.onSound(event.getSource(), position == null ? null : new class_243(position.getX(), position.getY(), position.getZ()));
    }
}

