/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2498;
import net.minecraft.class_2561;

public class SoundTypes {
    private static final Map<class_2498, String> TRANSLATION_MAP;

    public static Map<class_2498, String> getTranslationMap() {
        return TRANSLATION_MAP;
    }

    @Nullable
    public static String getName(class_2498 soundType) {
        return TRANSLATION_MAP.get(soundType);
    }

    @Nullable
    public static class_2498 getSoundType(String name) {
        return TRANSLATION_MAP.entrySet().stream().filter(e -> ((String)e.getValue()).equals(name)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public static class_2561 getNameComponent(class_2498 soundType) {
        String name = SoundTypes.getName(soundType);
        if (name == null) {
            return class_2561.method_43470((String)"N/A");
        }
        String[] split = name.split("_");
        StringBuilder builder = new StringBuilder();
        for (String s : split) {
            builder.append(s.charAt(0));
            builder.append(s.substring(1).toLowerCase(Locale.ROOT));
            builder.append(" ");
        }
        return class_2561.method_43470((String)builder.toString().trim());
    }

    static {
        HashMap<class_2498, String> names = new HashMap<class_2498, String>();
        names.put(class_2498.field_11547, "WOOD");
        names.put(class_2498.field_11529, "GRAVEL");
        names.put(class_2498.field_11535, "GRASS");
        names.put(class_2498.field_25183, "LILY_PAD");
        names.put(class_2498.field_11544, "STONE");
        names.put(class_2498.field_11533, "METAL");
        names.put(class_2498.field_11537, "GLASS");
        names.put(class_2498.field_11543, "WOOL");
        names.put(class_2498.field_11526, "SAND");
        names.put(class_2498.field_11548, "SNOW");
        names.put(class_2498.field_27884, "POWDER_SNOW");
        names.put(class_2498.field_11532, "LADDER");
        names.put(class_2498.field_11531, "ANVIL");
        names.put(class_2498.field_11545, "SLIME_BLOCK");
        names.put(class_2498.field_21214, "HONEY_BLOCK");
        names.put(class_2498.field_11534, "WET_GRASS");
        names.put(class_2498.field_11528, "CORAL_BLOCK");
        names.put(class_2498.field_11542, "BAMBOO");
        names.put(class_2498.field_11538, "BAMBOO_SAPLING");
        names.put(class_2498.field_16498, "SCAFFOLDING");
        names.put(class_2498.field_17579, "SWEET_BERRY_BUSH");
        names.put(class_2498.field_17580, "CROP");
        names.put(class_2498.field_18852, "HARD_CROP");
        names.put(class_2498.field_23083, "VINE");
        names.put(class_2498.field_17581, "NETHER_WART");
        names.put(class_2498.field_17734, "LANTERN");
        names.put(class_2498.field_22152, "STEM");
        names.put(class_2498.field_22153, "NYLIUM");
        names.put(class_2498.field_22154, "FUNGUS");
        names.put(class_2498.field_22138, "ROOTS");
        names.put(class_2498.field_22139, "SHROOMLIGHT");
        names.put(class_2498.field_22140, "WEEPING_VINES");
        names.put(class_2498.field_23082, "TWISTING_VINES");
        names.put(class_2498.field_22141, "SOUL_SAND");
        names.put(class_2498.field_22142, "SOUL_SOIL");
        names.put(class_2498.field_22143, "BASALT");
        names.put(class_2498.field_22144, "WART_BLOCK");
        names.put(class_2498.field_22145, "NETHERRACK");
        names.put(class_2498.field_22146, "NETHER_BRICKS");
        names.put(class_2498.field_22147, "NETHER_SPROUTS");
        names.put(class_2498.field_22148, "NETHER_ORE");
        names.put(class_2498.field_22149, "BONE_BLOCK");
        names.put(class_2498.field_22150, "NETHERITE_BLOCK");
        names.put(class_2498.field_22151, "ANCIENT_DEBRIS");
        names.put(class_2498.field_23265, "LODESTONE");
        names.put(class_2498.field_24119, "CHAIN");
        names.put(class_2498.field_24120, "NETHER_GOLD_ORE");
        names.put(class_2498.field_24121, "GILDED_BLACKSTONE");
        names.put(class_2498.field_27196, "CANDLE");
        names.put(class_2498.field_27197, "AMETHYST");
        names.put(class_2498.field_27198, "AMETHYST_CLUSTER");
        names.put(class_2498.field_27199, "SMALL_AMETHYST_BUD");
        names.put(class_2498.field_27200, "MEDIUM_AMETHYST_BUD");
        names.put(class_2498.field_27201, "LARGE_AMETHYST_BUD");
        names.put(class_2498.field_27202, "TUFF");
        names.put(class_2498.field_27203, "CALCITE");
        names.put(class_2498.field_28060, "DRIPSTONE_BLOCK");
        names.put(class_2498.field_28061, "POINTED_DRIPSTONE");
        names.put(class_2498.field_27204, "COPPER");
        names.put(class_2498.field_28692, "CAVE_VINES");
        names.put(class_2498.field_28693, "SPORE_BLOSSOM");
        names.put(class_2498.field_28694, "AZALEA");
        names.put(class_2498.field_28695, "FLOWERING_AZALEA");
        names.put(class_2498.field_28696, "MOSS_CARPET");
        names.put(class_2498.field_28697, "MOSS");
        names.put(class_2498.field_28698, "BIG_DRIPLEAF");
        names.put(class_2498.field_28699, "SMALL_DRIPLEAF");
        names.put(class_2498.field_28700, "ROOTED_DIRT");
        names.put(class_2498.field_28701, "HANGING_ROOTS");
        names.put(class_2498.field_28702, "AZALEA_LEAVES");
        names.put(class_2498.field_28116, "SCULK_SENSOR");
        names.put(class_2498.field_28427, "GLOW_LICHEN");
        names.put(class_2498.field_29033, "DEEPSLATE");
        names.put(class_2498.field_29034, "DEEPSLATE_BRICKS");
        names.put(class_2498.field_29035, "DEEPSLATE_TILES");
        names.put(class_2498.field_29036, "POLISHED_DEEPSLATE");
        TRANSLATION_MAP = Collections.unmodifiableMap(names);
    }
}

