/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.Map;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.betterx.bclib.api.v2.levelgen.features.UserGrowableFeature;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.features.NetherChunkPopulatorFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class NetherSakuraFeature
extends ContextFeature<class_3111>
implements UserGrowableFeature<class_3111> {
    public NetherSakuraFeature() {
        super(class_3111.field_24893);
    }

    @Override
    protected boolean place(class_5425 world, class_2338 pos, class_5819 random, class_3111 config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if ((double)pos.method_10264() < (double)MAX_HEIGHT * 0.75) {
            return false;
        }
        return this.grow(world, pos, random, MAX_HEIGHT, context);
    }

    protected boolean grow(class_5425 world, class_2338 pos, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        context.LOGS_DIST.clear();
        int l = MHelper.randRange((int)(15.0f * scale_factor), (int)(24.0f * scale_factor), random);
        double height = MHelper.randRange((int)(10.0f * scale_factor), (int)(15.0f * scale_factor), random);
        double radius = height * (0.2 + random.method_43058() * 0.1);
        if ((double)l + height - (double)BlocksHelper.downRay((class_1936)world, pos, (int)((double)l + height)) > 10.0) {
            return false;
        }
        l = BlocksHelper.downRay((class_1936)world, pos, l + 1);
        int l2 = l * 2 / 3;
        for (int x = -3; x <= 3; ++x) {
            int x2 = x * x;
            context.POS.method_33097(pos.method_10263() + x);
            for (int z = -3; z <= 3; ++z) {
                int z2 = z * z;
                double d = (double)(x2 + z2) + 1.4;
                if (!(d < 10.0)) continue;
                if (d < 2.8 || random.method_43056()) {
                    int start;
                    context.POS.method_33099(pos.method_10260() + z);
                    double length = (double)MHelper.randRange(l2, l, random) / (d > 2.0 ? d : 1.0);
                    if (length < 1.0) {
                        length = 1.0;
                    }
                    int y = start = MHelper.randRange(-2, 0, random);
                    while ((double)y < length) {
                        context.POS.method_33098(pos.method_10264() - y);
                        if (this.canReplace(world.method_8320((class_2338)context.POS))) {
                            BlocksHelper.setWithUpdate((class_1936)world, (class_2338)context.POS, NetherBlocks.MAT_NETHER_SAKURA.getLog().method_9564());
                            this.updateSDFFrom((class_2338)context.POS, context);
                        }
                        ++y;
                    }
                    if (NetherBlocks.MAT_NETHER_SAKURA.isTreeLog(world.method_8320((class_2338)context.POS).method_26204())) {
                        BlocksHelper.setWithUpdate((class_1936)world, (class_2338)context.POS, NetherBlocks.MAT_NETHER_SAKURA.getBark().method_9564());
                        this.updateSDFFrom((class_2338)context.POS, context);
                    }
                }
                if (!(d < 2.0)) continue;
                this.crown((class_1936)world, (class_2338)context.POS, radius, height, context);
            }
        }
        this.updateDistances(world, context);
        context.LOGS_DIST.clear();
        return true;
    }

    private void updateSDFFrom(class_2338 bpos, StructureGeneratorThreadContext context) {
        for (int x = -7; x <= 7; ++x) {
            for (int y = -7; y <= 7; ++y) {
                for (int z = -7; z <= 7; ++z) {
                    int dist;
                    if (x == 0 && y == 0 && z == 0 || (dist = Math.abs(x) + Math.abs(y) + Math.abs(z)) > 7) continue;
                    class_2338 blPos = bpos.method_10069(x, y, z);
                    context.LOGS_DIST.merge(blPos, (byte)dist, (oldDist, newDist) -> (byte)Math.min(oldDist.byteValue(), dist));
                }
            }
        }
    }

    private void updateDistances(class_5425 world, StructureGeneratorThreadContext context) {
        for (Map.Entry<class_2338, Byte> entry : context.LOGS_DIST.entrySet()) {
            byte dist = entry.getValue();
            class_2338 logPos = entry.getKey();
            class_2680 currentState = world.method_8320(logPos);
            if (!currentState.method_28498((class_2769)class_2741.field_12541)) continue;
            int cDist = (Integer)currentState.method_11654((class_2769)class_2741.field_12541);
            if (dist < cDist) {
                BlocksHelper.setWithoutUpdate((class_1936)world, logPos, (class_2680)currentState.method_11657((class_2769)class_2741.field_12541, (Comparable)Integer.valueOf(dist)));
                cDist = dist;
            }
            if (cDist < 7) continue;
            BlocksHelper.setWithoutUpdate((class_1936)world, logPos, class_2246.field_10124.method_9564());
        }
    }

    private void crown(class_1936 world, class_2338 pos, double radius, double height, StructureGeneratorThreadContext context) {
        int cz2;
        int cz;
        int cx2;
        int cx;
        class_2680 leaves = (class_2680)NetherBlocks.NETHER_SAKURA_LEAVES.method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(true));
        double r2 = radius * radius;
        int start = (int)Math.floor(-radius);
        int cy = 0;
        while ((double)cy <= radius) {
            int cy2 = cy * cy;
            context.POS2.method_33098(pos.method_10264() + cy);
            cx = start;
            while ((double)cx <= radius) {
                cx2 = cx * cx;
                context.POS2.method_33097(pos.method_10263() + cx);
                cz = start;
                while ((double)cz <= radius) {
                    cz2 = cz * cz;
                    if ((double)(cx2 + cy2 + cz2) < r2) {
                        context.POS2.method_33099(pos.method_10260() + cz);
                        if (world.method_8320((class_2338)context.POS2).method_26207().method_15800()) {
                            BlocksHelper.setWithUpdate(world, (class_2338)context.POS2, leaves);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
        int cy2 = 0;
        while ((double)cy2 <= height) {
            r2 = radius * (1.0 - (double)cy2 / height);
            r2 *= r2;
            context.POS2.method_33097(pos.method_10263());
            context.POS2.method_33099(pos.method_10260());
            context.POS2.method_33098(pos.method_10264() - cy2);
            class_2680 state = world.method_8320((class_2338)context.POS2);
            if (!state.method_26207().method_15800() && !NetherBlocks.MAT_NETHER_SAKURA.isTreeLog(state.method_26204())) {
                return;
            }
            cx = start;
            while ((double)cx <= radius) {
                cx2 = cx * cx;
                context.POS2.method_33097(pos.method_10263() + cx);
                cz = start;
                while ((double)cz <= radius) {
                    cz2 = cz * cz;
                    if ((double)(cx2 + cz2) < r2) {
                        context.POS2.method_33099(pos.method_10260() + cz);
                        if (world.method_8320((class_2338)context.POS2).method_26207().method_15800()) {
                            BlocksHelper.setWithUpdate(world, (class_2338)context.POS2, leaves);
                        }
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy2;
        }
    }

    private boolean canReplace(class_2680 state) {
        return BlocksHelper.isNetherGround(state) || state.method_26207().method_15800();
    }

    public boolean grow(class_5425 level, class_2338 pos, class_5819 random, class_3111 configuration) {
        return this.grow(level, pos, random, 128, NetherChunkPopulatorFeature.generatorForThread().context);
    }
}

