/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockAnchorTreeVine;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.AnchorTreeFeature;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.features.LucisFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class AnchorTreeRootFeature
extends ContextFeature<class_3111> {
    private static final LucisFeature LUCIS = new LucisFeature();

    public AnchorTreeRootFeature() {
        super(class_3111.field_24893);
    }

    @Override
    protected boolean place(class_5425 world, class_2338 pos, class_5819 random, class_3111 config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if ((double)pos.method_10264() < (double)MAX_HEIGHT * 0.75) {
            return false;
        }
        double angle = random.method_43058() * Math.PI * 2.0;
        double dx = Math.sin(angle);
        double dz = Math.cos(angle);
        double size = (double)MHelper.randRange(10, 25, random) * 0.5;
        int count = MHelper.floor(size * 2.0);
        if (count < 3) {
            count = 3;
        }
        if ((count & 1) == 0) {
            ++count;
        }
        context.POS.method_10102((double)pos.method_10263() - dx * size, (double)(pos.method_10264() + 10), (double)pos.method_10260() - dz * size);
        class_2338 start = context.POS.method_10086(BlocksHelper.upRay((class_1936)world, (class_2338)context.POS, (int)((double)MAX_HEIGHT * 0.75)));
        if (start.method_10264() < pos.method_10264()) {
            start = context.POS.method_10101((class_2382)start).method_10069(0, 10, 0).method_10062();
        }
        context.POS.method_10102((double)pos.method_10263() + dx * size, (double)(pos.method_10264() + 10), (double)pos.method_10260() + dz * size);
        class_2338 end = context.POS.method_10086(BlocksHelper.upRay((class_1936)world, (class_2338)context.POS, (int)((double)MAX_HEIGHT * 0.75)));
        if (end.method_10264() < pos.method_10264()) {
            end = context.POS.method_10101((class_2382)end).method_10069(0, 10, 0).method_10062();
        }
        List<class_2338> blocks = this.lineParable(start, end, count, random, 0.2);
        context.BLOCKS.clear();
        this.buildLine(blocks, 1.3 + random.method_43058(), context);
        class_2680 vine = NetherBlocks.ANCHOR_TREE_VINE.method_9564();
        int minBuildHeight = world.method_31607() + 1;
        class_3341 blockBox = BlocksHelper.decorationBounds((class_1936)world, pos, minBuildHeight, MAX_HEIGHT - 2);
        for (class_2338 bpos : context.BLOCKS) {
            int length;
            class_2680 state;
            if (bpos.method_10264() < minBuildHeight || bpos.method_10264() > MAX_HEIGHT - 2 || !BlocksHelper.isNetherGround(state = world.method_8320(bpos)) && !this.canReplace(state)) continue;
            boolean blockDown = true;
            boolean blockUp = context.BLOCKS.contains(bpos.method_10084());
            if (blockUp && (blockDown = context.BLOCKS.contains(bpos.method_10074()))) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos, NetherBlocks.MAT_ANCHOR_TREE.getLog().method_9564());
            } else {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos, NetherBlocks.MAT_ANCHOR_TREE.getBark().method_9564());
            }
            if (!blockUp && world.method_8320(bpos.method_10084()).method_26207().method_15800()) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10084(), NetherBlocks.MOSS_COVER.method_9564());
            }
            if ((bpos.method_10264() & 3) == 0 && AnchorTreeFeature.NOISE.eval((double)bpos.method_10263() * 0.1, (double)bpos.method_10264() * 0.1, (double)bpos.method_10260() * 0.1) > 0.0) {
                if (random.method_43048(32) == 0 && !context.BLOCKS.contains(bpos.method_10095())) {
                    if (random.method_43056()) {
                        AnchorTreeFeature.makeMushroom(world, bpos.method_10095(), random.method_43058() + 1.5, blockBox);
                    } else {
                        LUCIS.grow(world, bpos, random, false);
                    }
                }
                if (random.method_43048(32) == 0 && !context.BLOCKS.contains(bpos.method_10072())) {
                    if (random.method_43056()) {
                        AnchorTreeFeature.makeMushroom(world, bpos.method_10072(), random.method_43058() + 1.5, blockBox);
                    } else {
                        LUCIS.grow(world, bpos, random, false);
                    }
                }
                if (random.method_43048(32) == 0 && !context.BLOCKS.contains(bpos.method_10078())) {
                    if (random.method_43056()) {
                        AnchorTreeFeature.makeMushroom(world, bpos.method_10078(), random.method_43058() + 1.5, blockBox);
                    } else {
                        LUCIS.grow(world, bpos, random, false);
                    }
                }
                if (random.method_43048(32) == 0 && !context.BLOCKS.contains(bpos.method_10067())) {
                    if (random.method_43056()) {
                        AnchorTreeFeature.makeMushroom(world, bpos.method_10067(), random.method_43058() + 1.5, blockBox);
                    } else {
                        LUCIS.grow(world, bpos, random, false);
                    }
                }
            }
            state = AnchorTreeFeature.wallPlants[random.method_43048(AnchorTreeFeature.wallPlants.length)].method_9564();
            class_2338 _pos = bpos.method_10095();
            if (random.method_43048(8) == 0 && !context.BLOCKS.contains(_pos) && world.method_22347(_pos)) {
                BlocksHelper.setWithUpdate((class_1936)world, _pos, (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11043));
            }
            _pos = bpos.method_10072();
            if (random.method_43048(8) == 0 && !context.BLOCKS.contains(_pos) && world.method_22347(_pos)) {
                BlocksHelper.setWithUpdate((class_1936)world, _pos, (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11035));
            }
            _pos = bpos.method_10078();
            if (random.method_43048(8) == 0 && !context.BLOCKS.contains(_pos) && world.method_22347(_pos)) {
                BlocksHelper.setWithUpdate((class_1936)world, _pos, (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11034));
            }
            _pos = bpos.method_10067();
            if (random.method_43048(8) == 0 && !context.BLOCKS.contains(_pos) && world.method_22347(_pos)) {
                BlocksHelper.setWithUpdate((class_1936)world, _pos, (class_2680)state.method_11657((class_2769)BlockPlantWall.FACING, (Comparable)class_2350.field_11039));
            }
            if (!blockUp || blockDown || random.method_43048(16) != 0 || (length = BlocksHelper.downRay((class_1936)world, bpos = bpos.method_10074(), 17)) <= 4) continue;
            length = MHelper.randRange(3, length, random);
            for (int i = 0; i < length - 2; ++i) {
                BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10087(i), vine);
            }
            BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10087(length - 2), (class_2680)vine.method_11657(BlockAnchorTreeVine.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE));
            BlocksHelper.setWithoutUpdate((class_1936)world, bpos.method_10087(length - 1), (class_2680)vine.method_11657(BlockAnchorTreeVine.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
        }
        return true;
    }

    private boolean canReplace(class_2680 state) {
        return state.method_26207().method_15800() || state.method_26204() == NetherBlocks.GIANT_LUCIS || state.method_26204() == NetherBlocks.LUCIS_MUSHROOM || state.method_26204() instanceof BlockPlantWall;
    }

    private void buildLine(List<class_2338> blocks, double radius, StructureGeneratorThreadContext context) {
        for (int i = 0; i < blocks.size() - 1; ++i) {
            class_2338 a = blocks.get(i);
            class_2338 b = blocks.get(i + 1);
            if (b.method_10264() < a.method_10264()) {
                class_2338 c = b;
                b = a;
                a = c;
            }
            int count = (int)Math.ceil(Math.sqrt(b.method_10262((class_2382)a)));
            for (int j = 0; j < count; ++j) {
                this.sphere(this.lerpCos(a, b, (double)j / (double)count), radius, context);
            }
        }
    }

    private class_2338 lerpCos(class_2338 start, class_2338 end, double mix) {
        double v = this.lcos(mix);
        double x = class_3532.method_16436((double)v, (double)start.method_10263(), (double)end.method_10263());
        double y = class_3532.method_16436((double)v, (double)start.method_10264(), (double)end.method_10264());
        double z = class_3532.method_16436((double)v, (double)start.method_10260(), (double)end.method_10260());
        return new class_2338(x, y, z);
    }

    private double lcos(double mix) {
        return class_3532.method_15350((double)(0.5 - Math.cos(mix * Math.PI) * 0.5), (double)0.0, (double)1.0);
    }

    private List<class_2338> lineParable(class_2338 start, class_2338 end, int count, class_5819 random, double range) {
        ArrayList<class_2338> result = new ArrayList<class_2338>(count);
        int max = count - 1;
        int middle = count / 2;
        result.add(start);
        double size = Math.sqrt(start.method_10262((class_2382)end)) * 0.8;
        for (int i = 1; i < max; ++i) {
            double offset = (double)(i - middle) / (double)middle;
            offset = 1.0 - offset * offset;
            double delta = (double)i / (double)max;
            double x = class_3532.method_16436((double)delta, (double)start.method_10263(), (double)end.method_10263()) + random.method_43059() * range;
            double y = class_3532.method_16436((double)delta, (double)start.method_10264(), (double)end.method_10264()) - offset * size;
            double z = class_3532.method_16436((double)delta, (double)start.method_10260(), (double)end.method_10260()) + random.method_43059() * range;
            result.add(new class_2338(x, y, z));
        }
        result.add(end);
        return result;
    }

    private void sphere(class_2338 pos, double radius, StructureGeneratorThreadContext context) {
        int x1 = MHelper.floor((double)pos.method_10263() - radius);
        int y1 = MHelper.floor((double)pos.method_10264() - radius);
        int z1 = MHelper.floor((double)pos.method_10260() - radius);
        int x2 = MHelper.floor((double)pos.method_10263() + radius + 1.0);
        int y2 = MHelper.floor((double)pos.method_10264() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.method_10260() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.method_10263();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.method_10260();
                pz2 *= pz2;
                for (int y = y1; y <= y2; ++y) {
                    int py2 = y - pos.method_10264();
                    if (!((double)(px2 + pz2 + (py2 *= py2)) <= radius)) continue;
                    context.BLOCKS.add(new class_2338(x, y, z));
                }
            }
        }
    }
}

