/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.world.structures.IStructure;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public abstract class NetherBiome
extends BCLBiome {
    private static final OpenSimplexNoise SCATTER = new OpenSimplexNoise(1337L);
    private static int structureID = 0;
    private final ArrayList<StructureInfo> generatorsFloor = new ArrayList();
    private final ArrayList<StructureInfo> generatorsWall = new ArrayList();
    private final ArrayList<StructureInfo> generatorsCeil = new ArrayList();
    private final ArrayList<StructureInfo> generatorsLava = new ArrayList();
    private final ArrayList<StructureInfo> buildGeneratorsFloor = new ArrayList();
    private final ArrayList<StructureInfo> buildGeneratorsCeil = new ArrayList();
    private final ArrayList<StructureInfo> buildGeneratorsLava = new ArrayList();
    private final ArrayList<StructureInfo> buildGeneratorsUnder = new ArrayList();
    protected float plantDensity = 1.0001f;
    protected float noiseDensity = 0.3f;

    protected NetherBiome(class_2960 biomeID, class_1959 biome, BCLBiomeSettings settings) {
        super(biomeID, biome, settings);
        this.onInit();
        String group = this.configGroup();
        this.setPlantDensity(Configs.BIOMES.getFloat(group, "plants_and_structures_density", this.getPlantDensity()));
        this.setNoiseDensity(Configs.BIOMES.getFloat(group, "noise_density", this.getNoiseDensity()));
    }

    protected abstract void onInit();

    public void setPlantDensity(float density) {
        this.plantDensity = density * 1.0001f;
    }

    public float getPlantDensity() {
        return this.plantDensity;
    }

    public void setNoiseDensity(float density) {
        this.noiseDensity = 1.0f - density * 2.0f;
    }

    public float getNoiseDensity() {
        return (1.0f - this.noiseDensity) / 2.0f;
    }

    public void genSurfColumn(class_1936 world, class_2338 pos, class_5819 random) {
    }

    public void genFloorObjects(class_5425 world, class_2338 pos, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (StructureInfo info : this.generatorsFloor) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random, MAX_HEIGHT, context);
        }
    }

    public void genWallObjects(class_5425 world, class_2338 pos, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (StructureInfo info : this.generatorsWall) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random, MAX_HEIGHT, context);
        }
    }

    public void genCeilObjects(class_5425 world, class_2338 pos, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (StructureInfo info : this.generatorsCeil) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random, MAX_HEIGHT, context);
        }
    }

    public void genLavaObjects(class_5425 world, class_2338 pos, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (StructureInfo info : this.generatorsLava) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random, MAX_HEIGHT, context);
        }
    }

    protected static double getFeatureNoise(class_2338 pos, int id) {
        return SCATTER.eval((double)pos.method_10263() * 0.1, (double)pos.method_10264() * 0.1 + (double)(id * 10), (double)pos.method_10260() * 0.1);
    }

    protected void addStructure(String name, IStructure structure, StructurePlacementType type, float density, boolean useNoise) {
        String group = this.configGroup() + ".structures." + type.getName() + "." + name;
        float dens = Configs.BIOMES.getFloat(group, "density", density);
        boolean limit = Configs.BIOMES.getBoolean(group, "limit", useNoise);
        this.addStructure(structure, type, dens, limit);
    }

    private void addStructure(IStructure structure, StructurePlacementType type, float density, boolean useNoise) {
        switch (type) {
            case CEIL: {
                this.generatorsCeil.add(new StructureInfo(structure, density, useNoise));
                break;
            }
            case FLOOR: {
                this.generatorsFloor.add(new StructureInfo(structure, density, useNoise));
                break;
            }
            case WALL: {
                this.generatorsWall.add(new StructureInfo(structure, density, useNoise));
                break;
            }
            case LAVA: {
                this.generatorsLava.add(new StructureInfo(structure, density, useNoise));
                break;
            }
        }
    }

    public void genFloorBuildings(class_5425 world, class_2338 pos, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        this.chancedStructure(world, pos, random, MAX_HEIGHT, context, this.buildGeneratorsFloor);
    }

    public void genCeilBuildings(class_5425 world, class_2338 pos, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        this.chancedStructure(world, pos, random, MAX_HEIGHT, context, this.buildGeneratorsCeil);
    }

    public void genLavaBuildings(class_5425 world, class_2338 pos, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        this.chancedStructure(world, pos, random, MAX_HEIGHT, context, this.buildGeneratorsLava);
    }

    public void genUnderBuildings(class_5425 world, class_2338 pos, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        this.chancedStructure(world, pos, random, MAX_HEIGHT, context, this.buildGeneratorsUnder);
    }

    private void chancedStructure(class_5425 world, class_2338 pos, class_5819 random, int MAX_HEIGHT, StructureGeneratorThreadContext context, List<StructureInfo> infoList) {
        float chance = this.getLastChance(infoList);
        if (chance > 0.0f) {
            float rnd = random.method_43057() * chance;
            for (StructureInfo info : infoList) {
                if (!(rnd <= info.density)) continue;
                info.structure.generate(world, pos, random, MAX_HEIGHT, context);
                return;
            }
        }
    }

    private float getLastChance(List<StructureInfo> info) {
        int size = info.size();
        return size > 0 ? info.get((int)(size - 1)).density : 0.0f;
    }

    public boolean hasCeilStructures() {
        return !this.buildGeneratorsCeil.isEmpty();
    }

    protected class StructureInfo {
        final IStructure structure;
        final float density;
        final boolean useNoise;
        final int id;

        StructureInfo(IStructure structure, float density, boolean useNoise) {
            this.structure = structure;
            this.density = density;
            this.useNoise = useNoise;
            this.id = structureID++;
        }

        boolean canGenerate(class_5819 random, class_2338 pos) {
            return (!this.useNoise || NetherBiome.getFeatureNoise(pos, this.id) > (double)NetherBiome.this.noiseDensity) && random.method_43057() < this.density;
        }
    }
}

