/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3218;
import net.minecraft.class_5843;
import net.minecraft.class_6795;
import net.minecraft.class_6797;
import net.minecraft.class_6817;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.LifeCycleAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.features.BCLCommonFeatures;
import org.betterx.bclib.api.v2.levelgen.features.BCLFeature;
import org.betterx.bclib.api.v2.levelgen.features.BCLFeatureBuilder;
import org.betterx.bclib.api.v2.levelgen.features.config.PlaceFacingBlockConfig;
import org.betterx.bclib.api.v2.levelgen.features.config.TemplateFeatureConfig;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.api.v2.levelgen.features.features.ScatterFeature;
import org.betterx.bclib.api.v2.levelgen.features.features.TemplateFeature;
import org.betterx.bclib.api.v2.levelgen.structures.StructurePlacementType;
import org.betterx.bclib.api.v2.levelgen.structures.StructureWorldNBT;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.features.BiomeFeatures;
import org.betterx.betternether.registry.features.FloorFeatures;
import org.betterx.betternether.registry.features.TerrainFeatures;
import org.betterx.betternether.registry.features.TreeFeatures;
import org.betterx.betternether.registry.features.VineLikeFeatures;
import org.betterx.betternether.registry.features.WallFeatures;
import org.betterx.betternether.world.features.BlockFixFeature;
import org.betterx.betternether.world.features.CavesFeature;
import org.betterx.betternether.world.features.CleanupFeature;
import org.betterx.betternether.world.features.NetherChunkPopulatorFeature;
import org.betterx.betternether.world.features.PathsFeature;
import org.betterx.betternether.world.features.ScatterFeatureConfigs;
import org.betterx.betternether.world.features.WartCapFeature;
import org.betterx.betternether.world.structures.city.CityFeature;

public class NetherFeatures {
    private static final List<BCLFeature> defaultFeatures = Lists.newArrayList();
    public static final class_3031<ScatterFeatureConfigs.WithSize> SCATTER_WITH_SIZE = BCLFeature.register((class_2960)BetterNether.makeID("scatter_with_size"), (class_3031)new ScatterFeature(ScatterFeatureConfigs.WithSize.CODEC));
    public static final class_3031<ScatterFeatureConfigs.WithPlantAge> SCATTER_WITH_PLANT_AGE = BCLFeature.register((class_2960)BetterNether.makeID("scatter_with_age"), (class_3031)new ScatterFeature(ScatterFeatureConfigs.WithPlantAge.CODEC));
    public static final BCLFeature WART_CAP_FEATURE = BCLFeatureBuilder.start((class_2960)BetterNether.makeID("wart_cap"), (class_3031)new WartCapFeature()).count(32).squarePlacement().randomHeight10FromFloorCeil().findSolidSurface(PlaceFacingBlockConfig.HORIZONTAL, 12, false).buildAndRegister();
    public static final BCLFeature CINCINNASITE_ORE = NetherFeatures.registerOre("cincinnasite", NetherBlocks.CINCINNASITE_ORE, 10, 8, 0.0f, class_6817.field_36083, false);
    public static final BCLFeature NETHER_RUBY_ORE = NetherFeatures.registerOre("nether_ruby", NetherBlocks.NETHER_RUBY_ORE, 3, 8, 0.0f, (class_6797)class_6795.method_39634((class_5843)class_5843.method_33846((int)32), (class_5843)class_5843.method_33849((int)32)), false);
    public static final BCLFeature NETHER_RUBY_ORE_SOUL = NetherFeatures.registerOre("nether_ruby_soul", NetherBlocks.NETHER_RUBY_ORE, class_2246.field_22090, 16, 12, 0.0f, (class_6797)class_6795.method_39634((class_5843)class_5843.method_33846((int)32), (class_5843)class_5843.method_33845()), false);
    public static final BCLFeature NETHER_RUBY_ORE_LARGE = NetherFeatures.registerOre("nether_ruby_large", NetherBlocks.NETHER_RUBY_ORE, 16, 12, 0.0f, (class_6797)class_6795.method_39634((class_5843)class_5843.method_33846((int)32), (class_5843)class_5843.method_33845()), false);
    public static final BCLFeature NETHER_RUBY_ORE_RARE = NetherFeatures.registerOre("nether_ruby_rare", NetherBlocks.NETHER_RUBY_ORE, 2, 12, 0.0f, (class_6797)class_6795.method_39637((class_5843)class_5843.method_33846((int)70), (class_5843)class_5843.method_33845()), true);
    public static final BCLFeature NETHER_LAPIS_ORE = NetherFeatures.registerOre("nether_lapis", NetherBlocks.NETHER_LAPIS_ORE, 18, 4, 0.0f, (class_6797)class_6795.method_39637((class_5843)class_5843.method_33846((int)32), (class_5843)class_5843.method_33849((int)10)), false);
    public static final BCLFeature NETHER_REDSTONE_ORE = NetherFeatures.registerOre("nether_redstone", NetherBlocks.NETHER_REDSTONE_ORE, 1, 16, 0.3f, (class_6797)class_6795.method_39637((class_5843)class_5843.method_33846((int)8), (class_5843)class_5843.method_33846((int)40)), true);
    public static final BCLFeature CLEANUP_FEATURE = NetherFeatures.registerChunkFeature("nether_clean", class_2893.class_2895.field_13174, CleanupFeature::new);
    public static final BCLFeature FIX_FEATURE = NetherFeatures.registerChunkFeature("nether_fix", class_2893.class_2895.field_13179, BlockFixFeature::new);
    public static final BCLFeature CAVES_FEATURE = NetherFeatures.registerChunkFeature("nether_caves", class_2893.class_2895.field_13172, CavesFeature::new);
    public static final BCLFeature PATHS_FEATURE = NetherFeatures.registerChunkFeature("nether_paths", class_2893.class_2895.field_25186, PathsFeature::new);
    public static final BCLFeature POPULATOR_FEATURE = NetherFeatures.registerChunkFeature("nether_populator", class_2893.class_2895.field_13178, NetherChunkPopulatorFeature::new);
    public static final boolean HAS_CLEANING_PASS = Configs.GENERATOR.getBoolean("generator.world.terrain", "terrain_cleaning_pass", true);
    public static final boolean HAS_CAVES = Configs.GENERATOR.getBoolean("generator.world.environment", "generate_caves", true);
    public static final boolean HAS_PATHS = Configs.GENERATOR.getBoolean("generator.world.environment", "generate_paths", true);
    public static final boolean HAS_FIXING_PASS = Configs.GENERATOR.getBoolean("generator.world.terrain", "world_fixing_pass", true);

    private static <T extends DefaultFeature> BCLFeature registerChunkFeature(String name, class_2893.class_2895 step, Supplier<T> feature) {
        return BCLCommonFeatures.makeChunkFeature((class_2960)BetterNether.makeID("feature_" + name), (class_2893.class_2895)step, (class_3031)((class_3031)feature.get()));
    }

    private static BCLFeature registerOre(String name, class_2248 blockOre, class_2248 baseBlock, int veins, int veinSize, float airDiscardChance, class_6797 placement, boolean rare) {
        return NetherFeatures._registerOre(name + "_ore", blockOre, baseBlock, Configs.GENERATOR.getInt("generator.world.ores." + name, "vein_count", veins), Configs.GENERATOR.getInt("generator.world.ores." + name, "vein_size", veinSize), Configs.GENERATOR.getFloat("generator.world.ores." + name, "air_discard_chance", airDiscardChance), placement, rare);
    }

    private static BCLFeature registerOre(String name, class_2248 blockOre, int veins, int veinSize, float airDiscardChance, class_6797 placement, boolean rare) {
        return NetherFeatures._registerOre(name + "_ore", blockOre, class_2246.field_10515, Configs.GENERATOR.getInt("generator.world.ores." + name, "vein_count", veins), Configs.GENERATOR.getInt("generator.world.ores." + name, "vein_size", veinSize), Configs.GENERATOR.getFloat("generator.world.ores." + name, "air_discard_chance", airDiscardChance), placement, rare);
    }

    private static BCLFeature _registerOre(String name, class_2248 blockOre, class_2248 baseBlock, int veins, int veinSize, float airDiscardChance, class_6797 placementModifier, boolean rare) {
        return BCLCommonFeatures.makeOreFeature((class_2960)BetterNether.makeID(name), (class_2248)blockOre, (class_2248)baseBlock, (int)veins, (int)veinSize, (float)airDiscardChance, (class_6797)placementModifier, (boolean)rare);
    }

    public static StructureWorldNBT cfg(class_2960 location, int offsetY, StructurePlacementType type, float chance) {
        return TemplateFeatureConfig.cfg((class_2960)location, (int)offsetY, (StructurePlacementType)type, (float)chance);
    }

    private static BCLFeature registerDefault(BCLFeature f) {
        defaultFeatures.add(f);
        return f;
    }

    private static BCLFeature registerDefault(class_2960 location, List<StructureWorldNBT> structures, int onceEveryChunk) {
        return NetherFeatures.registerDefault(TemplateFeature.createAndRegister((class_2960)location, (TemplateFeatureConfig)new TemplateFeatureConfig(structures), (int)onceEveryChunk));
    }

    public static BCLBiomeBuilder addDefaultFeatures(BCLBiomeBuilder builder) {
        return builder;
    }

    public static void addDefaultBNFeatures(BCLBiomeBuilder builder) {
        for (BCLFeature f : defaultFeatures) {
            builder.feature(f);
        }
    }

    public static BCLBiomeBuilder addDefaultOres(BCLBiomeBuilder builder) {
        return builder.feature(CINCINNASITE_ORE).feature(NETHER_RUBY_ORE_RARE).feature(NETHER_LAPIS_ORE).feature(NETHER_REDSTONE_ORE);
    }

    public static void modifyNonBNBiome(class_2960 biomeID, class_6880<class_1959> biome) {
        BiomeAPI.addBiomeFeature(biome, (BCLFeature)CINCINNASITE_ORE);
        BiomeAPI.addBiomeFeature(biome, (BCLFeature)NETHER_RUBY_ORE_RARE);
        BiomeAPI.addBiomeFeature(biome, (BCLFeature)NETHER_LAPIS_ORE);
        BiomeAPI.addBiomeFeature(biome, (BCLFeature)NETHER_REDSTONE_ORE);
        if (biomeID.equals((Object)BiomeAPI.SOUL_SAND_VALLEY_BIOME.getID())) {
            BiomeAPI.addBiomeFeature(biome, (BCLFeature)NETHER_RUBY_ORE_LARGE);
        }
        if (biomeID.equals((Object)BiomeAPI.CRIMSON_FOREST_BIOME.getID()) || biomeID.equals((Object)BiomeAPI.WARPED_FOREST_BIOME.getID())) {
            BiomeAPI.addBiomeFeature(biome, (BCLFeature)NETHER_RUBY_ORE);
        }
    }

    public static void register() {
        FloorFeatures.ensureStaticInitialization();
        VineLikeFeatures.ensureStaticInitialization();
        WallFeatures.ensureStaticInitialization();
        TreeFeatures.ensureStaticInitialization();
        TerrainFeatures.ensureStaticInitialization();
        BiomeFeatures.ensureStaticInitialization();
        LifeCycleAPI.onLevelLoad(NetherFeatures::onWorldLoad);
    }

    public static void onWorldLoad(class_3218 level, long seed, class_2378<class_1959> registry) {
        CavesFeature.onLoad(seed);
        PathsFeature.onLoad(seed);
        CityFeature.initGenerator();
    }
}

