/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether;

import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2960;
import org.betterx.bclib.api.v2.WorldDataAPI;
import org.betterx.bclib.api.v2.dataexchange.DataExchangeAPI;
import org.betterx.bclib.util.Logger;
import org.betterx.betternether.Patcher;
import org.betterx.betternether.advancements.BNCriterion;
import org.betterx.betternether.commands.CommandRegistry;
import org.betterx.betternether.config.Config;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.loot.BNLoot;
import org.betterx.betternether.recipes.IntegrationRecipes;
import org.betterx.betternether.recipes.ItemRecipes;
import org.betterx.betternether.registry.BlockEntitiesRegistry;
import org.betterx.betternether.registry.BrewingRegistry;
import org.betterx.betternether.registry.FlatLevelPresetsRegistry;
import org.betterx.betternether.registry.NetherBiomes;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.betternether.registry.NetherPoiTypes;
import org.betterx.betternether.registry.NetherStructures;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.betternether.registry.SoundsRegistry;
import org.betterx.betternether.world.BNWorldGenerator;

public class BetterNether
implements ModInitializer {
    public static final String MOD_ID = "betternether";
    public static final Logger LOGGER = new Logger("betternether");
    private static boolean thinArmor = true;
    private static boolean lavafallParticles = true;
    private static float fogStart = 0.05f;
    private static float fogEnd = 0.5f;

    public void onInitialize() {
        LOGGER.info("=^..^=    BetterNether for 1.19    =^..^=");
        this.initOptions();
        SoundsRegistry.register();
        NetherBlocks.register();
        BlockEntitiesRegistry.register();
        NetherItems.register();
        NetherEntities.register();
        BNWorldGenerator.onModInit();
        NetherPoiTypes.register();
        NetherFeatures.register();
        NetherStructures.register();
        NetherBiomes.register();
        BrewingRegistry.register();
        CommandRegistry.register();
        FlatLevelPresetsRegistry.register();
        Config.save();
        IntegrationRecipes.register();
        NetherTags.register();
        ItemRecipes.register();
        BNLoot.register();
        BNCriterion.register();
        Configs.saveConfigs();
        WorldDataAPI.registerModCache((String)MOD_ID);
        DataExchangeAPI.registerMod((String)MOD_ID);
        Patcher.register();
    }

    private void initOptions() {
        thinArmor = Configs.MAIN.getBoolean("improvement", "smaller_armor_offset", true);
        lavafallParticles = Configs.MAIN.getBoolean("improvement", "lavafall_particles", true);
        float density = Configs.MAIN.getFloat("improvement", "fog_density[vanilla: 1.0]", 0.75f);
        BetterNether.changeFogDensity(density);
    }

    public static boolean hasThinArmor() {
        return thinArmor;
    }

    public static void setThinArmor(boolean value) {
        thinArmor = value;
    }

    public static boolean hasLavafallParticles() {
        return lavafallParticles;
    }

    public static void changeFogDensity(float density) {
        fogStart = -0.45f * density + 0.5f;
        fogEnd = -0.5f * density + 1.0f;
    }

    public static float getFogStart() {
        return fogStart;
    }

    public static float getFogEnd() {
        return fogEnd;
    }

    public static class_2960 makeID(String path) {
        return new class_2960(MOD_ID, path);
    }
}

