/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.util;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.access.PlayerEntityMixinAccess;
import wraith.fwaystones.util.Config;
import wraith.fwaystones.util.Utils;
import wraith.fwaystones.util.WaystonePacketHandler;
import wraith.fwaystones.util.WaystoneStorage;
import wraith.fwaystones.util.WaystonesWorldgen;

public class WaystonesEventManager {
    private WaystonesEventManager() {
    }

    public static void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (FabricWaystones.WAYSTONE_STORAGE == null) {
                FabricWaystones.WAYSTONE_STORAGE = new WaystoneStorage(server);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            if (FabricWaystones.WAYSTONE_STORAGE == null) {
                if (server.method_3816()) {
                    FabricWaystones.LOGGER.error("The Waystone storage is null. This is likely caused by a crash.");
                }
                return;
            }
            FabricWaystones.WAYSTONE_STORAGE.loadOrSaveWaystones(true);
            FabricWaystones.WAYSTONE_STORAGE = null;
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_2540 data = PacketByteBufs.create();
            data.method_10794(Config.getInstance().toNbtCompound());
            ServerPlayNetworking.send((class_3222)handler.field_14140, (class_2960)WaystonePacketHandler.WAYSTONE_CONFIG_UPDATE, (class_2540)data);
            FabricWaystones.WAYSTONE_STORAGE.sendToPlayer(handler.field_14140);
        });
        ServerLifecycleEvents.SERVER_STARTING.register(WaystonesWorldgen::registerVanillaVillageWorldgen);
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> ((PlayerEntityMixinAccess)newPlayer).syncData());
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fwaystones").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> source.method_9259(1))).executes(context -> {
            Config.getInstance().loadConfig();
            class_2540 data = PacketByteBufs.create();
            data.method_10794(Config.getInstance().toNbtCompound());
            for (class_3222 player : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)WaystonePacketHandler.WAYSTONE_CONFIG_UPDATE, (class_2540)data);
            }
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[\u00a7eFabric Waystones\u00a76] \u00a73has successfully reloaded!"), false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(source -> source.method_9259(1))).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null || FabricWaystones.WAYSTONE_STORAGE == null) {
                return 1;
            }
            String dimension = Utils.getDimensionName(player.field_6002);
            FabricWaystones.WAYSTONE_STORAGE.removeWorldWaystones(dimension);
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[\u00a7eFabric Waystones\u00a76] \u00a73Removed all waystones from " + dimension + "!")), false);
            return 1;
        }))).then(class_2170.method_9247((String)"display").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                return 1;
            }
            Config.getInstance().print(player);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"forget_all").executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                return 1;
            }
            ((PlayerEntityMixinAccess)player).forgetAllWaystones();
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76[\u00a7eFabric Waystones\u00a76] \u00a73All waystones have been forgotten!"), false);
            return 1;
        })).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> {
            class_3222 player = ((class_2168)context.getSource()).method_44023();
            if (player == null) {
                return 1;
            }
            class_3222 target = class_2186.method_9315((CommandContext)context, (String)"player");
            if (target == null) {
                return 1;
            }
            ((PlayerEntityMixinAccess)target).forgetAllWaystones();
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[\u00a7eFabric Waystones\u00a76] \u00a73All waystones have been forgotten for " + target.method_5477() + "!")), false);
            return 1;
        })))));
    }
}

