/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.LinkedList;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import wraith.fwaystones.FabricWaystones;

public final class Config {
    private static final String CONFIG_FILE = "config/fwaystones/config.json";
    private static Config instance = null;
    public class_2487 configData;
    private int difference = 0;

    private Config() {
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public static String readFile(File file) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        scanner.useDelimiter("\\Z");
        String result = scanner.next();
        scanner.close();
        return result;
    }

    public static JsonObject getJsonObject(String json) {
        return JsonParser.parseString((String)json).getAsJsonObject();
    }

    public boolean generateInVillages() {
        return this.configData.method_10562("worldgen").method_10577("generate_in_villages");
    }

    public int getMinPerVillage() {
        return this.configData.method_10562("worldgen").method_10550("min_per_village");
    }

    public int getMaxPerVillage() {
        return this.configData.method_10562("worldgen").method_10550("max_per_village");
    }

    public int getVillageStructureWeight() {
        return this.configData.method_10562("worldgen").method_10550("village_waystone_weight");
    }

    public class_2487 getWorldgenStructures() {
        return this.configData.method_10562("add_waystone_structure_piece");
    }

    public int getDiscoverItemAmount() {
        return Math.max(0, this.configData.method_10550("take_amount_from_discover_item"));
    }

    public class_2960 getDiscoverItem() {
        String discoverStr = this.configData.method_10558("discover_with_item");
        if (discoverStr.equals("none")) {
            return null;
        }
        String[] item = discoverStr.split(":");
        return item.length == 2 ? new class_2960(item[0], item[1]) : new class_2960(item[0]);
    }

    public boolean canOwnersRedeemPayments() {
        return this.configData.method_10577("can_owners_redeem_payments");
    }

    public boolean canPlayersToggleGlobal() {
        return this.configData.method_10577("can_players_toggle_global_mode");
    }

    @Nullable
    public class_2960 teleportCostItem() {
        if ("item".equals(this.configData.method_10562("teleportation_cost").method_10558("cost_type"))) {
            String[] item = this.configData.method_10562("teleportation_cost").method_10558("cost_item").split(":");
            return item.length == 2 ? new class_2960(item[0], item[1]) : new class_2960(item[0]);
        }
        return null;
    }

    public boolean storeWaystoneNbt() {
        return this.configData.method_10577("store_waystone_data_on_sneak_break");
    }

    public String teleportType() {
        return this.configData.method_10562("teleportation_cost").method_10558("cost_type");
    }

    public int baseTeleportCost() {
        return Math.abs(this.configData.method_10562("teleportation_cost").method_10550("base_cost"));
    }

    public float perDimensionMultiplier() {
        return this.configData.method_10562("teleportation_cost").method_10583("cost_multiplier_between_dimensions");
    }

    public float extraCostPerBlock() {
        return Math.abs(this.configData.method_10562("teleportation_cost").method_10583("cost_per_block_distance"));
    }

    public float getHardness() {
        return this.configData.method_10583("waystone_block_hardness");
    }

    public int getMiningLevel() {
        return this.configData.method_10550("waystone_block_required_mining_level");
    }

    public boolean consumeInfiniteScroll() {
        return this.configData.method_10577("consume_infinite_knowledge_scroll_on_use");
    }

    public boolean consumeLocalVoid() {
        return this.configData.method_10577("consume_local_void_on_use");
    }

    public boolean doLocalVoidsUseCost() {
        return !this.configData.method_10577("free_local_void_teleport");
    }

    public boolean preventNonOwnersFromBreaking() {
        return this.configData.method_10577("prevent_non_owners_from_breaking_waystone");
    }

    public int getCooldownWhenHurt() {
        return this.configData.method_10562("teleportation_cooldown").method_10550("cooldown_ticks_when_hurt");
    }

    public int getCooldownFromAbyssWatcher() {
        return this.configData.method_10562("teleportation_cooldown").method_10550("cooldown_ticks_from_abyss_watcher");
    }

    public int getCooldownFromPocketWormhole() {
        return this.configData.method_10562("teleportation_cooldown").method_10550("cooldown_ticks_from_pocket_wormhole");
    }

    public int getCooldownFromLocalVoid() {
        return this.configData.method_10562("teleportation_cooldown").method_10550("cooldown_ticks_from_local_void");
    }

    public int getCooldownFromVoidTotem() {
        return this.configData.method_10562("teleportation_cooldown").method_10550("cooldown_ticks_from_void_totem");
    }

    public int getCooldownFromWaystone() {
        return this.configData.method_10562("teleportation_cooldown").method_10550("cooldown_ticks_from_waystone");
    }

    public int getIntOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10550(key);
        }
        ++this.difference;
        return defaults.method_10550(key);
    }

    public boolean getBooleanOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10577(key);
        }
        ++this.difference;
        return defaults.method_10577(key);
    }

    private String getStringOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10558(key);
        }
        ++this.difference;
        return defaults.method_10558(key);
    }

    private class_2487 getCompoundOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10562(key);
        }
        ++this.difference;
        return defaults.method_10562(key);
    }

    private float getFloatOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10583(key);
        }
        ++this.difference;
        return defaults.method_10583(key);
    }

    public int getIntOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsInt();
        }
        ++this.difference;
        return defaults.method_10550(key);
    }

    public boolean getBooleanOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsBoolean();
        }
        ++this.difference;
        return defaults.method_10577(key);
    }

    private String getStringOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsString();
        }
        ++this.difference;
        return defaults.method_10558(key);
    }

    private float getFloatOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsFloat();
        }
        ++this.difference;
        return defaults.method_10583(key);
    }

    private class_2487 getDefaults() {
        class_2487 defaultConfig = new class_2487();
        class_2487 worldgen = new class_2487();
        worldgen.method_10556("generate_in_villages", true);
        worldgen.method_10569("min_per_village", 1);
        worldgen.method_10569("max_per_village", 1);
        worldgen.method_10569("village_waystone_weight", 2);
        defaultConfig.method_10566("worldgen", (class_2520)worldgen);
        defaultConfig.method_10556("consume_infinite_knowledge_scroll_on_use", false);
        defaultConfig.method_10556("consume_local_void_on_use", true);
        defaultConfig.method_10556("free_local_void_teleport", true);
        defaultConfig.method_10556("can_owners_redeem_payments", false);
        defaultConfig.method_10556("store_waystone_data_on_sneak_break", true);
        class_2487 cost = new class_2487();
        cost.method_10582("cost_type", "level");
        cost.method_10582("cost_item", "minecraft:ender_pearl");
        cost.method_10569("base_cost", 1);
        cost.method_10548("cost_per_block_distance", 0.0f);
        cost.method_10548("cost_multiplier_between_dimensions", 1.0f);
        defaultConfig.method_10566("teleportation_cost", (class_2520)cost);
        defaultConfig.method_10548("waystone_block_hardness", 4.0f);
        defaultConfig.method_10569("waystone_block_required_mining_level", 1);
        defaultConfig.method_10556("prevent_non_owners_from_breaking_waystone", false);
        defaultConfig.method_10556("can_players_toggle_global_mode", true);
        defaultConfig.method_10582("discover_with_item", "none");
        defaultConfig.method_10569("take_amount_from_discover_item", 0);
        class_2487 cooldown = new class_2487();
        cooldown.method_10569("cooldown_ticks_when_hurt", 0);
        cooldown.method_10569("cooldown_ticks_from_abyss_watcher", 0);
        cooldown.method_10569("cooldown_ticks_from_pocket_wormhole", 0);
        cooldown.method_10569("cooldown_ticks_from_local_void", 0);
        cooldown.method_10569("cooldown_ticks_from_void_totem", 0);
        cooldown.method_10569("cooldown_ticks_from_waystone", 0);
        defaultConfig.method_10566("teleportation_cooldown", (class_2520)cooldown);
        class_2487 waystoneStructures = new class_2487();
        waystoneStructures.method_10582("minecraft:village/plains/houses", "village_waystone");
        waystoneStructures.method_10582("minecraft:village/desert/houses", "desert_village_waystone");
        waystoneStructures.method_10582("minecraft:village/savanna/houses", "village_waystone");
        waystoneStructures.method_10582("minecraft:village/taiga/houses", "village_waystone");
        waystoneStructures.method_10582("minecraft:village/snowy/houses", "village_waystone");
        defaultConfig.method_10566("add_waystone_structure_piece", (class_2520)waystoneStructures);
        return defaultConfig;
    }

    private JsonObject toJson(class_2487 tag) {
        JsonObject json = new JsonObject();
        class_2487 defaults = this.getDefaults();
        JsonObject worldgenJson = new JsonObject();
        class_2487 worldgenTag = this.getCompoundOrDefault(tag, "worldgen", defaults);
        worldgenJson.addProperty("generate_in_villages", Boolean.valueOf(this.getBooleanOrDefault(worldgenTag, "generate_in_villages", defaults)));
        worldgenJson.addProperty("min_per_village", (Number)this.getIntOrDefault(worldgenTag, "min_per_village", defaults));
        worldgenJson.addProperty("max_per_village", (Number)this.getIntOrDefault(worldgenTag, "max_per_village", defaults));
        worldgenJson.addProperty("village_waystone_weight", (Number)this.getIntOrDefault(worldgenTag, "village_waystone_weight", defaults));
        json.add("worldgen", (JsonElement)worldgenJson);
        JsonObject costJson = new JsonObject();
        class_2487 costTag = this.getCompoundOrDefault(tag, "teleportation_cost", defaults);
        costJson.addProperty("cost_type", this.getStringOrDefault(costTag, "cost_type", defaults));
        costJson.addProperty("cost_item", this.getStringOrDefault(costTag, "cost_item", defaults));
        costJson.addProperty("base_cost", (Number)this.getIntOrDefault(costTag, "base_cost", defaults));
        costJson.addProperty("cost_per_block_distance", (Number)Float.valueOf(this.getFloatOrDefault(costTag, "cost_per_block_distance", defaults)));
        costJson.addProperty("cost_multiplier_between_dimensions", (Number)Float.valueOf(this.getFloatOrDefault(costTag, "cost_multiplier_between_dimensions", defaults)));
        json.add("teleportation_cost", (JsonElement)costJson);
        json.addProperty("discover_with_item", this.getStringOrDefault(tag, "discover_with_item", defaults));
        json.addProperty("take_amount_from_discover_item", (Number)this.getIntOrDefault(tag, "take_amount_from_discover_item", defaults));
        json.addProperty("consume_infinite_knowledge_scroll_on_use", Boolean.valueOf(this.getBooleanOrDefault(tag, "consume_infinite_knowledge_scroll_on_use", defaults)));
        json.addProperty("consume_local_void_on_use", Boolean.valueOf(this.getBooleanOrDefault(tag, "consume_local_void_on_use", defaults)));
        json.addProperty("free_local_void_teleport", Boolean.valueOf(this.getBooleanOrDefault(tag, "free_local_void_teleport", defaults)));
        json.addProperty("store_waystone_data_on_sneak_break", Boolean.valueOf(this.getBooleanOrDefault(tag, "store_waystone_data_on_sneak_break", defaults)));
        json.addProperty("can_owners_redeem_payments", Boolean.valueOf(this.getBooleanOrDefault(tag, "can_owners_redeem_payments", defaults)));
        json.addProperty("waystone_block_hardness", (Number)Float.valueOf(this.getFloatOrDefault(tag, "waystone_block_hardness", defaults)));
        json.addProperty("waystone_block_required_mining_level", (Number)this.getIntOrDefault(tag, "waystone_block_required_mining_level", defaults));
        json.addProperty("prevent_non_owners_from_breaking_waystone", Boolean.valueOf(this.getBooleanOrDefault(tag, "prevent_non_owners_from_breaking_waystone", defaults)));
        json.addProperty("can_players_toggle_global_mode", Boolean.valueOf(this.getBooleanOrDefault(tag, "can_players_toggle_global_mode", defaults)));
        JsonObject cooldownsJson = new JsonObject();
        class_2487 cooldownsTag = this.getCompoundOrDefault(tag, "teleportation_cooldown", defaults);
        cooldownsJson.addProperty("cooldown_ticks_when_hurt", (Number)this.getIntOrDefault(cooldownsTag, "cooldown_ticks_when_hurt", defaults));
        cooldownsJson.addProperty("cooldown_ticks_from_abyss_watcher", (Number)this.getIntOrDefault(cooldownsTag, "cooldown_ticks_from_abyss_watcher", defaults));
        cooldownsJson.addProperty("cooldown_ticks_from_pocket_wormhole", (Number)this.getIntOrDefault(cooldownsTag, "cooldown_ticks_from_pocket_wormhole", defaults));
        cooldownsJson.addProperty("cooldown_ticks_from_local_void", (Number)this.getIntOrDefault(cooldownsTag, "cooldown_ticks_from_local_void", defaults));
        cooldownsJson.addProperty("cooldown_ticks_from_void_totem", (Number)this.getIntOrDefault(cooldownsTag, "cooldown_ticks_from_void_totem", defaults));
        cooldownsJson.addProperty("cooldown_ticks_from_waystone", (Number)this.getIntOrDefault(cooldownsTag, "cooldown_ticks_from_waystone", defaults));
        json.add("teleportation_cooldown", (JsonElement)cooldownsJson);
        JsonObject structuresJson = new JsonObject();
        class_2487 structuresTag = this.getCompoundOrDefault(tag, "add_waystone_structure_piece", defaults);
        structuresTag.method_10541().forEach(key -> structuresJson.addProperty(key, structuresTag.method_10558(key)));
        json.add("add_waystone_structure_piece", (JsonElement)structuresJson);
        this.createFile(json, this.difference > 0);
        this.difference = 0;
        return json;
    }

    private class_2487 toNbtCompound(JsonObject json) {
        class_2487 tag = new class_2487();
        class_2487 defaults = this.getDefaults();
        class_2487 worldgen = new class_2487();
        if (json.has("worldgen")) {
            JsonObject worldgenJson = json.get("worldgen").getAsJsonObject();
            class_2487 defaultWorldgen = new class_2487();
            worldgen.method_10556("generate_in_villages", this.getBooleanOrDefault(worldgenJson, "generate_in_villages", defaultWorldgen));
            worldgen.method_10569("min_per_village", this.getIntOrDefault(worldgenJson, "min_per_village", defaultWorldgen));
            worldgen.method_10569("max_per_village", this.getIntOrDefault(worldgenJson, "max_per_village", defaultWorldgen));
            worldgen.method_10569("village_waystone_weight", this.getIntOrDefault(worldgenJson, "village_waystone_weight", defaultWorldgen));
        } else {
            ++this.difference;
            worldgen = defaults.method_10562("worldgen");
        }
        tag.method_10566("worldgen", (class_2520)worldgen);
        class_2487 cost = new class_2487();
        if (json.has("teleportation_cost")) {
            JsonObject costJson = json.get("teleportation_cost").getAsJsonObject();
            class_2487 defaultCost = new class_2487();
            cost.method_10582("cost_type", this.getStringOrDefault(costJson, "cost_type", defaultCost));
            cost.method_10582("cost_item", this.getStringOrDefault(costJson, "cost_item", defaultCost));
            cost.method_10569("base_cost", this.getIntOrDefault(costJson, "base_cost", defaultCost));
            cost.method_10548("cost_per_block_distance", this.getFloatOrDefault(costJson, "cost_per_block_distance", defaultCost));
            cost.method_10548("cost_multiplier_between_dimensions", this.getFloatOrDefault(costJson, "cost_multiplier_between_dimensions", defaultCost));
        } else {
            ++this.difference;
            cost = defaults.method_10562("teleportation_cost");
        }
        tag.method_10566("teleportation_cost", (class_2520)cost);
        tag.method_10582("discover_with_item", this.getStringOrDefault(json, "discover_with_item", defaults));
        tag.method_10569("take_amount_from_discover_item", this.getIntOrDefault(json, "take_amount_from_discover_item", defaults));
        tag.method_10556("consume_infinite_knowledge_scroll_on_use", this.getBooleanOrDefault(json, "consume_infinite_knowledge_scroll_on_use", defaults));
        tag.method_10556("consume_local_void_on_use", this.getBooleanOrDefault(json, "consume_local_void_on_use", defaults));
        tag.method_10556("free_local_void_teleport", this.getBooleanOrDefault(json, "free_local_void_teleport", defaults));
        tag.method_10556("store_waystone_data_on_sneak_break", this.getBooleanOrDefault(json, "store_waystone_data_on_sneak_break", defaults));
        tag.method_10556("can_owners_redeem_payments", this.getBooleanOrDefault(json, "can_owners_redeem_payments", defaults));
        tag.method_10548("waystone_block_hardness", this.getFloatOrDefault(json, "waystone_block_hardness", defaults));
        tag.method_10569("waystone_block_required_mining_level", this.getIntOrDefault(json, "waystone_block_required_mining_level", defaults));
        tag.method_10556("prevent_non_owners_from_breaking_waystone", this.getBooleanOrDefault(json, "prevent_non_owners_from_breaking_waystone", defaults));
        tag.method_10556("can_players_toggle_global_mode", this.getBooleanOrDefault(json, "can_players_toggle_global_mode", defaults));
        class_2487 cooldowns = new class_2487();
        if (json.has("teleportation_cooldown")) {
            JsonObject cooldownsJson = json.get("teleportation_cooldown").getAsJsonObject();
            class_2487 defaultCooldowns = defaults.method_10562("teleportation_cooldown");
            cooldowns.method_10569("cooldown_ticks_when_hurt", this.getIntOrDefault(cooldownsJson, "cooldown_ticks_when_hurt", defaultCooldowns));
            cooldowns.method_10569("cooldown_ticks_from_abyss_watcher", this.getIntOrDefault(cooldownsJson, "cooldown_ticks_from_abyss_watcher", defaultCooldowns));
            cooldowns.method_10569("cooldown_ticks_from_pocket_wormhole", this.getIntOrDefault(cooldownsJson, "cooldown_ticks_from_pocket_wormhole", defaultCooldowns));
            cooldowns.method_10569("cooldown_ticks_from_local_void", this.getIntOrDefault(cooldownsJson, "cooldown_ticks_from_local_void", defaultCooldowns));
            cooldowns.method_10569("cooldown_ticks_from_void_totem", this.getIntOrDefault(cooldownsJson, "cooldown_ticks_from_void_totem", defaultCooldowns));
            cooldowns.method_10569("cooldown_ticks_from_waystone", this.getIntOrDefault(cooldownsJson, "cooldown_ticks_from_waystone", defaultCooldowns));
        } else {
            ++this.difference;
            cooldowns = defaults.method_10562("teleportation_cooldown");
        }
        tag.method_10566("teleportation_cooldown", (class_2520)cooldowns);
        class_2487 waystoneStructuresNbt = new class_2487();
        if (json.has("add_waystone_structure_piece")) {
            JsonObject waystoneStructures = json.get("add_waystone_structure_piece").getAsJsonObject();
            for (Map.Entry entry : waystoneStructures.entrySet()) {
                waystoneStructuresNbt.method_10582((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        } else {
            ++this.difference;
            waystoneStructuresNbt = defaults.method_10562("add_waystone_structure_piece");
        }
        tag.method_10566("add_waystone_structure_piece", (class_2520)waystoneStructuresNbt);
        this.createFile(this.toJson(tag), this.difference > 0);
        this.difference = 0;
        return tag;
    }

    public boolean loadConfig() {
        try {
            return this.loadConfig(Config.getJsonObject(Config.readFile(new File(CONFIG_FILE))));
        }
        catch (Exception e) {
            FabricWaystones.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private boolean loadConfig(JsonObject fileConfig) {
        try {
            this.configData = this.toNbtCompound(fileConfig);
            return true;
        }
        catch (Exception e) {
            FabricWaystones.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    public boolean loadConfig(class_2487 config) {
        try {
            this.configData = config;
            return true;
        }
        catch (Exception e) {
            FabricWaystones.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private void createFile(JsonObject contents, boolean overwrite) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        contents = JsonParser.parseString((String)gson.toJson((JsonElement)contents)).getAsJsonObject();
        File file = new File(CONFIG_FILE);
        if (file.exists() && !overwrite) {
            return;
        }
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        file.setReadable(true);
        file.setWritable(true);
        if (contents == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(file);){
            String json = gson.toJson((JsonElement)contents).replace("\n", "").replace("\r", "");
            writer.write(gson.toJson((JsonElement)JsonParser.parseString((String)json).getAsJsonObject()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class_2487 toNbtCompound() {
        return this.configData;
    }

    public void print(class_3222 player) {
        LinkedList<JsonObject> q = new LinkedList<JsonObject>();
        q.add(this.toJson(this.configData));
        while (!q.isEmpty()) {
            JsonObject current = (JsonObject)q.poll();
            for (Map.Entry entry : current.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if (value.isJsonObject()) {
                    q.add(value.getAsJsonObject());
                    continue;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[\u00a7e" + key + "\u00a76] \u00a73 " + value)), false);
            }
        }
    }
}

