/*
 * Decompiled with CFR 0.152.
 */
package com.tterrag.blur;

import com.tterrag.blur.config.BlurConfig;
import eu.midnightdust.lib.util.MidnightColorUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import ladysnake.satin.api.event.ShaderEffectRenderCallback;
import ladysnake.satin.api.managed.ManagedShaderEffect;
import ladysnake.satin.api.managed.ShaderEffectManager;
import ladysnake.satin.api.managed.uniform.Uniform1f;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;

public class Blur
implements ClientModInitializer {
    public static final String MODID = "blur";
    public static List<String> defaultExclusions = new ArrayList<String>();
    private long start;
    private final ManagedShaderEffect blur = ShaderEffectManager.getInstance().manage(new class_2960("blur", "shaders/post/fade_in_blur.json"), shader -> shader.setUniformValue("Radius", (float)BlurConfig.radius));
    private final Uniform1f blurProgress = this.blur.findUniform1f("Progress");
    public static final Blur INSTANCE = new Blur();
    private boolean doFade = false;

    public void onInitializeClient() {
        defaultExclusions.add(class_408.class.getName());
        defaultExclusions.add("com.replaymod.lib.de.johni0702.minecraft.gui.container.AbstractGuiOverlay$UserInputGuiScreen");
        defaultExclusions.add("ai.arcblroth.projectInception.client.InceptionInterfaceScreen");
        defaultExclusions.add("net.optifine.gui.GuiChatOF");
        defaultExclusions.add("io.github.darkkronicle.advancedchatcore.chat.AdvancedChatScreen");
        BlurConfig.init((String)MODID, BlurConfig.class);
        ShaderEffectRenderCallback.EVENT.register(deltaTick -> {
            if (this.start > 0L) {
                this.blurProgress.set(this.getProgress());
                this.blur.render(deltaTick);
            }
        });
    }

    public void onScreenChange(class_437 newGui) {
        if (class_310.method_1551().field_1687 != null) {
            boolean excluded;
            boolean bl = excluded = newGui == null || BlurConfig.blurExclusions.stream().anyMatch(exclusion -> newGui.getClass().getName().contains((CharSequence)exclusion));
            if (!excluded) {
                if (BlurConfig.showScreenTitle) {
                    System.out.println(newGui.getClass().getName());
                }
                this.blur.setUniformValue("Radius", (float)BlurConfig.radius);
                if (this.doFade) {
                    this.start = System.currentTimeMillis();
                    this.doFade = false;
                }
            } else {
                this.start = -1L;
                this.doFade = true;
            }
        }
    }

    private float getProgress() {
        return Math.min((float)(System.currentTimeMillis() - this.start) / (float)BlurConfig.fadeTimeMillis, 1.0f);
    }

    public int getBackgroundColor(boolean second) {
        int a = second ? BlurConfig.gradientEndAlpha : BlurConfig.gradientStartAlpha;
        Color col = MidnightColorUtil.hex2Rgb((String)(second ? BlurConfig.gradientEnd : BlurConfig.gradientStart));
        int r = col.getRGB() >> 16 & 0xFF;
        int b = col.getRGB() >> 8 & 0xFF;
        int g = col.getRGB() & 0xFF;
        float prog = INSTANCE.getProgress();
        a = (int)((float)a * prog);
        r = (int)((float)r * prog);
        g = (int)((float)g * prog);
        b = (int)((float)b * prog);
        return a << 24 | r << 16 | b << 8 | g;
    }
}

