/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.register.helpers;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import com.epherical.croptopia.items.CropItem;
import com.epherical.croptopia.items.SeedItem;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.util.BlockConvertible;
import com.epherical.croptopia.util.FoodConstructor;
import com.epherical.croptopia.util.ItemConvertibleWithPlural;
import com.epherical.croptopia.util.RegisterFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_6862;

public class FarmlandCrop
implements ItemConvertibleWithPlural,
BlockConvertible {
    private static final List<FarmlandCrop> FARMLAND_CROPS = new ArrayList<FarmlandCrop>();
    private final String name;
    private final String dropName;
    private final boolean plural;
    private final TagCategory tagCategory;
    private final class_1792 cropItem;
    private final class_2248 cropBlock;
    private final SeedItem seedItem;
    private final class_6862<class_1959> biomes;

    public FarmlandCrop(String cropName, boolean isPlural, TagCategory category, FoodConstructor registry, class_6862<class_1959> biomes) {
        this(cropName, cropName, isPlural, category, registry, biomes);
    }

    public FarmlandCrop(String cropName, String dropName, boolean isPlural, TagCategory category, FoodConstructor registry, class_6862<class_1959> biomes) {
        Objects.requireNonNull(category);
        this.name = cropName;
        this.dropName = dropName;
        this.plural = isPlural;
        this.tagCategory = category;
        this.biomes = biomes;
        this.cropItem = registry == null ? new CropItem(CroptopiaMod.createGroup()) : new CropItem(CroptopiaMod.createGroup().method_19265(FoodConstructor.createFood(registry)));
        this.cropBlock = new CroptopiaCropBlock(CroptopiaMod.createCropSettings());
        this.seedItem = new SeedItem(this.cropBlock, CroptopiaMod.createGroup(), biomes);
        FARMLAND_CROPS.add(this);
    }

    @Override
    public class_2248 asBlock() {
        return this.cropBlock;
    }

    @Override
    public String name() {
        return this.dropName;
    }

    @Override
    public boolean hasPlural() {
        return this.plural;
    }

    public class_1792 method_8389() {
        return this.cropItem;
    }

    public TagCategory getTagCategory() {
        return this.tagCategory;
    }

    public SeedItem getSeedItem() {
        return this.seedItem;
    }

    public static List<FarmlandCrop> copy() {
        return FARMLAND_CROPS;
    }

    public static void registerBlocks(RegisterFunction<class_2248> register) {
        for (FarmlandCrop farmlandCrop : FARMLAND_CROPS) {
            register.register(CroptopiaMod.createIdentifier(farmlandCrop.name + "_crop"), farmlandCrop.asBlock());
            CroptopiaMod.cropBlocks.add(farmlandCrop.asBlock());
        }
    }

    public static void registerItems(RegisterFunction<class_1792> register) {
        for (FarmlandCrop farmlandCrop : FARMLAND_CROPS) {
            register.register(CroptopiaMod.createIdentifier(farmlandCrop.dropName), farmlandCrop.method_8389());
            if (farmlandCrop.name().equals("vanilla")) {
                register.register(CroptopiaMod.createIdentifier(farmlandCrop.name + "_seeds"), (class_1792)farmlandCrop.seedItem);
            } else {
                register.register(CroptopiaMod.createIdentifier(farmlandCrop.name + "_seed"), (class_1792)farmlandCrop.seedItem);
            }
            CroptopiaMod.cropItems.add(farmlandCrop.method_8389());
            CroptopiaMod.seeds.add(farmlandCrop.seedItem);
        }
    }
}

