/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.interfaces.mixin.IBlockState;
import alternate.current.wire.Node;
import alternate.current.wire.UpdateQueue;
import alternate.current.wire.WireNode;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;

public class WireHandler {
    static final int[] FLOW_IN_TO_FLOW_OUT = new int[]{-1, 0, 1, 1, 2, -1, 2, 1, 3, 0, -1, 0, 3, 3, 2, -1};
    static final int[][] CARDINAL_UPDATE_ORDERS = new int[][]{{0, 2, 1, 3}, {1, 3, 2, 0}, {2, 0, 3, 1}, {3, 1, 0, 2}};
    static final int[] DEFAULT_CARDINAL_UPDATE_ORDER = CARDINAL_UPDATE_ORDERS[0];
    static final int[] DEFAULT_FULL_UPDATE_ORDER = new int[]{0, 2, 1, 3, 4, 5};
    private static final int POWER_MAX = 15;
    private static final int POWER_MIN = 0;
    private static final int POWER_STEP = 1;
    private final class_3218 level;
    private final List<WireNode> network;
    private final Long2ObjectMap<Node> nodes;
    private final Queue<Node> updates;
    private int rootCount;
    private Node[] nodeCache;
    private int nodeCount;
    private boolean updating;

    public WireHandler(class_3218 level) {
        this.level = level;
        this.network = new ArrayList<WireNode>();
        this.nodes = new Long2ObjectOpenHashMap();
        this.updates = new UpdateQueue();
        this.nodeCache = new Node[16];
        this.fillNodeCache(0, 16);
    }

    private Node getOrAddNode(class_2338 pos) {
        return (Node)this.nodes.compute(pos.method_10063(), (key, node) -> {
            if (node == null) {
                return this.getNextNode(pos);
            }
            if (node.invalid) {
                return this.revalidateNode((Node)node);
            }
            return node;
        });
    }

    private Node getNextNode(class_2338 pos) {
        return this.getNextNode(pos, this.level.method_8320(pos));
    }

    private Node getNextNode(class_2338 pos, class_2680 state) {
        return state.method_27852(class_2246.field_10091) ? new WireNode(this.level, pos, state) : this.getNextNode().update(pos, state, true);
    }

    private Node getNextNode() {
        if (this.nodeCount == this.nodeCache.length) {
            this.increaseNodeCache();
        }
        return this.nodeCache[this.nodeCount++];
    }

    private void increaseNodeCache() {
        Node[] oldCache = this.nodeCache;
        this.nodeCache = new Node[oldCache.length << 1];
        for (int index = 0; index < oldCache.length; ++index) {
            this.nodeCache[index] = oldCache[index];
        }
        this.fillNodeCache(oldCache.length, this.nodeCache.length);
    }

    private void fillNodeCache(int start, int end) {
        for (int index = start; index < end; ++index) {
            this.nodeCache[index] = new Node(this.level);
        }
    }

    private Node removeNode(class_2338 pos) {
        return (Node)this.nodes.remove(pos.method_10063());
    }

    private Node revalidateNode(Node node) {
        boolean isWire;
        class_2338 pos = node.pos;
        class_2680 state = this.level.method_8320(pos);
        boolean wasWire = node.isWire();
        if (wasWire != (isWire = state.method_27852(class_2246.field_10091))) {
            return this.getNextNode(pos, state);
        }
        node.invalid = false;
        if (isWire) {
            WireNode wire = node.asWire();
            wire.prepared = false;
            wire.inNetwork = false;
        } else {
            node.update(pos, state, false);
        }
        return node;
    }

    private Node getNeighbor(Node node, int iDir) {
        Node neighbor = node.neighbors[iDir];
        if (neighbor == null || neighbor.invalid) {
            class_2350 dir = Directions.ALL[iDir];
            class_2338 pos = node.pos.method_10093(dir);
            Node oldNeighbor = neighbor;
            neighbor = this.getOrAddNode(pos);
            if (neighbor != oldNeighbor) {
                int iOpp = Directions.iOpposite(iDir);
                node.neighbors[iDir] = neighbor;
                neighbor.neighbors[iOpp] = node;
            }
        }
        return neighbor;
    }

    private void forEachNeighbor(WireNode wire, Consumer<Node> consumer) {
        int forward = wire.iFlowDir;
        int rightward = forward + 1 & 3;
        int backward = forward + 2 & 3;
        int leftward = forward + 3 & 3;
        int downward = 4;
        int upward = 5;
        Node front = this.getNeighbor(wire, forward);
        Node right = this.getNeighbor(wire, rightward);
        Node back = this.getNeighbor(wire, backward);
        Node left = this.getNeighbor(wire, leftward);
        Node below = this.getNeighbor(wire, downward);
        Node above = this.getNeighbor(wire, upward);
        consumer.accept(front);
        consumer.accept(back);
        consumer.accept(right);
        consumer.accept(left);
        consumer.accept(below);
        consumer.accept(above);
        consumer.accept(this.getNeighbor(front, rightward));
        consumer.accept(this.getNeighbor(back, leftward));
        consumer.accept(this.getNeighbor(front, leftward));
        consumer.accept(this.getNeighbor(back, rightward));
        consumer.accept(this.getNeighbor(front, downward));
        consumer.accept(this.getNeighbor(back, upward));
        consumer.accept(this.getNeighbor(front, upward));
        consumer.accept(this.getNeighbor(back, downward));
        consumer.accept(this.getNeighbor(right, downward));
        consumer.accept(this.getNeighbor(left, upward));
        consumer.accept(this.getNeighbor(right, upward));
        consumer.accept(this.getNeighbor(left, downward));
        consumer.accept(this.getNeighbor(front, forward));
        consumer.accept(this.getNeighbor(back, backward));
        consumer.accept(this.getNeighbor(right, rightward));
        consumer.accept(this.getNeighbor(left, leftward));
        consumer.accept(this.getNeighbor(below, downward));
        consumer.accept(this.getNeighbor(above, upward));
    }

    public void onWireUpdated(class_2338 pos) {
        this.invalidateNodes();
        this.findRoots(pos);
        this.tryUpdatePower();
    }

    public void onWireAdded(class_2338 pos) {
        Node node = this.getOrAddNode(pos);
        if (!node.isWire()) {
            return;
        }
        WireNode wire = node.asWire();
        wire.added = true;
        this.invalidateNodes();
        this.tryAddRoot(wire);
        this.tryUpdatePower();
    }

    public void onWireRemoved(class_2338 pos, class_2680 state) {
        Node node = this.removeNode(pos);
        WireNode wire = node == null || !node.isWire() ? new WireNode(this.level, pos, state) : node.asWire();
        wire.invalid = true;
        wire.removed = true;
        if (this.updating && wire.shouldBreak) {
            return;
        }
        this.invalidateNodes();
        this.tryAddRoot(wire);
        this.tryUpdatePower();
    }

    private void invalidateNodes() {
        if (this.updating && !this.nodes.isEmpty()) {
            ObjectIterator it = Long2ObjectMaps.fastIterator(this.nodes);
            while (it.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
                Node node = (Node)entry.getValue();
                node.invalid = true;
            }
        }
    }

    private void findRoots(class_2338 pos) {
        Node node = this.getOrAddNode(pos);
        if (!node.isWire()) {
            return;
        }
        WireNode wire = node.asWire();
        this.tryAddRoot(wire);
        if (!wire.inNetwork || wire.connections.total == 0) {
            return;
        }
        for (int iDir : DEFAULT_FULL_UPDATE_ORDER) {
            Node neighbor = this.getNeighbor(wire, iDir);
            if (neighbor.isConductor()) {
                this.findSignalSourcesAround(neighbor, Directions.iOpposite(iDir));
                continue;
            }
            if (!((IBlockState)neighbor.state).isSignalSourceTo((class_1937)this.level, neighbor.pos, Directions.ALL[iDir])) continue;
            this.findRootsAroundSignalSource(neighbor, Directions.iOpposite(iDir));
        }
    }

    private void findSignalSourcesAround(Node node, int except) {
        for (int iDir : Directions.I_EXCEPT[except]) {
            Node neighbor = this.getNeighbor(node, iDir);
            if (!((IBlockState)neighbor.state).isDirectSignalSourceTo((class_1937)this.level, neighbor.pos, Directions.ALL[iDir])) continue;
            this.findRootsAroundSignalSource(neighbor, iDir);
        }
    }

    private void findRootsAroundSignalSource(Node node, int except) {
        for (int iDir : Directions.I_EXCEPT[except]) {
            int iOpp = Directions.iOpposite(iDir);
            class_2350 opp = Directions.ALL[iOpp];
            boolean signal = ((IBlockState)node.state).isSignalSourceTo((class_1937)this.level, node.pos, opp);
            boolean directSignal = ((IBlockState)node.state).isDirectSignalSourceTo((class_1937)this.level, node.pos, opp);
            if (!signal && !directSignal) continue;
            Node neighbor = this.getNeighbor(node, iDir);
            if (signal && neighbor.isWire()) {
                this.tryAddRoot(neighbor.asWire());
                continue;
            }
            if (!directSignal || !neighbor.isConductor()) continue;
            this.findRootsAround(neighbor, iOpp);
        }
    }

    private void findRootsAround(Node node, int except) {
        for (int iDir : Directions.I_EXCEPT[except]) {
            Node neighbor = this.getNeighbor(node, iDir);
            if (!neighbor.isWire()) continue;
            this.tryAddRoot(neighbor.asWire());
        }
    }

    private void tryAddRoot(WireNode wire) {
        if (wire.prepared) {
            return;
        }
        this.prepare(wire);
        this.findPower(wire, false);
        if (this.needsPowerChange(wire)) {
            this.addRoot(wire);
        }
    }

    private void addRoot(WireNode wire) {
        this.network.add(wire);
        ++this.rootCount;
        wire.inNetwork = true;
        if (wire.connections.iFlowDir >= 0) {
            wire.iFlowDir = wire.connections.iFlowDir;
        }
    }

    private void prepare(WireNode wire) {
        if (wire.prepared) {
            return;
        }
        wire.prepared = true;
        wire.inNetwork = false;
        if (!(wire.removed || wire.shouldBreak || wire.state.method_26184((class_4538)this.level, wire.pos))) {
            wire.shouldBreak = true;
        }
        wire.virtualPower = wire.externalPower = this.getInitialPower(wire);
        wire.connections.set(this::getNeighbor);
    }

    private int getInitialPower(WireNode wire) {
        return wire.removed || wire.shouldBreak ? 0 : this.getExternalPower(wire);
    }

    private int getExternalPower(WireNode wire) {
        int power = 0;
        for (int iDir = 0; iDir < Directions.ALL.length; ++iDir) {
            Node neighbor = this.getNeighbor(wire, iDir);
            if (neighbor.isWire()) continue;
            if (neighbor.isConductor()) {
                power = Math.max(power, this.getDirectSignalTo(wire, neighbor, Directions.iOpposite(iDir)));
            }
            if (neighbor.isSignalSource()) {
                power = Math.max(power, neighbor.state.method_26195((class_1922)this.level, neighbor.pos, Directions.ALL[iDir]));
            }
            if (power < 15) continue;
            return 15;
        }
        return power;
    }

    private int getDirectSignalTo(WireNode wire, Node node, int except) {
        int power = 0;
        for (int iDir : Directions.I_EXCEPT[except]) {
            Node neighbor = this.getNeighbor(node, iDir);
            if (!neighbor.isSignalSource() || (power = Math.max(power, neighbor.state.method_26203((class_1922)this.level, neighbor.pos, Directions.ALL[iDir]))) < 15) continue;
            return 15;
        }
        return power;
    }

    private void findPower(WireNode wire, boolean ignoreNetwork) {
        if (wire.removed || wire.shouldBreak || wire.externalPower >= 14) {
            return;
        }
        wire.virtualPower = wire.externalPower;
        wire.flowIn = 0;
        this.findWirePower(wire, ignoreNetwork);
    }

    private void findWirePower(WireNode wire, boolean ignoreNetwork) {
        wire.connections.forEach(connection -> {
            if (!connection.accept) {
                return;
            }
            WireNode neighbor = connection.wire;
            if (!ignoreNetwork || !neighbor.inNetwork) {
                int power = Math.max(0, neighbor.virtualPower - 1);
                int iOpp = Directions.iOpposite(connection.iDir);
                wire.offerPower(power, iOpp);
            }
        });
    }

    private boolean needsPowerChange(WireNode wire) {
        return wire.removed || wire.shouldBreak || wire.virtualPower != wire.currentPower;
    }

    private void tryUpdatePower() {
        if (this.rootCount > 0) {
            this.updatePower();
        }
        if (!this.updating) {
            this.nodes.clear();
            this.nodeCount = 0;
        }
    }

    private void updatePower() {
        this.buildNetwork();
        this.findPoweredWires();
        this.network.clear();
        this.rootCount = 0;
        try {
            this.letPowerFlow();
        }
        catch (Throwable t) {
            this.updating = false;
            throw t;
        }
    }

    private void buildNetwork() {
        for (int index = 0; index < this.network.size(); ++index) {
            WireNode wire = this.network.get(index);
            wire.connections.forEach(connection -> {
                if (!connection.offer) {
                    return;
                }
                WireNode neighbor = connection.wire;
                if (neighbor.inNetwork) {
                    return;
                }
                this.prepare(neighbor);
                this.findPower(neighbor, false);
                if (this.needsPowerChange(neighbor)) {
                    this.addToNetwork(neighbor, connection.iDir);
                }
            }, wire.iFlowDir);
        }
    }

    private void addToNetwork(WireNode wire, int iBackupFlowDir) {
        this.network.add(wire);
        wire.inNetwork = true;
        wire.iFlowDir = iBackupFlowDir;
    }

    private void findPoweredWires() {
        for (int index = 0; index < this.network.size(); ++index) {
            WireNode wire = this.network.get(index);
            this.findPower(wire, true);
            if (index < this.rootCount || wire.removed || wire.shouldBreak || wire.virtualPower > 0) {
                this.queueWire(wire);
                continue;
            }
            --wire.virtualPower;
        }
    }

    private void letPowerFlow() {
        if (this.updating) {
            return;
        }
        this.updating = true;
        while (!this.updates.isEmpty()) {
            Node node = this.updates.poll();
            if (node.isWire()) {
                WireNode wire = node.asWire();
                if (!this.needsPowerChange(wire)) continue;
                this.findPowerFlow(wire);
                this.transmitPower(wire);
                if (!wire.setPower()) continue;
                this.queueNeighbors(wire);
                this.updateNeighborShapes(wire);
                continue;
            }
            WireNode neighborWire = node.neighborWire;
            if (neighborWire == null) continue;
            class_2338 neighborPos = neighborWire.pos;
            class_2248 neighborBlock = neighborWire.state.method_26204();
            this.updateNeighbor(node, neighborPos, neighborBlock);
        }
        this.updating = false;
    }

    private void findPowerFlow(WireNode wire) {
        int flow = FLOW_IN_TO_FLOW_OUT[wire.flowIn];
        if (flow >= 0) {
            wire.iFlowDir = flow;
        } else if (wire.connections.iFlowDir >= 0) {
            wire.iFlowDir = wire.connections.iFlowDir;
        }
    }

    private void transmitPower(WireNode wire) {
        wire.connections.forEach(connection -> {
            int iDir;
            if (!connection.offer) {
                return;
            }
            WireNode neighbor = connection.wire;
            int power = Math.max(0, wire.virtualPower - 1);
            if (neighbor.offerPower(power, iDir = connection.iDir)) {
                this.queueWire(neighbor);
            }
        }, wire.iFlowDir);
    }

    private void updateNeighborShapes(WireNode wire) {
        class_2338 wirePos = wire.pos;
        class_2680 wireState = wire.state;
        for (int iDir : DEFAULT_FULL_UPDATE_ORDER) {
            Node neighbor = this.getNeighbor(wire, iDir);
            if (neighbor.isWire()) continue;
            int iOpp = Directions.iOpposite(iDir);
            class_2350 opp = Directions.ALL[iOpp];
            this.updateNeighborShape(neighbor, opp, wirePos, wireState);
        }
    }

    private void updateNeighborShape(Node node, class_2350 fromDir, class_2338 fromPos, class_2680 fromState) {
        class_2338 pos = node.pos;
        class_2680 state = this.level.method_8320(pos);
        if (!state.method_26215() && !state.method_27852(class_2246.field_10091)) {
            class_2680 newState = state.method_26191(fromDir, fromState, (class_1936)this.level, pos, fromPos);
            class_2248.method_30094((class_2680)state, (class_2680)newState, (class_1936)this.level, (class_2338)pos, (int)2);
        }
    }

    private void queueNeighbors(WireNode wire) {
        this.forEachNeighbor(wire, neighbor -> this.queueNeighbor((Node)neighbor, wire));
    }

    private void queueNeighbor(Node node, WireNode neighborWire) {
        if (!node.isWire()) {
            node.neighborWire = neighborWire;
            this.updates.offer(node);
        }
    }

    private void queueWire(WireNode wire) {
        if (this.needsPowerChange(wire)) {
            this.updates.offer(wire);
        } else {
            this.findPowerFlow(wire);
            this.transmitPower(wire);
        }
    }

    private void updateNeighbor(Node node, class_2338 fromPos, class_2248 fromBlock) {
        class_2338 pos = node.pos;
        class_2680 state = this.level.method_8320(pos);
        if (!state.method_26215() && !state.method_27852(class_2246.field_10091)) {
            state.method_26181((class_1937)this.level, pos, fromBlock, fromPos, false);
        }
    }

    public static class Directions {
        public static final class_2350[] ALL = new class_2350[]{class_2350.field_11039, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11033, class_2350.field_11036};
        public static final class_2350[] HORIZONTAL = new class_2350[]{class_2350.field_11039, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035};
        public static final int WEST = 0;
        public static final int NORTH = 1;
        public static final int EAST = 2;
        public static final int SOUTH = 3;
        public static final int DOWN = 4;
        public static final int UP = 5;
        private static final int[][] I_EXCEPT = new int[][]{{1, 2, 3, 4, 5}, {0, 2, 3, 4, 5}, {0, 1, 3, 4, 5}, {0, 1, 2, 4, 5}, {0, 1, 2, 3, 5}, {0, 1, 2, 3, 4}};

        public static int iOpposite(int iDir) {
            return iDir ^ 2 >>> (iDir >>> 2);
        }
    }

    @FunctionalInterface
    public static interface NodeProvider {
        public Node getNeighbor(Node var1, int var2);
    }
}

