/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.wire.Node;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Iterator;

public class UpdateQueue
extends AbstractQueue<Node> {
    private static final int OFFSET = 0;
    private final Node[] tails = new Node[16];
    private Node head;
    private Node tail;
    private int size;

    @Override
    public boolean offer(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        int priority = node.priority();
        if (this.contains(node)) {
            if (node.priority == priority) {
                return false;
            }
            this.move(node, priority);
        } else {
            this.insert(node, priority);
        }
        return true;
    }

    @Override
    public Node poll() {
        if (this.head == null) {
            return null;
        }
        Node node = this.head;
        Node next = node.next;
        if (next == null) {
            this.clear();
        } else {
            if (node.priority != next.priority) {
                this.tails[node.priority + 0] = null;
            }
            node.next = null;
            next.prev = null;
            this.head = next;
            --this.size;
        }
        return node;
    }

    @Override
    public Node peek() {
        return this.head;
    }

    @Override
    public void clear() {
        Node node = this.head;
        while (node != null) {
            Node n = node;
            node = node.next;
            n.prev = null;
            n.next = null;
        }
        Arrays.fill(this.tails, null);
        this.head = null;
        this.tail = null;
        this.size = 0;
    }

    @Override
    public Iterator<Node> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    public boolean contains(Node node) {
        return node == this.head || node.prev != null;
    }

    private void move(Node node, int priority) {
        this.remove(node);
        this.insert(node, priority);
    }

    private void remove(Node node) {
        Node prev = node.prev;
        Node next = node.next;
        if (node == this.tail || node.priority != next.priority) {
            this.tails[node.priority + 0] = node == this.head || node.priority != prev.priority ? null : prev;
        }
        if (node == this.head) {
            this.head = next;
        } else {
            prev.next = next;
        }
        if (node == this.tail) {
            this.tail = prev;
        } else {
            next.prev = prev;
        }
        node.prev = null;
        node.next = null;
        --this.size;
    }

    private void insert(Node node, int priority) {
        node.priority = priority;
        if (this.head == null) {
            this.head = this.tail = node;
        } else if (priority > this.head.priority) {
            this.linkHead(node);
        } else if (priority <= this.tail.priority) {
            this.linkTail(node);
        } else {
            this.linkAfter(this.findPrev(node), node);
        }
        this.tails[priority + 0] = node;
        ++this.size;
    }

    private void linkHead(Node node) {
        node.next = this.head;
        this.head.prev = node;
        this.head = node;
    }

    private void linkTail(Node node) {
        this.tail.next = node;
        node.prev = this.tail;
        this.tail = node;
    }

    private void linkAfter(Node prev, Node node) {
        this.linkBetween(prev, node, prev.next);
    }

    private void linkBetween(Node prev, Node node, Node next) {
        prev.next = node;
        node.prev = prev;
        node.next = next;
        next.prev = node;
    }

    private Node findPrev(Node node) {
        Node prev = null;
        for (int i = node.priority + 0; i < this.tails.length && (prev = this.tails[i]) == null; ++i) {
        }
        return prev;
    }
}

