/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.tag.CommonBlockTags;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.util.GlobalState;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.structures.piece.MountainPiece;

public class CrystalMountainPiece
extends MountainPiece {
    private class_2680 top;

    public CrystalMountainPiece(class_2338 center, float radius, float height, class_5819 random, class_6880<class_1959> biome) {
        super(EndStructures.MOUNTAIN_PIECE, center, radius, height, random, biome);
        this.top = EndBiome.findTopMaterial((class_1959)biome.comp_349());
    }

    public CrystalMountainPiece(class_6625 type, class_2487 tag) {
        super(EndStructures.MOUNTAIN_PIECE, tag);
    }

    @Override
    protected void fromNbt(class_2487 tag) {
        super.fromNbt(tag);
        this.top = EndBiome.findTopMaterial(BiomeAPI.getBiome((class_2960)this.biomeID));
    }

    public void method_14931(class_5281 world, class_5138 arg, class_2794 chunkGenerator, class_5819 random, class_3341 blockBox, class_1923 chunkPos, class_2338 blockPos) {
        int height;
        int z;
        int x;
        int radius;
        int i;
        int sx = chunkPos.method_8326();
        int sz = chunkPos.method_8328();
        class_2338.class_2339 pos = GlobalState.stateForThread().POS;
        class_2791 chunk = world.method_8392(chunkPos.field_9181, chunkPos.field_9180);
        class_2902 map = chunk.method_12032(class_2902.class_2903.field_13202);
        class_2902 map2 = chunk.method_12032(class_2902.class_2903.field_13194);
        for (int x2 = 0; x2 < 16; ++x2) {
            int px = x2 + sx;
            int px2 = px - this.center.method_10263();
            px2 *= px2;
            pos.method_33097(x2);
            for (int z2 = 0; z2 < 16; ++z2) {
                float maxY;
                float dist;
                int pz = z2 + sz;
                int pz2 = pz - this.center.method_10260();
                if (!((dist = (float)(px2 + (pz2 *= pz2))) < this.r2)) continue;
                pos.method_33099(z2);
                dist = 1.0f - (float)Math.pow(dist / this.r2, 0.3);
                int minY = map.method_12603(x2, z2);
                if (minY < 10) continue;
                pos.method_33098(minY);
                while (!chunk.method_8320((class_2338)pos).method_26164(CommonBlockTags.GEN_END_STONES) && pos.method_10264() > 56 && !chunk.method_8320(pos.method_10074()).method_27852(class_2246.field_10543)) {
                    pos.method_33098(pos.method_10264() - 1);
                }
                minY = pos.method_10264();
                if ((minY = Math.max(minY, map2.method_12603(x2, z2))) <= this.center.method_10264() - 8 || !((maxY = dist * this.height * this.getHeightClamp(world, 12, px, pz)) > 0.0f)) continue;
                maxY *= (float)this.noise1.eval((double)px * 0.05, (double)pz * 0.05) * 0.3f + 0.7f;
                maxY *= (float)this.noise1.eval((double)px * 0.1, (double)pz * 0.1) * 0.1f + 0.8f;
                int maxYI = (int)(maxY += (float)this.center.method_10264());
                int cover = maxYI - 1;
                boolean needCover = this.noise1.eval((double)px * 0.1, (double)pz * 0.1) + MHelper.randRange((double)-0.4, (double)0.4, (class_5819)random) - (double)(this.center.method_10264() + 14) * 0.1 > 0.0;
                for (int y = minY - 1; y < maxYI; ++y) {
                    pos.method_33098(y);
                    chunk.method_12010((class_2338)pos, needCover && y == cover ? this.top : class_2246.field_10471.method_9564(), false);
                }
            }
        }
        map = chunk.method_12032(class_2902.class_2903.field_13202);
        int count = (map.method_12603(8, 8) - (this.center.method_10264() + 24)) / 7;
        count = class_3532.method_15340((int)count, (int)0, (int)8);
        for (i = 0; i < count; ++i) {
            radius = MHelper.randRange((int)2, (int)3, (class_5819)random);
            float fill = MHelper.randRange((float)0.0f, (float)1.0f, (class_5819)random);
            x = MHelper.randRange((int)radius, (int)(15 - radius), (class_5819)random);
            int y = map.method_12603(x, z = MHelper.randRange((int)radius, (int)(15 - radius), (class_5819)random));
            if (y <= 80) continue;
            pos.method_10103(x, y, z);
            if (!chunk.method_8320(pos.method_10074()).method_27852(class_2246.field_10471)) continue;
            height = MHelper.floor((double)((float)radius * MHelper.randRange((float)1.5f, (float)3.0f, (class_5819)random) + (float)(y - 80) * 0.3f));
            this.crystal(chunk, (class_2338)pos, radius, height, fill, random);
        }
        count = (map.method_12603(8, 8) - (this.center.method_10264() + 24)) / 2;
        count = class_3532.method_15340((int)count, (int)4, (int)8);
        for (i = 0; i < count; ++i) {
            radius = MHelper.randRange((int)1, (int)2, (class_5819)random);
            float fill = random.method_43056() ? 0.0f : 1.0f;
            x = MHelper.randRange((int)radius, (int)(15 - radius), (class_5819)random);
            int y = map.method_12603(x, z = MHelper.randRange((int)radius, (int)(15 - radius), (class_5819)random));
            if (y <= 80) continue;
            pos.method_10103(x, y, z);
            if (chunk.method_8320(pos.method_10074()).method_26204() != class_2246.field_10471) continue;
            height = MHelper.floor((double)((float)radius * MHelper.randRange((float)1.5f, (float)3.0f, (class_5819)random) + (float)(y - 80) * 0.3f));
            this.crystal(chunk, (class_2338)pos, radius, height, fill, random);
        }
    }

    private void crystal(class_2791 chunk, class_2338 pos, int radius, int height, float fill, class_5819 random) {
        class_2338.class_2339 mut = new class_2338.class_2339();
        int max = MHelper.floor((double)(fill * (float)radius + (float)radius + 0.5f));
        height += pos.method_10264();
        class_2902 map = chunk.method_12032(class_2902.class_2903.field_13202);
        int coefX = MHelper.randRange((int)-1, (int)1, (class_5819)random);
        int coefZ = MHelper.randRange((int)-1, (int)1, (class_5819)random);
        for (int x = -radius; x <= radius; ++x) {
            mut.method_33097(x + pos.method_10263());
            if (mut.method_10263() < 0 || mut.method_10263() >= 16) continue;
            int ax = Math.abs(x);
            for (int z = -radius; z <= radius; ++z) {
                int az;
                mut.method_33099(z + pos.method_10260());
                if (mut.method_10260() < 0 || mut.method_10260() >= 16 || ax + (az = Math.abs(z)) >= max) continue;
                int minY = map.method_12603(mut.method_10263(), mut.method_10260()) - MHelper.randRange((int)3, (int)7, (class_5819)random);
                if (pos.method_10264() - minY > 8) {
                    minY = pos.method_10264() - 8;
                }
                int h = coefX * x + coefZ * z + height;
                for (int y = minY; y < h; ++y) {
                    mut.method_33098(y);
                    chunk.method_12010((class_2338)mut, EndBlocks.AURORA_CRYSTAL.method_9564(), false);
                }
            }
        }
    }
}

