/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain.caves;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.generator.BiomePicker;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.api.v2.tag.CommonBlockTags;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;

public abstract class EndCaveFeature
extends DefaultFeature {
    protected static final class_2680 CAVE_AIR = class_2246.field_10543.method_9564();
    protected static final class_2680 END_STONE = class_2246.field_10471.method_9564();
    protected static final class_2680 WATER = class_2246.field_10382.method_9564();
    private static final class_2382[] SPHERE;

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        class_5819 random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        if (pos.method_10263() * pos.method_10263() + pos.method_10260() * pos.method_10260() <= 2500) {
            return false;
        }
        if (this.biomeMissingCaves(world, pos)) {
            return false;
        }
        int radius = MHelper.randRange((int)10, (int)30, (class_5819)random);
        class_2338 center = this.findPos(world, pos, radius, random);
        if (center == null) {
            return false;
        }
        BiomePicker.ActualBiome biome = EndBiomes.getCaveBiome(pos.method_10263(), pos.method_10260());
        Set<class_2338> caveBlocks = this.generate(world, center, radius, random);
        if (!caveBlocks.isEmpty()) {
            if (biome != null) {
                this.setBiomes(world, biome, caveBlocks);
                Set floorPositions = Sets.newConcurrentHashSet();
                Set ceilPositions = Sets.newConcurrentHashSet();
                caveBlocks.parallelStream().forEach(bpos -> {
                    if (world.method_8320(bpos).method_26207().method_15800()) {
                        class_2338 side = bpos.method_10074();
                        if (world.method_8320(side).method_26164(CommonBlockTags.GEN_END_STONES)) {
                            floorPositions.add(side);
                        }
                        if (world.method_8320(side = bpos.method_10084()).method_26164(CommonBlockTags.GEN_END_STONES)) {
                            ceilPositions.add(side);
                        }
                    }
                });
                class_2680 surfaceBlock = EndBiome.findTopMaterial(biome.bclBiome);
                this.placeFloor(world, (EndCaveBiome)biome.bclBiome, floorPositions, random, surfaceBlock);
                this.placeCeil(world, (EndCaveBiome)biome.bclBiome, ceilPositions, random);
                this.placeWalls(world, (EndCaveBiome)biome.bclBiome, caveBlocks, random);
            }
            this.fixBlocks(world, caveBlocks);
        }
        return true;
    }

    protected abstract Set<class_2338> generate(class_5281 var1, class_2338 var2, int var3, class_5819 var4);

    protected void placeFloor(class_5281 world, EndCaveBiome biome, Set<class_2338> floorPositions, class_5819 random, class_2680 surfaceBlock) {
        float density = biome.getFloorDensity();
        floorPositions.forEach(pos -> {
            class_3031<?> feature;
            if (!surfaceBlock.method_27852(class_2246.field_10471)) {
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)surfaceBlock);
            }
            if (density > 0.0f && random.method_43057() <= density && (feature = biome.getFloorFeature(random)) != null) {
                feature.method_13151(new class_5821(Optional.empty(), world, null, random, pos.method_10084(), null));
            }
        });
    }

    protected void placeCeil(class_5281 world, EndCaveBiome biome, Set<class_2338> ceilPositions, class_5819 random) {
        float density = biome.getCeilDensity();
        ceilPositions.forEach(pos -> {
            class_3031<?> feature;
            class_2680 ceilBlock = biome.getCeil((class_2338)pos);
            if (ceilBlock != null) {
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)ceilBlock);
            }
            if (density > 0.0f && random.method_43057() <= density && (feature = biome.getCeilFeature(random)) != null) {
                feature.method_13151(new class_5821(Optional.empty(), world, null, random, pos.method_10074(), null));
            }
        });
    }

    protected void placeWalls(class_5281 world, EndCaveBiome biome, Set<class_2338> positions, class_5819 random) {
        HashSet placed = Sets.newHashSet();
        positions.forEach(pos -> {
            class_2680 wallBlock;
            if (random.method_43048(4) == 0 && this.hasOpenSide((class_2338)pos, positions) && (wallBlock = biome.getWall((class_2338)pos)) != null) {
                for (class_2382 offset : SPHERE) {
                    class_2338 wallPos = pos.method_10081(offset);
                    if (positions.contains(wallPos) || placed.contains(wallPos) || !world.method_8320(wallPos).method_26164(CommonBlockTags.GEN_END_STONES)) continue;
                    wallBlock = biome.getWall(wallPos);
                    BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)wallPos, (class_2680)wallBlock);
                    placed.add(wallPos);
                }
            }
        });
    }

    private boolean hasOpenSide(class_2338 pos, Set<class_2338> positions) {
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            if (positions.contains(pos.method_10093(dir))) continue;
            return true;
        }
        return false;
    }

    protected void setBiomes(class_5281 world, BiomePicker.ActualBiome biome, Set<class_2338> blocks) {
        blocks.forEach(pos -> this.setBiome(world, (class_2338)pos, biome));
    }

    protected void setBiome(class_5281 world, class_2338 pos, BiomePicker.ActualBiome biome) {
        BiomeAPI.setBiome((class_1936)world, (class_2338)pos, (class_6880)biome.biome);
    }

    private class_2338 findPos(class_5281 world, class_2338 pos, int radius, class_5819 random) {
        int top = world.method_8624(class_2902.class_2903.field_13194, pos.method_10263(), pos.method_10260());
        class_2338.class_2339 bpos = new class_2338.class_2339();
        bpos.method_33097(pos.method_10263());
        bpos.method_33099(pos.method_10260());
        bpos.method_33098(top - 1);
        class_2680 state = world.method_8320((class_2338)bpos);
        while (!state.method_26164(CommonBlockTags.GEN_END_STONES) && bpos.method_10264() > 5) {
            bpos.method_33098(bpos.method_10264() - 1);
            state = world.method_8320((class_2338)bpos);
        }
        if (bpos.method_10264() < 10) {
            return null;
        }
        top = (int)((float)bpos.method_10264() - ((float)radius * 1.3f + 5.0f));
        while (state.method_26164(CommonBlockTags.GEN_END_STONES) || !state.method_26227().method_15769() && bpos.method_10264() > 5) {
            bpos.method_33098(bpos.method_10264() - 1);
            state = world.method_8320((class_2338)bpos);
        }
        int bottom = (int)((float)bpos.method_10264() + (float)radius * 1.3f + 5.0f);
        if (top <= bottom) {
            return null;
        }
        return new class_2338(pos.method_10263(), MHelper.randRange((int)bottom, (int)top, (class_5819)random), pos.method_10260());
    }

    protected void fixBlocks(class_5281 world, Set<class_2338> caveBlocks) {
        class_2338 pos = caveBlocks.iterator().next();
        class_2338.class_2339 start = new class_2338.class_2339().method_10101((class_2382)pos);
        class_2338.class_2339 end = new class_2338.class_2339().method_10101((class_2382)pos);
        caveBlocks.forEach(bpos -> {
            if (bpos.method_10263() < start.method_10263()) {
                start.method_33097(bpos.method_10263());
            }
            if (bpos.method_10263() > end.method_10263()) {
                end.method_33097(bpos.method_10263());
            }
            if (bpos.method_10264() < start.method_10264()) {
                start.method_33098(bpos.method_10264());
            }
            if (bpos.method_10264() > end.method_10264()) {
                end.method_33098(bpos.method_10264());
            }
            if (bpos.method_10260() < start.method_10260()) {
                start.method_33099(bpos.method_10260());
            }
            if (bpos.method_10260() > end.method_10260()) {
                end.method_33099(bpos.method_10260());
            }
        });
        BlockFixer.fixBlocks((class_1936)world, start.method_10069(-2, -2, -2), end.method_10069(2, 2, 2));
    }

    protected boolean isWaterNear(class_5281 world, class_2338 pos) {
        for (class_2350 dir : BlocksHelper.DIRECTIONS) {
            if (world.method_8316(pos.method_10079(dir, 5)).method_15769()) continue;
            return true;
        }
        return false;
    }

    protected boolean biomeMissingCaves(class_5281 world, class_2338 pos) {
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                class_6880 biome = world.method_23753(pos.method_10069(x << 4, 0, z << 4));
                BCLBiome endBiome = BiomeAPI.getFromBiome((class_6880)biome);
                boolean hasCaves = (Boolean)endBiome.getCustomData("has_caves", (Object)true);
                if (hasCaves || !BiomeAPI.wasRegisteredAsEndLandBiome((class_2960)endBiome.getID())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ArrayList prePos = Lists.newArrayList();
        int radius = 5;
        int r2 = radius * radius;
        for (int x = -radius; x <= radius; ++x) {
            int x2 = x * x;
            for (int y = -radius; y <= radius; ++y) {
                int y2 = y * y;
                for (int z = -radius; z <= radius; ++z) {
                    int z2 = z * z;
                    if (x2 + y2 + z2 >= r2) continue;
                    prePos.add(new class_2382(x, y, z));
                }
            }
        }
        SPHERE = prePos.toArray(new class_2382[0]);
    }
}

