/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain.caves;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.api.v2.tag.CommonBlockTags;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.util.BlockFixer;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;

public class CaveChunkPopulatorFeature
extends DefaultFeature {
    private final Supplier<EndCaveBiome> supplier;

    public CaveChunkPopulatorFeature(Supplier<EndCaveBiome> biome) {
        this.supplier = biome;
    }

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        class_5819 random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        HashSet floorPositions = Sets.newHashSet();
        HashSet ceilPositions = Sets.newHashSet();
        int sx = pos.method_10263() >> 4 << 4;
        int sz = pos.method_10260() >> 4 << 4;
        class_2338.class_2339 min = new class_2338.class_2339().method_10101((class_2382)pos);
        class_2338.class_2339 max = new class_2338.class_2339().method_10101((class_2382)pos);
        this.fillSets(sx, sz, world.method_22350(pos), floorPositions, ceilPositions, min, max);
        EndCaveBiome biome = this.supplier.get();
        class_2680 surfaceBlock = class_2246.field_10471.method_9564();
        this.placeFloor(world, biome, floorPositions, random, surfaceBlock);
        this.placeCeil(world, biome, ceilPositions, random);
        BlockFixer.fixBlocks((class_1936)world, (class_2338)min, (class_2338)max);
        return true;
    }

    protected void fillSets(int sx, int sz, class_2791 chunk, Set<class_2338> floorPositions, Set<class_2338> ceilPositions, class_2338.class_2339 min, class_2338.class_2339 max) {
        class_2338.class_2339 mut = new class_2338.class_2339();
        class_2338.class_2339 mut2 = new class_2338.class_2339();
        class_2338.class_2339 mut3 = new class_2338.class_2339();
        for (int x = 0; x < 16; ++x) {
            mut.method_33097(x);
            mut2.method_33097(x);
            for (int z = 0; z < 16; ++z) {
                mut.method_33099(z);
                mut2.method_33099(z);
                mut2.method_33098(0);
                for (int y = 1; y < chunk.method_31600(); ++y) {
                    mut.method_33098(y);
                    class_2680 top = chunk.method_8320((class_2338)mut);
                    class_2680 bottom = chunk.method_8320((class_2338)mut2);
                    if (top.method_26215() && (bottom.method_26164(CommonBlockTags.GEN_END_STONES) || bottom.method_27852(class_2246.field_10340))) {
                        mut3.method_10101((class_2382)mut2).method_10100(sx, 0, sz);
                        floorPositions.add(mut3.method_10062());
                        this.updateMin((class_2338)mut3, min);
                        this.updateMax((class_2338)mut3, max);
                    } else if (bottom.method_26215() && (top.method_26164(CommonBlockTags.GEN_END_STONES) || top.method_27852(class_2246.field_10340))) {
                        mut3.method_10101((class_2382)mut).method_10100(sx, 0, sz);
                        ceilPositions.add(mut3.method_10062());
                        this.updateMin((class_2338)mut3, min);
                        this.updateMax((class_2338)mut3, max);
                    }
                    mut2.method_33098(y);
                }
            }
        }
    }

    private void updateMin(class_2338 pos, class_2338.class_2339 min) {
        if (pos.method_10263() < min.method_10263()) {
            min.method_33097(pos.method_10263());
        }
        if (pos.method_10264() < min.method_10264()) {
            min.method_33098(pos.method_10264());
        }
        if (pos.method_10260() < min.method_10260()) {
            min.method_33099(pos.method_10260());
        }
    }

    private void updateMax(class_2338 pos, class_2338.class_2339 max) {
        if (pos.method_10263() > max.method_10263()) {
            max.method_33097(pos.method_10263());
        }
        if (pos.method_10264() > max.method_10264()) {
            max.method_33098(pos.method_10264());
        }
        if (pos.method_10260() > max.method_10260()) {
            max.method_33099(pos.method_10260());
        }
    }

    protected void placeFloor(class_5281 world, EndCaveBiome biome, Set<class_2338> floorPositions, class_5819 random, class_2680 surfaceBlock) {
        float density = biome.getFloorDensity();
        floorPositions.forEach(pos -> {
            class_3031<?> feature;
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)surfaceBlock);
            if (density > 0.0f && random.method_43057() <= density && (feature = biome.getFloorFeature(random)) != null) {
                feature.method_13151(new class_5821(Optional.empty(), world, null, random, pos.method_10084(), null));
            }
        });
    }

    protected void placeCeil(class_5281 world, EndCaveBiome biome, Set<class_2338> ceilPositions, class_5819 random) {
        float density = biome.getCeilDensity();
        ceilPositions.forEach(pos -> {
            class_3031<?> feature;
            class_2680 ceilBlock = biome.getCeil((class_2338)pos);
            if (ceilBlock != null) {
                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)ceilBlock);
            }
            if (density > 0.0f && random.method_43057() <= density && (feature = biome.getCeilFeature(random)) != null) {
                feature.method_13151(new class_5821(Optional.empty(), world, null, random, pos.method_10074(), null));
            }
        });
    }
}

