/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFRotation;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnion;
import org.betterx.bclib.sdf.primitive.SDFCappedCone;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndBlocks;

public class IceStarFeature
extends DefaultFeature {
    private final float minSize;
    private final float maxSize;
    private final int minCount;
    private final int maxCount;

    public IceStarFeature(float minSize, float maxSize, int minCount, int maxCount) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }

    public boolean method_13151(class_5821<class_3111> featureConfig) {
        class_5819 random = featureConfig.method_33654();
        class_2338 pos = featureConfig.method_33655();
        class_5281 world = featureConfig.method_33652();
        float size = MHelper.randRange((float)this.minSize, (float)this.maxSize, (class_5819)random);
        int count = MHelper.randRange((int)this.minCount, (int)this.maxCount, (class_5819)random);
        List<class_1160> points = this.getFibonacciPoints(count);
        SDFPrimitive sdf = null;
        SDFPrimitive spike = new SDFCappedCone().setRadius1(3.0f + (size - 5.0f) * 0.2f).setRadius2(0.0f).setHeight(size).setBlock(EndBlocks.DENSE_SNOW);
        spike = new SDFTranslate().setTranslate(0.0f, size - 0.5f, 0.0f).setSource((SDF)spike);
        for (class_1160 point : points) {
            SDFPrimitive rotated = spike;
            float angle = MHelper.angle((class_1160)class_1160.field_20705, (class_1160)(point = MHelper.normalize((class_1160)point)));
            if (angle > 0.01f && angle < 3.14f) {
                class_1160 axis = MHelper.normalize((class_1160)MHelper.cross((class_1160)class_1160.field_20705, (class_1160)point));
                rotated = new SDFRotation().setRotation(axis, angle).setSource((SDF)spike);
            } else if (angle > 1.0f) {
                rotated = new SDFRotation().setRotation(class_1160.field_20705, (float)Math.PI).setSource((SDF)spike);
            }
            sdf = sdf == null ? rotated : new SDFUnion().setSourceA((SDF)sdf).setSourceB((SDF)rotated);
        }
        int x1 = pos.method_10263() >> 4 << 4;
        int z1 = pos.method_10260() >> 4 << 4;
        pos = new class_2338(x1 + random.method_43048(16), MHelper.randRange((int)32, (int)128, (class_5819)random), z1 + random.method_43048(16));
        float ancientRadius = size * 0.7f;
        float denseRadius = size * 0.9f;
        float iceRadius = size < 7.0f ? size * 5.0f : size * 1.3f;
        float randScale = size * 0.3f;
        class_2338 center = pos;
        class_2680 ice = EndBlocks.EMERALD_ICE.method_9564();
        class_2680 dense = EndBlocks.DENSE_EMERALD_ICE.method_9564();
        class_2680 ancient = EndBlocks.ANCIENT_EMERALD_ICE.method_9564();
        SDFPrimitive sdfCopy = sdf;
        sdf.addPostProcess(arg_0 -> IceStarFeature.lambda$place$0(center, (SDF)sdfCopy, random, randScale, ancientRadius, ancient, denseRadius, dense, iceRadius, ice, arg_0)).fillRecursive((class_5425)world, pos);
        return true;
    }

    private List<class_1160> getFibonacciPoints(int count) {
        float max = count - 1;
        ArrayList<class_1160> result = new ArrayList<class_1160>(count);
        for (int i = 0; i < count; ++i) {
            float y = 1.0f - (float)i / max * 2.0f;
            float radius = (float)Math.sqrt(1.0f - y * y);
            float theta = MHelper.PHI * (float)i;
            float x = (float)Math.cos(theta) * radius;
            float z = (float)Math.sin(theta) * radius;
            result.add(new class_1160(x, y, z));
        }
        return result;
    }

    private static /* synthetic */ class_2680 lambda$place$0(class_2338 center, SDF sdfCopy, class_5819 random, float randScale, float ancientRadius, class_2680 ancient, float denseRadius, class_2680 dense, float iceRadius, class_2680 ice, PosInfo info) {
        float pz;
        float py;
        class_2338 bpos = info.getPos();
        float px = bpos.method_10263() - center.method_10263();
        float distance = MHelper.length((float)px, (float)(py = (float)(bpos.method_10264() - center.method_10264())), (float)(pz = (float)(bpos.method_10260() - center.method_10260()))) + sdfCopy.getDistance(px, py, pz) * 0.4f + random.method_43057() * randScale;
        if (distance < ancientRadius) {
            return ancient;
        }
        if (distance < denseRadius) {
            return dense;
        }
        if (distance < iceRadius) {
            return ice;
        }
        return info.getState();
    }
}

