/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4538;
import org.betterx.bclib.blocks.BaseDoublePlantBlock;
import org.betterx.bclib.blocks.BaseVineBlock;
import org.betterx.bclib.blocks.StalactiteBlock;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.BlueVineBlock;
import org.betterx.betterend.blocks.basis.FurBlock;
import org.betterx.betterend.registry.EndBlocks;

public class BlockFixer {
    private static final class_2680 AIR = class_2246.field_10124.method_9564();
    private static final class_2680 WATER = class_2246.field_10382.method_9564();

    public static void fixBlocks(class_1936 level, class_2338 start, class_2338 end) {
        class_2378 registry = level.method_30349().method_30530(class_2378.field_25095);
        class_2960 dimKey = registry.method_10221((Object)level.method_8597());
        if (dimKey != null && "world_blender".equals(dimKey.method_12836())) {
            return;
        }
        Set doubleCheck = Sets.newConcurrentHashSet();
        int dx = end.method_10263() - start.method_10263() + 1;
        int dz = end.method_10260() - start.method_10260() + 1;
        int count = dx * dz;
        int minY = Math.max(start.method_10264(), level.method_31607());
        int maxY = Math.min(end.method_10264(), level.method_31600());
        IntStream.range(0, count).parallel().forEach(index -> {
            class_2338.class_2339 POS = new class_2338.class_2339();
            POS.method_33097(index % dx + start.method_10263());
            POS.method_33099(index / dx + start.method_10260());
            block2: for (int y = minY; y <= maxY; ++y) {
                POS.method_33098(y);
                class_2680 state = level.method_8320((class_2338)POS);
                if (state.method_26204() instanceof FurBlock) {
                    doubleCheck.add(POS.method_10062());
                    continue;
                }
                if (!state.method_26227().method_15769()) {
                    if (!state.method_26184((class_4538)level, (class_2338)POS)) {
                        BlockFixer.setWithoutUpdate(level, (class_2338)POS, WATER);
                        POS.method_33098(POS.method_10264() - 1);
                        state = level.method_8320((class_2338)POS);
                        while (!state.method_26184((class_4538)level, (class_2338)POS)) {
                            state = state.method_26227().method_15769() ? AIR : WATER;
                            BlockFixer.setWithoutUpdate(level, (class_2338)POS, state);
                            POS.method_33098(POS.method_10264() - 1);
                            state = level.method_8320((class_2338)POS);
                        }
                    }
                    POS.method_33098(y - 1);
                    if (level.method_22347((class_2338)POS)) {
                        POS.method_33098(y);
                        while (!level.method_8316((class_2338)POS).method_15769()) {
                            BlockFixer.setWithoutUpdate(level, (class_2338)POS, AIR);
                            POS.method_33098(POS.method_10264() + 1);
                        }
                        continue;
                    }
                    for (class_2350 dir : BlocksHelper.HORIZONTAL) {
                        if (!level.method_22347(POS.method_10093(dir))) continue;
                        try {
                            level.method_39281((class_2338)POS, state.method_26227().method_15772(), 0);
                        }
                        catch (Exception exception) {}
                        continue block2;
                    }
                    continue;
                }
                if (state.method_27852(EndBlocks.SMARAGDANT_CRYSTAL)) {
                    POS.method_33098(POS.method_10264() - 1);
                    if (!level.method_22347((class_2338)POS)) continue;
                    POS.method_33098(POS.method_10264() + 1);
                    while (state.method_27852(EndBlocks.SMARAGDANT_CRYSTAL)) {
                        BlockFixer.setWithoutUpdate(level, (class_2338)POS, AIR);
                        POS.method_33098(POS.method_10264() + 1);
                        state = level.method_8320((class_2338)POS);
                    }
                    continue;
                }
                if (state.method_26204() instanceof StalactiteBlock) {
                    if (state.method_26184((class_4538)level, (class_2338)POS)) continue;
                    if (level.method_8320(POS.method_10084()).method_26204() instanceof StalactiteBlock) {
                        while (state.method_26204() instanceof StalactiteBlock) {
                            BlockFixer.setWithoutUpdate(level, (class_2338)POS, AIR);
                            POS.method_33098(POS.method_10264() + 1);
                            state = level.method_8320((class_2338)POS);
                        }
                        continue;
                    }
                    while (state.method_26204() instanceof StalactiteBlock) {
                        BlockFixer.setWithoutUpdate(level, (class_2338)POS, AIR);
                        POS.method_33098(POS.method_10264() - 1);
                        state = level.method_8320((class_2338)POS);
                    }
                    continue;
                }
                if (state.method_27852(EndBlocks.CAVE_PUMPKIN)) {
                    if (level.method_8320(POS.method_10084()).method_27852(EndBlocks.CAVE_PUMPKIN_SEED)) continue;
                    BlockFixer.setWithoutUpdate(level, (class_2338)POS, AIR);
                    continue;
                }
                if (state.method_26184((class_4538)level, (class_2338)POS)) continue;
                if (state.method_27852(class_2246.field_10021)) {
                    HashSet ends = Sets.newHashSet();
                    HashSet add = Sets.newHashSet();
                    ends.add(POS.method_10062());
                    for (int i = 0; i < 64 && !ends.isEmpty(); ++i) {
                        ends.forEach(pos -> {
                            BlockFixer.setWithoutUpdate(level, pos, AIR);
                            for (class_2350 dir : BlocksHelper.HORIZONTAL) {
                                class_2338 p = pos.method_10093(dir);
                                class_2680 st = level.method_8320(p);
                                if (!st.method_27852(class_2246.field_10021) && !st.method_27852(class_2246.field_10528) || st.method_26184((class_4538)level, p)) continue;
                                add.add(p);
                            }
                            class_2338 p = pos.method_10084();
                            class_2680 st = level.method_8320(p);
                            if ((st.method_27852(class_2246.field_10021) || st.method_27852(class_2246.field_10528)) && !st.method_26184((class_4538)level, p)) {
                                add.add(p);
                            }
                        });
                        ends.clear();
                        ends.addAll(add);
                        add.clear();
                    }
                    continue;
                }
                if (state.method_26204() instanceof BaseVineBlock) {
                    while (level.method_8320((class_2338)POS).method_26204() instanceof BaseVineBlock) {
                        BlockFixer.setWithoutUpdate(level, (class_2338)POS, AIR);
                        POS.method_33098(POS.method_10264() - 1);
                    }
                    continue;
                }
                if (state.method_26204() instanceof class_2346) {
                    class_2680 falling = state;
                    POS.method_33098(POS.method_10264() - 1);
                    state = level.method_8320((class_2338)POS);
                    int ray = BlocksHelper.downRayRep((class_1936)level, (class_2338)POS.method_10062(), (int)64);
                    if (ray > 32) {
                        BlockFixer.setWithoutUpdate(level, (class_2338)POS, class_2246.field_10471.method_9564());
                        if (!level.method_8409().method_43056()) continue;
                        POS.method_33098(POS.method_10264() - 1);
                        state = level.method_8320((class_2338)POS);
                        BlockFixer.setWithoutUpdate(level, (class_2338)POS, class_2246.field_10471.method_9564());
                        continue;
                    }
                    POS.method_33098(y);
                    class_2680 replacement = AIR;
                    for (class_2350 dir : BlocksHelper.HORIZONTAL) {
                        state = level.method_8320(POS.method_10093(dir));
                        if (state.method_26227().method_15769()) continue;
                        replacement = state;
                        break;
                    }
                    BlockFixer.setWithoutUpdate(level, (class_2338)POS, replacement);
                    POS.method_33098(y - ray);
                    BlockFixer.setWithoutUpdate(level, (class_2338)POS, falling);
                    continue;
                }
                if (state.method_26204() instanceof BlueVineBlock) {
                    while (state.method_27852(EndBlocks.BLUE_VINE) || state.method_27852(EndBlocks.BLUE_VINE_LANTERN) || state.method_27852(EndBlocks.BLUE_VINE_FUR)) {
                        BlockFixer.setWithoutUpdate(level, (class_2338)POS, AIR);
                        POS.method_33098(POS.method_10264() + 1);
                        state = level.method_8320((class_2338)POS);
                    }
                }
                if (state.method_26204() instanceof BaseDoublePlantBlock) {
                    BlockFixer.setWithoutUpdate(level, (class_2338)POS, AIR);
                    POS.method_33098(POS.method_10264() + 1);
                    BlockFixer.setWithoutUpdate(level, (class_2338)POS, AIR);
                    continue;
                }
                BlockFixer.setWithoutUpdate(level, (class_2338)POS, BlockFixer.getAirOrFluid(state));
            }
        });
        doubleCheck.forEach(pos -> {
            if (!level.method_8320(pos).method_26184((class_4538)level, pos)) {
                BlockFixer.setWithoutUpdate(level, pos, AIR);
            }
        });
    }

    private static class_2680 getAirOrFluid(class_2680 state) {
        return state.method_26227().method_15769() ? AIR : state.method_26227().method_15759();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setWithoutUpdate(class_1936 world, class_2338 pos, class_2680 state) {
        class_1936 class_19362 = world;
        synchronized (class_19362) {
            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)pos, (class_2680)state);
        }
    }
}

