/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.rituals;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3614;
import net.minecraft.class_4153;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6796;
import net.minecraft.class_6802;
import net.minecraft.server.MinecraftServer;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.blocks.EndPortalBlock;
import org.betterx.betterend.blocks.RunedFlavolite;
import org.betterx.betterend.blocks.entities.EternalPedestalEntity;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.EndPoiTypes;
import org.betterx.betterend.registry.EndPortals;
import org.jetbrains.annotations.Nullable;

public class EternalRitual {
    private static final Set<Point> STRUCTURE_MAP = Sets.newHashSet((Object[])new Point[]{new Point(-4, -5), new Point(-4, 5), new Point(-6, 0), new Point(4, -5), new Point(4, 5), new Point(6, 0)});
    private static final Set<Point> FRAME_MAP = Sets.newHashSet((Object[])new Point[]{new Point(0, 0), new Point(0, 6), new Point(1, 0), new Point(1, 6), new Point(2, 1), new Point(2, 5), new Point(3, 2), new Point(3, 3), new Point(3, 4)});
    private static final Set<Point> PORTAL_MAP = Sets.newHashSet((Object[])new Point[]{new Point(0, 0), new Point(0, 1), new Point(0, 2), new Point(0, 3), new Point(0, 4), new Point(1, 0), new Point(1, 1), new Point(1, 2), new Point(1, 3), new Point(1, 4), new Point(2, 1), new Point(2, 2), new Point(2, 3)});
    private static final Set<Point> BASE_MAP = Sets.newHashSet((Object[])new Point[]{new Point(3, 0), new Point(2, 0), new Point(2, 1), new Point(1, 1), new Point(1, 2), new Point(0, 1), new Point(0, 2)});
    private static final class_2248 BASE = EndBlocks.FLAVOLITE.tiles;
    private static final class_2248 PEDESTAL = EndBlocks.ETERNAL_PEDESTAL;
    private static final class_2248 FRAME = EndBlocks.FLAVOLITE_RUNED_ETERNAL;
    private static final class_2248 PORTAL = EndBlocks.END_PORTAL_BLOCK;
    private static final class_2746 ACTIVE = BlockProperties.ACTIVE;
    public static final int SEARCH_RADIUS = EternalRitual.calculateSearchSteps(48);
    private class_1937 world;
    private class_2350.class_2351 axis;
    private class_2960 targetWorldId;
    private class_2338 center;
    private class_2338 exit;
    private boolean active = false;

    public EternalRitual(class_1937 world) {
        this.world = world;
    }

    public EternalRitual(class_1937 world, class_2338 initial) {
        this(world);
        this.configure(initial);
    }

    public void setWorld(class_1937 world) {
        this.world = world;
    }

    @Nullable
    public class_2960 getTargetWorldId() {
        return this.targetWorldId;
    }

    private boolean isInvalid() {
        return this.world == null || this.world.method_8608() || this.center == null || this.axis == null;
    }

    public void checkStructure() {
        class_2350 moveY;
        class_2350 moveX;
        if (this.isInvalid()) {
            return;
        }
        if (class_2350.class_2351.field_11048 == this.axis) {
            moveX = class_2350.field_11034;
            moveY = class_2350.field_11043;
        } else {
            moveX = class_2350.field_11035;
            moveY = class_2350.field_11034;
        }
        boolean valid = this.checkFrame(this.world, this.center.method_10074());
        class_1792 item = null;
        for (Point pos : STRUCTURE_MAP) {
            EternalPedestalEntity pedestal;
            class_2338.class_2339 checkPos = this.center.method_25503();
            checkPos.method_10104(moveX, pos.x).method_10104(moveY, pos.y);
            if (!(valid &= this.isActive((class_2338)checkPos)) || (pedestal = (EternalPedestalEntity)this.world.method_8321((class_2338)checkPos)) == null) continue;
            class_1792 pItem = pedestal.method_5438(0).method_7909();
            if (item == null) {
                item = pItem;
                continue;
            }
            if (item.equals(pItem)) continue;
            valid = false;
        }
        if (valid && item != null) {
            this.activatePortal(item);
        }
    }

    private boolean checkFrame(class_1937 world, class_2338 framePos) {
        class_2350 moveDir = class_2350.class_2351.field_11048 == this.axis ? class_2350.field_11043 : class_2350.field_11034;
        boolean valid = true;
        for (Point point : FRAME_MAP) {
            class_2338.class_2339 pos = framePos.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
            class_2680 state = world.method_8320((class_2338)pos);
            valid &= state.method_26204() instanceof RunedFlavolite;
            pos = framePos.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y);
            state = world.method_8320((class_2338)pos);
            valid &= state.method_26204() instanceof RunedFlavolite;
        }
        return valid;
    }

    public boolean isActive() {
        return this.active;
    }

    private void activatePortal(class_1792 keyItem) {
        if (this.active) {
            return;
        }
        class_2960 itemId = class_2378.field_11142.method_10221((Object)keyItem);
        int portalId = EndPortals.getPortalIdByItem(itemId);
        class_1937 targetWorld = this.getTargetWorld(portalId);
        class_2960 worldId = targetWorld.method_27983().method_29177();
        try {
            if (this.exit == null) {
                this.initPortal(worldId, portalId);
            } else {
                if (!worldId.equals((Object)this.targetWorldId)) {
                    this.initPortal(worldId, portalId);
                } else if (!this.checkFrame(targetWorld, this.exit.method_10074())) {
                    class_2350.class_2351 portalAxis = class_2350.class_2351.field_11048 == this.axis ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
                    EternalRitual.generatePortal(targetWorld, this.exit, portalAxis, portalId);
                }
                this.activatePortal(targetWorld, this.exit, portalId);
            }
            this.activatePortal(this.world, this.center, portalId);
            this.doEffects((class_3218)this.world, this.center);
            this.active = true;
        }
        catch (Exception ex) {
            BetterEnd.LOGGER.error("Create End portals error.", ex);
            this.removePortal(targetWorld, this.exit);
            this.removePortal(this.world, this.center);
            this.active = false;
        }
    }

    private void initPortal(class_2960 worldId, int portalId) {
        this.targetWorldId = worldId;
        this.exit = this.findPortalPos(portalId);
    }

    private void doEffects(class_3218 serverWorld, class_2338 center) {
        class_2350 moveY;
        class_2350 moveX;
        if (class_2350.class_2351.field_11048 == this.axis) {
            moveX = class_2350.field_11034;
            moveY = class_2350.field_11043;
        } else {
            moveX = class_2350.field_11035;
            moveY = class_2350.field_11034;
        }
        for (Point pos : STRUCTURE_MAP) {
            class_2338.class_2339 p = center.method_25503();
            p.method_10104(moveX, pos.x).method_10104(moveY, pos.y);
            serverWorld.method_14199((class_2394)class_2398.field_11214, (double)p.method_10263() + 0.5, (double)p.method_10264() + 1.5, (double)p.method_10260() + 0.5, 20, 0.0, 0.0, 0.0, 1.0);
            serverWorld.method_14199((class_2394)class_2398.field_23190, (double)p.method_10263() + 0.5, (double)p.method_10264() + 1.5, (double)p.method_10260() + 0.5, 20, 0.0, 0.0, 0.0, 0.3);
        }
        serverWorld.method_8396(null, center, class_3417.field_14981, class_3419.field_15254, 16.0f, 1.0f);
    }

    private void activatePortal(class_1937 world, class_2338 center, int portalId) {
        class_2338 framePos = center.method_10074();
        class_2350 moveDir = class_2350.class_2351.field_11048 == this.axis ? class_2350.field_11043 : class_2350.field_11034;
        class_2680 frame = (class_2680)FRAME.method_9564().method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(true));
        FRAME_MAP.forEach(point -> {
            class_2338.class_2339 pos = framePos.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
            class_2680 state = world.method_8320((class_2338)pos);
            if (state.method_28498((class_2769)ACTIVE) && !((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
                world.method_8501((class_2338)pos, frame);
            }
            if ((state = world.method_8320((class_2338)(pos = framePos.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y)))).method_28498((class_2769)ACTIVE) && !((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
                world.method_8501((class_2338)pos, frame);
            }
        });
        class_2350.class_2351 portalAxis = class_2350.class_2351.field_11048 == this.axis ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        class_2680 portal = (class_2680)((class_2680)PORTAL.method_9564().method_11657((class_2769)EndPortalBlock.field_11310, (Comparable)portalAxis)).method_11657((class_2769)EndPortalBlock.PORTAL, (Comparable)Integer.valueOf(portalId));
        class_2388 effect = new class_2388(class_2398.field_11217, portal);
        class_3218 serverWorld = (class_3218)world;
        PORTAL_MAP.forEach(arg_0 -> EternalRitual.lambda$activatePortal$1(center, moveDir, world, portal, serverWorld, (class_2394)effect, arg_0));
    }

    public void disablePortal(int state) {
        if (!this.active || this.isInvalid()) {
            return;
        }
        this.removePortal(this.getTargetWorld(state), this.exit);
        this.removePortal(this.world, this.center);
    }

    private void removePortal(class_1937 world, class_2338 center) {
        class_2338 framePos = center.method_10074();
        class_2350 moveDir = class_2350.class_2351.field_11048 == this.axis ? class_2350.field_11043 : class_2350.field_11034;
        FRAME_MAP.forEach(point -> {
            class_2338.class_2339 pos = framePos.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
            class_2680 state = world.method_8320((class_2338)pos);
            if (state.method_27852(FRAME) && ((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
                world.method_8501((class_2338)pos, (class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
            if ((state = world.method_8320((class_2338)(pos = framePos.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y)))).method_27852(FRAME) && ((Boolean)state.method_11654((class_2769)ACTIVE)).booleanValue()) {
                world.method_8501((class_2338)pos, (class_2680)state.method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        });
        PORTAL_MAP.forEach(point -> {
            class_2338.class_2339 pos = center.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
            if (world.method_8320((class_2338)pos).method_27852(PORTAL)) {
                world.method_8650((class_2338)pos, false);
            }
            if (world.method_8320((class_2338)(pos = center.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y))).method_27852(PORTAL)) {
                world.method_8650((class_2338)pos, false);
            }
        });
        this.active = false;
    }

    @Nullable
    private class_2338 findFrame(class_3218 level, class_2338.class_2339 startPos) {
        Optional found = EndPoiTypes.ETERNAL_PORTAL_INACTIVE.findPoiAround(level, (class_2338)startPos, SEARCH_RADIUS >> 5, level.method_8621());
        if (found.isPresent() && this.checkFrame((class_1937)level, (class_2338)found.get())) {
            return (class_2338)found.get();
        }
        return null;
    }

    private class_2338 findPortalPos(int portalId) {
        MinecraftServer server = this.world.method_8503();
        class_3218 targetWorld = (class_3218)this.getTargetWorld(portalId);
        class_2378 registry = Objects.requireNonNull(server).method_30611().method_30530(class_2378.field_25095);
        double multiplier = Objects.requireNonNull((class_2874)registry.method_10223(this.targetWorldId)).comp_646();
        class_2338.class_2339 basePos = this.center.method_25503().method_10102((double)this.center.method_10263() / multiplier, (double)this.center.method_10264(), (double)this.center.method_10260() / multiplier);
        class_2338 framePos = this.findFrame(targetWorld, basePos.method_25503());
        if (framePos != null) {
            return framePos.method_10084();
        }
        class_2350.class_2351 portalAxis = class_2350.class_2351.field_11048 == this.axis ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        int worldCeil = targetWorld.method_31605() - 1;
        if (this.checkIsAreaValid((class_1937)targetWorld, (class_2338)basePos, portalAxis)) {
            EternalRitual.generatePortal((class_1937)targetWorld, (class_2338)basePos, portalAxis, portalId);
            return basePos.method_10062();
        }
        class_2350 direction = class_2350.field_11034;
        class_2338.class_2339 checkPos = basePos.method_25503();
        int radius = (int)((double)SEARCH_RADIUS / multiplier + 1.0);
        class_4153 poiManager = targetWorld.method_19494();
        poiManager.method_22439((class_4538)this.world, (class_2338)checkPos, radius >> 4);
        for (int step = 1; step < radius; ++step) {
            for (int i = 0; i < step >> 1; ++i) {
                class_2791 chunk = targetWorld.method_22350((class_2338)checkPos);
                if (chunk != null) {
                    int motionY;
                    int surfaceY = chunk.method_12005(class_2902.class_2903.field_13202, checkPos.method_10263() & 0xF, checkPos.method_10260() & 0xF);
                    int ceil = Math.min(Math.max(surfaceY, motionY = chunk.method_12005(class_2902.class_2903.field_13197, checkPos.method_10263() & 0xF, checkPos.method_10260() & 0xF)) + 1, worldCeil);
                    if (ceil < 5) continue;
                    checkPos.method_33098(ceil);
                    while (checkPos.method_10264() >= 5) {
                        if (this.checkIsAreaValid((class_1937)targetWorld, (class_2338)checkPos, portalAxis)) {
                            EternalRitual.generatePortal((class_1937)targetWorld, (class_2338)checkPos, portalAxis, portalId);
                            return checkPos.method_10062();
                        }
                        checkPos.method_10098(class_2350.field_11033);
                    }
                }
                checkPos.method_10098(direction);
            }
            direction = direction.method_10170();
        }
        if (targetWorld.method_27983() == class_1937.field_25181) {
            ((class_2975)class_6802.field_35799.comp_349()).method_12862((class_5281)targetWorld, targetWorld.method_14178().method_12129(), (class_5819)new class_5820(basePos.method_10063()), basePos.method_10074());
        } else if (targetWorld.method_27983() == class_1937.field_25179) {
            basePos.method_33098(targetWorld.method_22350((class_2338)basePos).method_12005(class_2902.class_2903.field_13202, basePos.method_10263(), basePos.method_10260()) + 1);
        }
        ((class_6796)EndFeatures.BIOME_ISLAND.getPlacedFeature().comp_349()).method_39644((class_5281)targetWorld, targetWorld.method_14178().method_12129(), (class_5819)new class_5820(basePos.method_10063()), basePos.method_10074());
        EternalRitual.generatePortal((class_1937)targetWorld, (class_2338)basePos, portalAxis, portalId);
        return basePos.method_10062();
    }

    private class_1937 getTargetWorld(int state) {
        if (this.world.method_27983() == class_1937.field_25181) {
            return EndPortals.getWorld(this.world.method_8503(), state);
        }
        return Objects.requireNonNull(this.world.method_8503()).method_3847(class_1937.field_25181);
    }

    private boolean checkIsAreaValid(class_1937 world, class_2338 pos, class_2350.class_2351 axis) {
        if (pos.method_10264() >= world.method_31605() - 1) {
            return false;
        }
        if (!this.isBaseValid(world, pos, axis)) {
            return false;
        }
        return EternalRitual.checkArea(world, pos, axis);
    }

    private boolean isBaseValid(class_1937 world, class_2338 pos, class_2350.class_2351 axis) {
        boolean solid = true;
        if (axis.equals((Object)class_2350.class_2351.field_11048)) {
            pos = pos.method_10074().method_10069(0, 0, -3);
            for (int i = 0; i < 7; ++i) {
                class_2338 checkPos = pos.method_10069(0, 0, i);
                class_2680 state = world.method_8320(checkPos);
                solid &= this.validBlock(world, checkPos, state);
            }
        } else {
            pos = pos.method_10074().method_10069(-3, 0, 0);
            for (int i = 0; i < 7; ++i) {
                class_2338 checkPos = pos.method_10069(i, 0, 0);
                class_2680 state = world.method_8320(checkPos);
                solid &= this.validBlock(world, checkPos, state);
            }
        }
        return solid;
    }

    private boolean validBlock(class_1937 world, class_2338 pos, class_2680 state) {
        return state.method_26212((class_1922)world, pos) && state.method_26234((class_1922)world, pos);
    }

    public void configure(class_2338 initial) {
        class_2338 checkPos = initial.method_10089(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11048;
            this.center = initial.method_10089(6);
            return;
        }
        checkPos = initial.method_10088(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11048;
            this.center = initial.method_10088(6);
            return;
        }
        checkPos = initial.method_10077(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11051;
            this.center = initial.method_10077(6);
            return;
        }
        checkPos = initial.method_10076(12);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11051;
            this.center = initial.method_10076(6);
            return;
        }
        checkPos = initial.method_10076(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11048;
            this.center = this.hasPedestal(checkPos = checkPos.method_10089(8)) ? initial.method_10076(5).method_10089(4) : initial.method_10076(5).method_10088(4);
            return;
        }
        checkPos = initial.method_10077(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11048;
            this.center = this.hasPedestal(checkPos = checkPos.method_10089(8)) ? initial.method_10077(5).method_10089(4) : initial.method_10077(5).method_10088(4);
            return;
        }
        checkPos = initial.method_10089(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11051;
            this.center = this.hasPedestal(checkPos = checkPos.method_10077(8)) ? initial.method_10089(5).method_10077(4) : initial.method_10089(5).method_10076(4);
            return;
        }
        checkPos = initial.method_10088(10);
        if (this.hasPedestal(checkPos)) {
            this.axis = class_2350.class_2351.field_11051;
            this.center = this.hasPedestal(checkPos = checkPos.method_10077(8)) ? initial.method_10088(5).method_10077(4) : initial.method_10088(5).method_10076(4);
        }
    }

    private boolean hasPedestal(class_2338 pos) {
        return this.world.method_8320(pos).method_27852(PEDESTAL);
    }

    private boolean isActive(class_2338 pos) {
        class_2680 state = this.world.method_8320(pos);
        if (state.method_27852(PEDESTAL)) {
            EternalPedestalEntity pedestal = (EternalPedestalEntity)this.world.method_8321(pos);
            if (pedestal != null) {
                if (!pedestal.hasRitual()) {
                    pedestal.linkRitual(this);
                } else {
                    EternalRitual ritual = pedestal.getRitual();
                    if (!ritual.equals(this)) {
                        pedestal.linkRitual(this);
                    }
                }
            }
            return (Boolean)state.method_11654((class_2769)ACTIVE);
        }
        return false;
    }

    public class_2487 toTag(class_2487 tag) {
        tag.method_10566("center", (class_2520)class_2512.method_10692((class_2338)this.center));
        tag.method_10582("axis", this.axis.method_10174());
        tag.method_10556("active", this.active);
        if (this.targetWorldId != null) {
            tag.method_10582("key_item", this.targetWorldId.toString());
        }
        if (this.exit != null) {
            tag.method_10566("exit", (class_2520)class_2512.method_10692((class_2338)this.exit));
        }
        return tag;
    }

    public void fromTag(class_2487 tag) {
        this.axis = class_2350.class_2351.method_10177((String)tag.method_10558("axis"));
        this.center = class_2512.method_10691((class_2487)tag.method_10562("center"));
        this.active = tag.method_10577("active");
        if (tag.method_10545("exit")) {
            this.exit = class_2512.method_10691((class_2487)tag.method_10562("exit"));
        }
        if (tag.method_10545("key_item")) {
            this.targetWorldId = new class_2960(tag.method_10558("key_item"));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EternalRitual ritual = (EternalRitual)o;
        return this.world.equals(ritual.world) && Objects.equals(this.center, ritual.center) && Objects.equals(this.exit, ritual.exit);
    }

    public static void generatePortal(class_1937 world, class_2338 center, class_2350.class_2351 axis, int portalId) {
        class_2338 framePos = center.method_10074();
        class_2350 moveDir = class_2350.class_2351.field_11048 == axis ? class_2350.field_11034 : class_2350.field_11043;
        class_2680 frame = (class_2680)FRAME.method_9564().method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(true));
        FRAME_MAP.forEach(point -> {
            class_2338.class_2339 pos = framePos.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
            world.method_8501((class_2338)pos, frame);
            pos = framePos.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y);
            world.method_8501((class_2338)pos, frame);
        });
        class_2680 portal = (class_2680)((class_2680)PORTAL.method_9564().method_11657((class_2769)EndPortalBlock.field_11310, (Comparable)axis)).method_11657((class_2769)EndPortalBlock.PORTAL, (Comparable)Integer.valueOf(portalId));
        PORTAL_MAP.forEach(point -> {
            class_2338.class_2339 pos = center.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
            world.method_8501((class_2338)pos, portal);
            pos = center.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y);
            world.method_8501((class_2338)pos, portal);
        });
        EternalRitual.generateBase(world, framePos, moveDir);
    }

    private static void generateBase(class_1937 world, class_2338 center, class_2350 moveX) {
        class_2680 base = BASE.method_9564();
        class_2350 moveY = moveX.method_10170();
        BASE_MAP.forEach(point -> {
            class_2338.class_2339 pos = center.method_25503().method_10104(moveX, point.x).method_10104(moveY, point.y);
            world.method_8501((class_2338)pos, base);
            pos = center.method_25503().method_10104(moveX, -point.x).method_10104(moveY, point.y);
            world.method_8501((class_2338)pos, base);
            pos = center.method_25503().method_10104(moveX, point.x).method_10104(moveY, -point.y);
            world.method_8501((class_2338)pos, base);
            pos = center.method_25503().method_10104(moveX, -point.x).method_10104(moveY, -point.y);
            world.method_8501((class_2338)pos, base);
        });
    }

    public static boolean checkArea(class_1937 world, class_2338 center, class_2350.class_2351 axis) {
        class_2350 moveDir = class_2350.class_2351.field_11048 == axis ? class_2350.field_11043 : class_2350.field_11034;
        for (class_2338 checkPos : class_2338.method_10097((class_2338)center.method_10093(moveDir.method_10170()), (class_2338)center.method_10093(moveDir.method_10160()))) {
            for (Point point : PORTAL_MAP) {
                class_2338.class_2339 pos = checkPos.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
                class_2680 state = world.method_8320((class_2338)pos);
                if (EternalRitual.isStateInvalid(state)) {
                    return false;
                }
                pos = checkPos.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y);
                state = world.method_8320((class_2338)pos);
                if (!EternalRitual.isStateInvalid(state)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isStateInvalid(class_2680 state) {
        if (!state.method_26227().method_15769()) {
            return true;
        }
        class_3614 material = state.method_26207();
        return !material.method_15800() && !material.equals(class_3614.field_15935);
    }

    @Nullable
    public static class_2338.class_2339 findBlockPos(class_1937 world, class_2338.class_2339 checkPos, int radius, class_2248 searchBlock, Predicate<class_2680> condition) {
        class_2350 moveDirection = class_2350.field_11034;
        for (int step = 1; step < radius; ++step) {
            for (int i = 0; i < step >> 1; ++i) {
                class_2791 chunk = world.method_22350((class_2338)checkPos);
                if (!(chunk instanceof class_2818) || ((class_2818)chunk).method_12223()) continue;
                for (class_2826 section : chunk.method_12006()) {
                    if (section == null || !section.method_12265().method_19526(condition)) continue;
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                class_2680 checkState = section.method_12254(x, y, z);
                                if (!checkState.method_27852(searchBlock)) continue;
                                int worldX = (chunk.method_12004().field_9181 << 4) + x;
                                int worldY = section.method_12259() + y;
                                int worldZ = (chunk.method_12004().field_9180 << 4) + z;
                                checkPos.method_10103(worldX, worldY, worldZ);
                                return checkPos;
                            }
                        }
                    }
                }
                checkPos.method_10104(moveDirection, 16);
            }
            moveDirection = moveDirection.method_10170();
        }
        return null;
    }

    public static List<class_2338.class_2339> findAllBlockPos(class_3218 world, class_2338.class_2339 checkPos, int radius, class_2248 searchBlock, Predicate<class_2680> condition) {
        class_4153 poiManager = world.method_19494();
        poiManager.method_22439((class_4538)world, (class_2338)checkPos, radius >> 4);
        ArrayList posFound = Lists.newArrayList();
        class_2350 moveDirection = class_2350.field_11034;
        for (int step = 1; step < radius; ++step) {
            for (int i = 0; i < step >> 1; ++i) {
                class_2791 chunk = world.method_22350((class_2338)checkPos);
                if (!(chunk instanceof class_2818) || ((class_2818)chunk).method_12223()) continue;
                for (class_2826 section : chunk.method_12006()) {
                    if (section == null || !section.method_12265().method_19526(condition)) continue;
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            for (int z = 0; z < 16; ++z) {
                                class_2680 checkState = section.method_12254(x, y, z);
                                if (!checkState.method_27852(searchBlock)) continue;
                                int worldX = (chunk.method_12004().field_9181 << 4) + x;
                                int worldY = section.method_12259() + y;
                                int worldZ = (chunk.method_12004().field_9180 << 4) + z;
                                checkPos.method_10103(worldX, worldY, worldZ);
                                posFound.add(checkPos.method_25503());
                            }
                        }
                    }
                }
                checkPos.method_10104(moveDirection, 16);
            }
            moveDirection = moveDirection.method_10170();
        }
        return posFound;
    }

    public static int calculateSearchSteps(int chunkRadius) {
        return chunkRadius * 4 - 1;
    }

    private static /* synthetic */ void lambda$activatePortal$1(class_2338 center, class_2350 moveDir, class_1937 world, class_2680 portal, class_3218 serverWorld, class_2394 effect, Point point) {
        class_2338.class_2339 pos = center.method_25503().method_10104(moveDir, point.x).method_10104(class_2350.field_11036, point.y);
        if (!world.method_8320((class_2338)pos).method_27852(PORTAL)) {
            world.method_8501((class_2338)pos, portal);
            serverWorld.method_14199(effect, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
            serverWorld.method_14199((class_2394)class_2398.field_23190, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.3);
        }
        if (!world.method_8320((class_2338)(pos = center.method_25503().method_10104(moveDir, -point.x).method_10104(class_2350.field_11036, point.y))).method_27852(PORTAL)) {
            world.method_8501((class_2338)pos, portal);
            serverWorld.method_14199(effect, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
            serverWorld.method_14199((class_2394)class_2398.field_23190, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.3);
        }
    }
}

