/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import java.util.Objects;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2423;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_322;
import net.minecraft.class_3222;
import net.minecraft.class_326;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.CustomColorProvider;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.betterend.blocks.EndBlockProperties;
import org.betterx.betterend.interfaces.TeleportingEntity;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.registry.EndPortals;
import org.betterx.betterend.rituals.EternalRitual;

public class EndPortalBlock
extends class_2423
implements RenderLayerProvider,
CustomColorProvider {
    public static final class_2758 PORTAL = EndBlockProperties.PORTAL;

    public EndPortalBlock() {
        super((class_4970.class_2251)FabricBlockSettings.copyOf((class_4970)class_2246.field_10316).resistance(class_2246.field_9987.method_9520()).luminance(15));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{PORTAL});
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43048(100) == 0) {
            world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14802, class_3419.field_15245, 0.5f, random.method_43057() * 0.4f + 0.8f, false);
        }
        double x = (double)pos.method_10263() + random.method_43058();
        double y = (double)pos.method_10264() + random.method_43058();
        double z = (double)pos.method_10260() + random.method_43058();
        int k = random.method_43048(2) * 2 - 1;
        if (!world.method_8320(pos.method_10067()).method_27852((class_2248)this) && !world.method_8320(pos.method_10078()).method_27852((class_2248)this)) {
            x = (double)pos.method_10263() + 0.5 + 0.25 * (double)k;
        } else {
            z = (double)pos.method_10260() + 0.5 + 0.25 * (double)k;
        }
        world.method_8406((class_2394)EndParticles.PORTAL_SPHERE, x, y, z, 0.0, 0.0, 0.0);
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        return state;
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (world.field_9236 || !this.validate(entity)) {
            return;
        }
        entity.method_30229();
        class_3218 currentWorld = (class_3218)world;
        MinecraftServer server = currentWorld.method_8503();
        class_3218 targetWorld = EndPortals.getWorld(server, (Integer)state.method_11654((class_2769)PORTAL));
        boolean isInEnd = currentWorld.method_27983().equals(class_1937.field_25181);
        class_3218 destination = isInEnd ? targetWorld : server.method_3847(class_1937.field_25181);
        class_2338 exitPos = this.findExitPos(currentWorld, destination, pos, entity);
        if (exitPos == null) {
            return;
        }
        if (entity instanceof class_3222 && ((class_3222)entity).method_7337()) {
            ((class_3222)entity).method_14251(destination, (double)exitPos.method_10263() + 0.5, (double)exitPos.method_10264(), (double)exitPos.method_10260() + 0.5, entity.method_36454(), entity.method_36455());
        } else {
            ((TeleportingEntity)entity).be_setExitPos(exitPos);
            Optional<class_1297> teleported = Optional.ofNullable(entity.method_5731(destination));
            teleported.ifPresent(class_1297::method_30229);
        }
    }

    private boolean validate(class_1297 entity) {
        return !entity.method_5765() && !entity.method_5782() && entity.method_5822() && !entity.method_30230();
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.TRANSLUCENT;
    }

    private class_2338 findExitPos(class_3218 currentWorld, class_3218 targetWorld, class_2338 currentPos, class_1297 entity) {
        double currentMultiplier;
        if (targetWorld == null) {
            return null;
        }
        class_2378 registry = targetWorld.method_30349().method_30530(class_2378.field_25095);
        class_2960 targetWorldId = targetWorld.method_27983().method_29177();
        class_2960 currentWorldId = currentWorld.method_27983().method_29177();
        double targetMultiplier = Objects.requireNonNull((class_2874)registry.method_10223(targetWorldId)).comp_646();
        double multiplier = targetMultiplier > (currentMultiplier = Objects.requireNonNull((class_2874)registry.method_10223(currentWorldId)).comp_646()) ? 1.0 / targetMultiplier : currentMultiplier;
        class_2338.class_2339 basePos = currentPos.method_25503().method_10102((double)currentPos.method_10263() * multiplier, (double)currentPos.method_10264(), (double)currentPos.method_10260() * multiplier);
        class_2338.class_2339 checkPos = basePos.method_25503();
        int radius = (EternalRitual.SEARCH_RADIUS >> 4) + 1;
        class_2680 currentState = currentWorld.method_8320(currentPos);
        if ((checkPos = EternalRitual.findBlockPos((class_1937)targetWorld, checkPos, radius, (class_2248)this, state -> state.method_27852((class_2248)this) && ((Integer)state.method_11654((class_2769)PORTAL)).equals(currentState.method_11654((class_2769)PORTAL)))) != null) {
            class_2680 checkState = targetWorld.method_8320((class_2338)checkPos);
            class_2350.class_2351 axis = (class_2350.class_2351)checkState.method_11654((class_2769)field_11310);
            checkPos = this.findCenter((class_1937)targetWorld, checkPos, axis);
            class_2350 frontDir = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056).method_10170();
            class_2350 entityDir = entity.method_5755();
            if (entityDir.method_10166().method_10178()) {
                entityDir = frontDir;
            }
            if (frontDir != entityDir && frontDir.method_10153() != entityDir) {
                entity.method_5832(class_2470.field_11463);
                entityDir = entityDir.method_10170();
            }
            return checkPos.method_10093(entityDir);
        }
        return null;
    }

    private class_2338.class_2339 findCenter(class_1937 world, class_2338.class_2339 pos, class_2350.class_2351 axis) {
        return this.findCenter(world, pos, axis, 1);
    }

    private class_2338.class_2339 findCenter(class_1937 world, class_2338.class_2339 pos, class_2350.class_2351 axis, int step) {
        if (step > 8) {
            return pos;
        }
        class_2350 rightDir = class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056);
        class_2350 leftDir = rightDir.method_10153();
        class_2680 right = world.method_8320(pos.method_10093(rightDir));
        class_2680 left = world.method_8320(pos.method_10093(leftDir));
        class_2680 down = world.method_8320(pos.method_10074());
        if (down.method_27852((class_2248)this)) {
            return this.findCenter(world, pos.method_10098(class_2350.field_11033), axis, step);
        }
        if (right.method_27852((class_2248)this) && left.method_27852((class_2248)this)) {
            return pos;
        }
        if (right.method_27852((class_2248)this)) {
            return this.findCenter(world, pos.method_10098(rightDir), axis, ++step);
        }
        if (left.method_27852((class_2248)this)) {
            return this.findCenter(world, pos.method_10098(leftDir), axis, ++step);
        }
        return pos;
    }

    public class_322 getProvider() {
        return (state, world, pos, tintIndex) -> EndPortals.getColor((Integer)state.method_11654((class_2769)PORTAL));
    }

    public class_326 getItemProvider() {
        return (stack, tintIndex) -> EndPortals.getColor(0);
    }
}

