/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.WorldDataAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.util.Logger;
import org.betterx.betterend.api.BetterEndPlugin;
import org.betterx.betterend.commands.CommandRegistry;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.effects.EndPotions;
import org.betterx.betterend.integration.Integrations;
import org.betterx.betterend.recipe.AlloyingRecipes;
import org.betterx.betterend.recipe.AnvilRecipes;
import org.betterx.betterend.recipe.CraftingRecipes;
import org.betterx.betterend.recipe.FurnaceRecipes;
import org.betterx.betterend.recipe.InfusionRecipes;
import org.betterx.betterend.recipe.SmithingRecipes;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndBlockEntities;
import org.betterx.betterend.registry.EndEnchantments;
import org.betterx.betterend.registry.EndEntities;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.EndPoiTypes;
import org.betterx.betterend.registry.EndPortals;
import org.betterx.betterend.registry.EndSounds;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.registry.EndTags;
import org.betterx.betterend.util.BonemealPlants;
import org.betterx.betterend.util.LootTableUtil;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.betterend.world.generator.TerrainGenerator;

public class BetterEnd
implements ModInitializer {
    public static final String MOD_ID = "betterend";
    public static final Logger LOGGER = new Logger("betterend");
    public static final boolean RUNS_FALL_FLYING_LIB = FabricLoader.getInstance().getModContainer("fallflyinglib").isPresent();

    public void onInitialize() {
        WorldDataAPI.registerModCache((String)MOD_ID);
        EndPortals.loadPortals();
        EndSounds.register();
        EndBlockEntities.register();
        EndPoiTypes.register();
        EndFeatures.register();
        EndEntities.register();
        EndBiomes.register();
        EndTags.register();
        EndEnchantments.register();
        EndPotions.register();
        CraftingRecipes.register();
        FurnaceRecipes.register();
        AlloyingRecipes.register();
        AnvilRecipes.register();
        SmithingRecipes.register();
        InfusionRecipes.register();
        EndStructures.register();
        BonemealPlants.init();
        GeneratorOptions.init();
        LootTableUtil.init();
        CommandRegistry.register();
        FabricLoader.getInstance().getEntrypoints(MOD_ID, BetterEndPlugin.class).forEach(BetterEndPlugin::register);
        Integrations.init();
        Configs.saveConfigs();
        if (GeneratorOptions.useNewGenerator()) {
            org.betterx.bclib.api.v2.generator.GeneratorOptions.setFarEndBiomes((int)GeneratorOptions.getIslandDistBlock());
            org.betterx.bclib.api.v2.generator.GeneratorOptions.setEndLandFunction(pos -> TerrainGenerator.isLand(pos.x, pos.y));
        }
        BiomeAPI.registerEndBiomeModification((biomeID, biome) -> {
            if (!biomeID.equals((Object)class_1972.field_9473.method_29177())) {
                EndFeatures.addBiomeFeatures(biomeID, (class_6880<class_1959>)biome);
            }
        });
        BiomeAPI.onFinishingEndBiomeTags((biomeID, biome) -> {
            if (!biomeID.equals((Object)class_1972.field_9473.method_29177())) {
                EndStructures.addBiomeStructures(biomeID, (class_6880<class_1959>)biome);
            }
        });
    }

    public static class_2960 makeID(String path) {
        return new class_2960(MOD_ID, path);
    }
}

