/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;

public enum NoteBlockProvider implements IBlockComponentProvider
{
    INSTANCE;

    private static final int[] COLORS;

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.NOTE_BLOCK_TYPE)) {
            BlockState state = accessor.getBlockState();
            NoteBlockInstrument instrument = (NoteBlockInstrument)state.m_61143_((Property)NoteBlock.f_55011_);
            int level = (Integer)state.m_61143_((Property)NoteBlock.f_55013_);
            Note note = Note.get(level);
            StringBuilder builder = new StringBuilder().append(" (").append(config.getEnum(Options.NOTE_BLOCK_NOTE) == Options.NoteDisplayMode.SHARP ? note.sharp : note.flat).append(")");
            if (config.getBoolean(Options.NOTE_BLOCK_INT_VALUE)) {
                builder.append(" (").append(level).append(")");
            }
            tooltip.addLine().with((Component)Component.m_237115_((String)("tooltip.waila.instrument." + instrument.m_7912_()))).with((Component)Component.m_237113_((String)builder.toString()).m_130938_(style -> style.m_178520_(COLORS[level])));
        }
    }

    static {
        COLORS = (int[])Util.m_137469_((Object)new int[25], arr -> {
            float twoPi = (float)Math.PI * 2;
            float onePerThree = 0.33333334f;
            float twoPerThree = 0.6666667f;
            for (int i = 0; i < ((int[])arr).length; ++i) {
                float levelF = (float)i / 24.0f;
                int r = (int)(255.0f * Mth.m_14036_((float)(Mth.m_14031_((float)(levelF * twoPi)) * 0.65f + 0.35f), (float)0.0f, (float)1.0f));
                int g = (int)(255.0f * Mth.m_14036_((float)(Mth.m_14031_((float)((levelF + onePerThree) * twoPi)) * 0.65f + 0.35f), (float)0.0f, (float)1.0f));
                int b = (int)(255.0f * Mth.m_14036_((float)(Mth.m_14031_((float)((levelF + twoPerThree) * twoPi)) * 0.65f + 0.35f), (float)0.0f, (float)1.0f));
                arr[i] = (r << 16) + (g << 8) + b;
            }
        });
    }

    private static enum Note {
        FS("F\u266f", "G\u266d"),
        G("G"),
        GS("G\u266f", "A\u266d"),
        A("A"),
        AS("A\u266f", "B\u266d"),
        B("B"),
        C("C"),
        CS("C\u266f", "D\u266d"),
        D("D"),
        DS("D\u266f", "E\u266d"),
        E("E"),
        F("F");

        static final Note[] VALUES;
        final String sharp;
        final String flat;

        private Note(String sharp, String flat) {
            this.sharp = sharp;
            this.flat = flat;
        }

        private Note(String note) {
            this(note, note);
        }

        static Note get(int level) {
            return VALUES[level % VALUES.length];
        }

        static {
            VALUES = Note.values();
        }
    }
}

