/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.hud;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.text2speech.Narrator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.awt.Rectangle;
import java.util.function.Supplier;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.access.DataAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.EmptyComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.event.EventCanceller;
import mcp.mobius.waila.hud.Line;
import mcp.mobius.waila.hud.Tooltip;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;

public class TooltipHandler {
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final Object2IntOpenHashMap<Line> LINE_HEIGHT = new Object2IntOpenHashMap();
    private static final Supplier<Rectangle> RENDER_RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Rectangle> RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Narrator> NARRATOR = Suppliers.memoize(Narrator::getNarrator);
    static boolean shouldRender = false;
    private static String lastNarration = "";
    private static ITooltipComponent icon = EmptyComponent.INSTANCE;
    private static int topOffset;
    public static int colonOffset;
    public static int colonWidth;
    private static boolean started;

    public static void beginBuild() {
        TOOLTIP.clear();
        LINE_HEIGHT.clear();
        icon = EmptyComponent.INSTANCE;
        topOffset = 0;
        colonOffset = 0;
        colonWidth = Minecraft.m_91087_().f_91062_.m_92895_(": ");
        started = true;
    }

    public static void add(Tooltip tooltip) {
        Preconditions.checkState((boolean)started);
        ObjectListIterator objectListIterator = tooltip.iterator();
        while (objectListIterator.hasNext()) {
            Line line = (Line)objectListIterator.next();
            if (line.tag != null) {
                TOOLTIP.setLine(line.tag, line);
                continue;
            }
            TooltipHandler.add(line);
        }
    }

    public static void add(Line line) {
        Preconditions.checkState((boolean)started);
        TOOLTIP.add(line);
        for (ITooltipComponent component : line.components) {
            if (!(component instanceof PairComponent)) continue;
            PairComponent pair = (PairComponent)component;
            colonOffset = Math.max(pair.key.getWidth(), colonOffset);
            break;
        }
    }

    public static void setIcon(ITooltipComponent icon) {
        Preconditions.checkState((boolean)started);
        TooltipHandler.icon = PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_ICON) ? icon : EmptyComponent.INSTANCE;
    }

    public static void endBuild() {
        Preconditions.checkState((boolean)started);
        for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
            listener.onHandleTooltip(TOOLTIP, DataAccessor.INSTANCE, PluginConfig.INSTANCE);
        }
        TooltipHandler.narrateObjectName();
        Minecraft client = Minecraft.m_91087_();
        Window window = client.m_91268_();
        float scale = Waila.CONFIG.get().getOverlay().getScale();
        WailaConfig.Overlay.Position pos = Waila.CONFIG.get().getOverlay().getPosition();
        int w = 0;
        int h = 0;
        ObjectListIterator objectListIterator = TOOLTIP.iterator();
        while (objectListIterator.hasNext()) {
            Line line = (Line)objectListIterator.next();
            int lineW = line.getWidth();
            int lineH = line.getHeight();
            w = Math.max(w, lineW);
            h += lineH;
            LINE_HEIGHT.put((Object)line, lineH);
        }
        topOffset = 0;
        if (icon.getHeight() > h) {
            topOffset = Mth.m_184652_((int)(icon.getHeight() - h), (int)2);
        }
        if (icon.getWidth() > 0) {
            w += icon.getWidth() + 3;
        }
        w += 6;
        h = Math.max(h, icon.getHeight()) + TOOLTIP.size() - 1 + 6;
        int windowW = (int)((float)window.m_85445_() / scale);
        int windowH = (int)((float)window.m_85446_() / scale);
        IWailaConfig.Overlay.Position.Align.X anchorX = pos.getAnchor().getX();
        IWailaConfig.Overlay.Position.Align.Y anchorY = pos.getAnchor().getY();
        IWailaConfig.Overlay.Position.Align.X alignX = pos.getAlign().getX();
        IWailaConfig.Overlay.Position.Align.Y alignY = pos.getAlign().getY();
        double x = (double)windowW * anchorX.multiplier - (double)w * alignX.multiplier + (double)pos.getX();
        double y = (double)windowH * anchorY.multiplier - (double)h * alignY.multiplier + (double)pos.getY();
        if (!pos.isBossBarsOverlap() && anchorX == IWailaConfig.Overlay.Position.Align.X.CENTER && anchorY == IWailaConfig.Overlay.Position.Align.Y.TOP) {
            y += (double)Math.min(client.f_91065_.m_93090_().f_93699_.size() * 19, window.m_85446_() / 3 + 2);
        }
        RECT.get().setRect(x, y, w, h);
        started = false;
    }

    public static void render(PoseStack matrices, float delta) {
        if (!shouldRender) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        ProfilerFiller profiler = client.m_91307_();
        WailaConfig config = Waila.CONFIG.get();
        profiler.m_6180_("Waila Overlay");
        float scale = config.getOverlay().getScale();
        RenderSystem.m_157191_().m_85836_();
        RenderSystem.m_157191_().m_85841_(scale, scale, 1.0f);
        RenderSystem.m_157182_();
        matrices.m_85836_();
        DisplayUtil.enable2DRender();
        Rectangle rect = RENDER_RECT.get();
        rect.setRect(RECT.get());
        EventCanceller canceller = EventCanceller.INSTANCE;
        canceller.setCanceled(false);
        for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
            listener.onBeforeTooltipRender(matrices, rect, DataAccessor.INSTANCE, PluginConfig.INSTANCE, canceller);
            if (!canceller.isCanceled()) continue;
            matrices.m_85849_();
            RenderSystem.m_69482_();
            RenderSystem.m_157191_().m_85849_();
            RenderSystem.m_157182_();
            profiler.m_7238_();
            return;
        }
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        WailaConfig.Overlay.Color color = config.getOverlay().getColor();
        int bg = color.getBackgroundColor();
        int gradStart = color.getGradientStart();
        int gradEnd = color.getGradientEnd();
        DisplayUtil.drawGradientRect(matrices, x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + w, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + w - 1, y + 2, 1, h - 3, gradStart, gradEnd);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + 1, w - 1, 1, gradStart, gradStart);
        DisplayUtil.drawGradientRect(matrices, x + 1, y + h - 1, w - 1, 1, gradEnd, gradEnd);
        RenderSystem.m_69478_();
        int textX = x + (icon.getWidth() > 0 ? icon.getWidth() + 7 : 4);
        int textY = y + 4 + topOffset;
        ObjectListIterator objectListIterator = TOOLTIP.iterator();
        while (objectListIterator.hasNext()) {
            Line line = (Line)objectListIterator.next();
            line.render(matrices, textX, textY, delta);
            textY += LINE_HEIGHT.getInt((Object)line) + 1;
        }
        RenderSystem.m_69461_();
        matrices.m_85849_();
        for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
            listener.onAfterTooltipRender(matrices, rect, DataAccessor.INSTANCE, PluginConfig.INSTANCE);
        }
        icon.render(matrices, x + 4, y + Mth.m_184652_((int)(h - icon.getHeight()), (int)2), delta);
        RenderSystem.m_69482_();
        RenderSystem.m_157191_().m_85849_();
        RenderSystem.m_157182_();
        profiler.m_7238_();
    }

    private static void narrateObjectName() {
        ITooltipComponent iTooltipComponent;
        if (!shouldRender) {
            return;
        }
        Narrator narrator = NARRATOR.get();
        if (narrator.active() || !Waila.CONFIG.get().getGeneral().isEnableTextToSpeech() || Minecraft.m_91087_().f_91080_ instanceof ChatScreen) {
            return;
        }
        Line objectName = TOOLTIP.getTag(WailaConstants.OBJECT_NAME_TAG);
        if (objectName != null && (iTooltipComponent = objectName.components.get(0)) instanceof WrappedComponent) {
            WrappedComponent component = (WrappedComponent)iTooltipComponent;
            String narrate = component.component.getString();
            if (!lastNarration.equalsIgnoreCase(narrate)) {
                narrator.clear();
                narrator.say(narrate, true);
                lastNarration = narrate;
            }
        }
    }

    static {
        started = false;
    }
}

