/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.entry.type;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.REIRuntimeImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringCacheImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextImpl;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringContextType;
import me.shedaniel.rei.impl.client.entry.filtering.FilteringRule;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class EntryRegistryImpl
implements EntryRegistry {
    public List<Runnable> refilterListener = Lists.newCopyOnWriteArrayList();
    private List<EntryStack<?>> preFilteredList = Lists.newCopyOnWriteArrayList();
    private List<EntryStack<?>> entries = Lists.newCopyOnWriteArrayList();
    private LongSet entriesHash = new LongOpenHashSet();
    @Nullable
    private List<HashedEntryStackWrapper> reloadingRegistry;
    private boolean reloading;
    private static final Comparator<class_1799> STACK_COMPARATOR = (a, b) -> class_1799.method_7973((class_1799)a, (class_1799)b) ? 0 : 1;
    private MutableLong lastRefilterWarning = new MutableLong(-1L);

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerEntries(this);
    }

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void startReload() {
        this.refilterListener.clear();
        this.entries = Lists.newCopyOnWriteArrayList();
        this.entriesHash = new LongOpenHashSet();
        this.reloadingRegistry = Lists.newArrayListWithCapacity((int)(class_2378.field_11142.method_10235().size() + 100));
        this.preFilteredList = Lists.newCopyOnWriteArrayList();
        this.reloading = true;
    }

    @Override
    public void endReload() {
        this.reloading = false;
        this.preFilteredList = Lists.newCopyOnWriteArrayList();
        this.entries = Lists.newCopyOnWriteArrayList(CollectionUtils.filterAndMap(this.reloadingRegistry, ((Predicate<HashedEntryStackWrapper>)HashedEntryStackWrapper::isEmpty).negate(), HashedEntryStackWrapper::unwrap));
        this.reloadingRegistry = null;
        this.refilter();
        REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
    }

    @Override
    public int size() {
        return this.reloading ? this.reloadingRegistry.size() : this.entries.size();
    }

    @Override
    public Stream<EntryStack<?>> getEntryStacks() {
        return this.reloading ? this.reloadingRegistry.stream().map(HashedEntryStackWrapper::unwrap) : this.entries.stream();
    }

    @Override
    public List<EntryStack<?>> getPreFilteredList() {
        return Collections.unmodifiableList(this.preFilteredList);
    }

    @Override
    public void refilter() {
        ConfigObject config = ConfigObject.getInstance();
        if (config.getFilteredStackProviders() != null) {
            List<EntryStack> normalizedFilteredStacks = CollectionUtils.map(config.getFilteredStackProviders(), EntryStackProvider::provide);
            normalizedFilteredStacks.removeIf(EntryStack::isEmpty);
            config.getFilteredStackProviders().clear();
            config.getFilteredStackProviders().addAll(CollectionUtils.map(normalizedFilteredStacks, EntryStackProvider::ofStack));
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        FilteringContextImpl context = new FilteringContextImpl(this.entries);
        FilteringCacheImpl cache = new FilteringCacheImpl();
        List<FilteringRule<?>> rules = ((ConfigObjectImpl)ConfigObject.getInstance()).getFilteringRules();
        Stopwatch innerStopwatch = Stopwatch.createStarted();
        for (int i = rules.size() - 1; i >= 0; --i) {
            innerStopwatch.reset().start();
            FilteringRule<?> rule = rules.get(i);
            cache.setCache(rule, rule.prepareCache(true));
            context.handleResult(rule.processFilteredStacks(context, cache, true));
            RoughlyEnoughItemsCore.LOGGER.debug("Refiltered rule [%s] in %s.", ((class_2960)FilteringRule.REGISTRY.inverse().get(rule)).toString(), innerStopwatch.stop().toString());
        }
        Set<HashedEntryStackWrapper> hiddenStacks = context.stacks.get((Object)FilteringContextType.HIDDEN);
        this.preFilteredList = hiddenStacks.isEmpty() ? Lists.newCopyOnWriteArrayList(this.entries) : (List)this.entries.parallelStream().map(HashedEntryStackWrapper::new).filter(EntryRegistryImpl.not(hiddenStacks::contains)).map(HashedEntryStackWrapper::unwrap).collect(Collectors.toCollection(Lists::newCopyOnWriteArrayList));
        RoughlyEnoughItemsCore.LOGGER.debug("Refiltered %d entries with %d rules in %s.", this.entries.size() - this.preFilteredList.size(), rules.size(), stopwatch.stop().toString());
        for (Runnable runnable : this.refilterListener) {
            runnable.run();
        }
    }

    private static <T> Predicate<T> not(Predicate<? super T> target) {
        Objects.requireNonNull(target);
        return target.negate();
    }

    @Override
    public List<class_1799> appendStacksForItem(class_1792 item) {
        class_2371 list = class_2371.method_10211();
        LongOpenHashSet set = new LongOpenHashSet();
        EntryDefinition<class_1799> itemDefinition = VanillaEntryTypes.ITEM.getDefinition();
        for (class_1761 tab : class_1761.field_7921) {
            if (tab == class_1761.field_7925 || tab == class_1761.field_7918) continue;
            class_2371 tabList = class_2371.method_10211();
            item.method_7850(tab, tabList);
            for (class_1799 stack : tabList) {
                if (!set.add(itemDefinition.hash(null, stack, ComparisonContext.EXACT))) continue;
                list.add((Object)stack);
            }
        }
        if (list.isEmpty()) {
            return Collections.singletonList(item.method_7854());
        }
        if (list.size() > 1) {
            list.sort(STACK_COMPARATOR);
        }
        return list;
    }

    @Override
    public void addEntryAfter(@Nullable EntryStack<?> afterEntry, EntryStack<?> stack) {
        if (this.reloading) {
            int index = afterEntry != null ? this.reloadingRegistry.lastIndexOf(new HashedEntryStackWrapper(afterEntry)) : -1;
            HashedEntryStackWrapper wrapper = new HashedEntryStackWrapper(stack);
            if (this.entriesHash.add(wrapper.hashExact())) {
                if (index >= 0) {
                    this.reloadingRegistry.add(index, wrapper);
                } else {
                    this.reloadingRegistry.add(wrapper);
                }
            }
        } else if (this.entriesHash.add(EntryStacks.hashExact(stack))) {
            if (afterEntry != null) {
                int index = this.entries.lastIndexOf(afterEntry);
                this.entries.add(index, stack);
            } else {
                this.entries.add(stack);
            }
            this.preFilteredList.addAll(this.refilterNew(true, Collections.singletonList(stack)));
            this.queueSearchUpdate();
        }
    }

    @Override
    public void addEntriesAfter(@Nullable EntryStack<?> afterEntry, Collection<? extends EntryStack<?>> stacks) {
        if (this.reloading) {
            int index = afterEntry != null ? this.reloadingRegistry.lastIndexOf(new HashedEntryStackWrapper(afterEntry)) : -1;
            List<HashedEntryStackWrapper> filtered = CollectionUtils.mapAndFilter(stacks, wrapper -> this.entriesHash.add(wrapper.hashExact()), HashedEntryStackWrapper::new);
            if (index >= 0) {
                this.reloadingRegistry.addAll(index, filtered);
            } else {
                this.reloadingRegistry.addAll(filtered);
            }
        } else {
            List<EntryStack<?>> filtered = CollectionUtils.filterToList(stacks, stack -> this.entriesHash.add(EntryStacks.hashExact(stack)));
            if (afterEntry != null) {
                int index = this.entries.lastIndexOf(afterEntry);
                this.entries.addAll(index, filtered);
            } else {
                this.entries.addAll(filtered);
            }
            this.preFilteredList.addAll(this.refilterNew(true, filtered));
            this.queueSearchUpdate();
        }
    }

    private void queueSearchUpdate() {
        if (REIRuntimeImpl.getSearchField() != null) {
            ScreenOverlayImpl.getInstance().queueReloadSearch();
        }
    }

    @Override
    @ApiStatus.Internal
    public Collection<EntryStack<?>> refilterNew(boolean warn, Collection<EntryStack<?>> entries) {
        if (this.lastRefilterWarning != null && warn) {
            if (this.lastRefilterWarning.getValue() > 0L && System.currentTimeMillis() - this.lastRefilterWarning.getValue() > 5000L) {
                RoughlyEnoughItemsCore.LOGGER.warn("Detected runtime EntryRegistry modification, this can be extremely dangerous, or be extremely inefficient!");
            }
            this.lastRefilterWarning.setValue(System.currentTimeMillis());
        }
        FilteringContextImpl context = new FilteringContextImpl(entries);
        FilteringCacheImpl cache = new FilteringCacheImpl();
        List<FilteringRule<?>> rules = ((ConfigObjectImpl)ConfigObject.getInstance()).getFilteringRules();
        for (int i = rules.size() - 1; i >= 0; --i) {
            FilteringRule<?> rule = rules.get(i);
            cache.setCache(rule, rule.prepareCache(true));
            context.handleResult(rule.processFilteredStacks(context, cache, true));
        }
        Set<HashedEntryStackWrapper> hiddenStacks = context.stacks.get((Object)FilteringContextType.HIDDEN);
        if (hiddenStacks.isEmpty()) {
            return entries;
        }
        return entries.parallelStream().map(HashedEntryStackWrapper::new).filter(EntryRegistryImpl.not(hiddenStacks::contains)).map(HashedEntryStackWrapper::unwrap).collect(Collectors.toList());
    }

    @Override
    public boolean alreadyContain(EntryStack<?> stack) {
        return this.entriesHash.contains(EntryStacks.hashExact(stack));
    }

    @Override
    public boolean removeEntry(EntryStack<?> stack) {
        if (this.reloading) {
            HashedEntryStackWrapper wrapper = new HashedEntryStackWrapper(stack);
            this.reloadingRegistry.remove(wrapper);
            return this.entriesHash.remove(wrapper.hashExact());
        }
        this.preFilteredList.remove(stack);
        this.entries.remove(stack);
        return this.entriesHash.remove(EntryStacks.hashExact(stack));
    }

    @Override
    public boolean removeEntryIf(Predicate<? extends EntryStack<?>> predicate) {
        if (this.reloading) {
            return this.reloadingRegistry.removeIf(wrapper -> {
                if (predicate.test(wrapper.unwrap())) {
                    this.entriesHash.remove(wrapper.hashExact());
                    return true;
                }
                return false;
            });
        }
        Predicate<EntryStack> entryStackPredicate = stack -> {
            if (predicate.test((EntryStack<?>)stack)) {
                this.entriesHash.remove(EntryStacks.hashExact(stack));
                return true;
            }
            return false;
        };
        this.preFilteredList.removeIf(entryStackPredicate);
        return this.entries.removeIf(entryStackPredicate);
    }

    @Override
    public boolean removeEntryExactHashIf(LongPredicate predicate) {
        LongPredicate entryStackPredicate = hash -> {
            if (predicate.test(hash)) {
                this.entriesHash.remove(hash);
                return true;
            }
            return false;
        };
        if (this.reloading) {
            return this.reloadingRegistry.removeIf(wrapper -> entryStackPredicate.test(wrapper.hashExact()));
        }
        this.preFilteredList.removeIf(stack -> entryStackPredicate.test(EntryStacks.hashExact(stack)));
        return this.entries.removeIf(stack -> entryStackPredicate.test(EntryStacks.hashExact(stack)));
    }

    @Override
    public boolean removeEntryFuzzyHashIf(LongPredicate predicate) {
        Predicate<EntryStack> entryStackPredicate = stack -> {
            if (predicate.test(EntryStacks.hashFuzzy(stack))) {
                this.entriesHash.remove(EntryStacks.hashExact(stack));
                return true;
            }
            return false;
        };
        if (this.reloading) {
            return this.reloadingRegistry.removeIf(wrapper -> entryStackPredicate.test(wrapper.unwrap()));
        }
        this.preFilteredList.removeIf(entryStackPredicate);
        return this.entries.removeIf(entryStackPredicate);
    }
}

