/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.screen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZonesProvider;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@Environment(value=EnvType.CLIENT)
public class ExclusionZonesImpl
implements ExclusionZones {
    private static final Comparator<? super Rectangle> RECTANGLE_COMPARER = Comparator.comparingLong(Rectangle::hashCode);
    private long lastArea = -1L;
    private final Multimap<Class<?>, Function<class_437, Collection<Rectangle>>> list = HashMultimap.create();

    @Override
    public <R extends class_437> boolean isHandingScreen(Class<R> screen) {
        return class_437.class.isAssignableFrom(screen);
    }

    @Override
    public double getPriority() {
        return -5.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public class_1269 isInZone(double mouseX, double mouseY) {
        class_437 screen = class_310.method_1551().field_1755;
        Class<?> screenClass = screen.getClass();
        Multimap<Class<?>, Function<class_437, Collection<Rectangle>>> multimap = this.list;
        synchronized (multimap) {
            for (Map.Entry collectionEntry : this.list.asMap().entrySet()) {
                if (!((Class)collectionEntry.getKey()).isAssignableFrom(screenClass)) continue;
                for (Function listSupplier : (Collection)collectionEntry.getValue()) {
                    for (Rectangle zone : (Collection)listSupplier.apply(screen)) {
                        if (!zone.contains(mouseX, mouseY)) continue;
                        return class_1269.field_5814;
                    }
                }
            }
        }
        return class_1269.field_5811;
    }

    @Override
    public boolean shouldRecalculateArea(DisplayPanelLocation location, Rectangle rectangle) {
        long current = this.currentHashCode(location);
        if (this.lastArea == current) {
            return false;
        }
        this.lastArea = current;
        return true;
    }

    private long currentHashCode(DisplayPanelLocation location) {
        return this.areasHashCode(this.getExclusionZones(class_310.method_1551().field_1755, false));
    }

    @Override
    @Deprecated
    public List<Rectangle> getExclusionZones(Class<?> currentScreenClass, boolean sort) {
        return this.getExclusionZones(currentScreenClass, class_310.method_1551().field_1755, sort);
    }

    @Override
    public List<Rectangle> getExclusionZones(class_437 screen, boolean sort) {
        if (screen == null) {
            return Lists.newArrayList();
        }
        return this.getExclusionZones(screen.getClass(), screen, sort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Rectangle> getExclusionZones(Class<?> screenClass, class_437 screen, boolean sort) {
        if (screen == null || !screenClass.isAssignableFrom(screen.getClass())) {
            return Lists.newArrayList();
        }
        ArrayList rectangles = Lists.newArrayList();
        Multimap<Class<?>, Function<class_437, Collection<Rectangle>>> multimap = this.list;
        synchronized (multimap) {
            for (Map.Entry collectionEntry : this.list.asMap().entrySet()) {
                if (!((Class)collectionEntry.getKey()).isAssignableFrom(screenClass)) continue;
                for (Function listSupplier : (Collection)collectionEntry.getValue()) {
                    rectangles.addAll((Collection)listSupplier.apply(screen));
                }
            }
        }
        if (sort) {
            rectangles.sort(RECTANGLE_COMPARER);
        }
        return rectangles;
    }

    @Override
    public int getZonesCount() {
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void register(Class<? extends T> screenClass, ExclusionZonesProvider<? extends T> provider) {
        Multimap<Class<?>, Function<class_437, Collection<Rectangle>>> multimap = this.list;
        synchronized (multimap) {
            this.list.put(screenClass, screen -> provider.provide(screen));
        }
        if (!PluginManager.areAnyReloading()) {
            RoughlyEnoughItemsCore.LOGGER.warn("Detected ExclusionZonesImpl modification at runtime, this may cause issues, a single ExclusionZonesProvider can dynamically provide boundaries instead!", new RuntimeException());
        }
    }

    private long areasHashCode(List<Rectangle> exclusionZones) {
        int hashCode = 31;
        for (Rectangle e : exclusionZones) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }
}

