/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Point;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.CachedEntryListRender;
import me.shedaniel.rei.impl.client.gui.widget.DisplayedEntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import net.minecraft.class_4587;

public class EntryListStackEntry
extends DisplayedEntryWidget {
    private final EntryListWidget parent;
    public EntryStack<?> our;
    private NumberAnimator<Double> size = null;

    public EntryListStackEntry(EntryListWidget parent, int x, int y, int entrySize, boolean zoomed) {
        super(new Point(x, y), entrySize);
        this.parent = parent;
        if (zoomed) {
            this.noHighlight();
            this.size = ValueAnimator.ofDouble((double)1.0).withConvention(() -> {
                double mouseX = PointHelper.getMouseFloatingX();
                double mouseY = PointHelper.getMouseFloatingY();
                int x1 = this.getBounds().getCenterX() - entrySize / 2;
                int y1 = this.getBounds().getCenterY() - entrySize / 2;
                boolean hovering = mouseX >= (double)x1 && mouseX < (double)(x1 + entrySize) && mouseY >= (double)y1 && mouseY < (double)(y1 + entrySize);
                return hovering ? 1.5 : 1.0;
            }, 200L);
        }
    }

    @Override
    protected void drawExtra(class_4587 matrices, int mouseX, int mouseY, float delta) {
        if (this.size != null) {
            this.size.update((double)delta);
            int centerX = this.getBounds().getCenterX();
            int centerY = this.getBounds().getCenterY();
            int entrySize = (int)Math.round((double)EntryListWidget.entrySize() * (Double)this.size.value());
            this.getBounds().setBounds(centerX - entrySize / 2, centerY - entrySize / 2, entrySize, entrySize);
        }
        super.drawExtra(matrices, mouseX, mouseY, delta);
    }

    @Override
    public EntryStack<?> getCurrentEntry() {
        if (this.our != null && CachedEntryListRender.cachedTextureLocation != null) {
            return this.our;
        }
        return super.getCurrentEntry();
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return super.containsMouse(mouseX, mouseY) && this.parent.containsChecked(mouseX, mouseY, true);
    }
}

