/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.widgets;

import com.google.common.collect.AbstractIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.shedaniel.math.Dimension;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.DrawableConsumer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Arrow;
import me.shedaniel.rei.api.client.gui.widgets.BurningFire;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidget;
import me.shedaniel.rei.api.client.gui.widgets.DelegateWidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetHolder;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.impl.ClientInternals;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1159;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_5348;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class Widgets {
    private Widgets() {
    }

    public static Widget createDrawableWidget(DrawableConsumer drawable) {
        return ClientInternals.getWidgetsProvider().createDrawableWidget(drawable);
    }

    public static WidgetWithBounds withTooltip(WidgetWithBounds widget, class_2561 ... texts) {
        return Widgets.withTooltip(widget, Arrays.asList(texts));
    }

    public static WidgetWithBounds withTooltip(WidgetWithBounds widget, Collection<class_2561> texts) {
        Widget[] widgetArray = new Widget[2];
        widgetArray[0] = widget;
        widgetArray[1] = Widgets.createTooltip(widget::getBounds, texts);
        return Widgets.withBounds(Widgets.concat(widgetArray), widget::getBounds);
    }

    public static Widget createTooltip(Rectangle bounds, class_2561 ... texts) {
        return Widgets.createTooltip(() -> bounds, Arrays.asList(texts));
    }

    public static Widget createTooltip(Rectangle bounds, Collection<class_2561> texts) {
        return Widgets.createTooltip(() -> bounds, texts);
    }

    public static Widget createTooltip(Supplier<Rectangle> bounds, class_2561 ... texts) {
        return Widgets.createTooltip(bounds, Arrays.asList(texts));
    }

    public static Widget createTooltip(Supplier<Rectangle> bounds, Collection<class_2561> texts) {
        return Widgets.createTooltip(mouse -> {
            if (((Rectangle)bounds.get()).contains(mouse)) {
                return Tooltip.create(mouse, texts);
            }
            return null;
        });
    }

    public static Widget createTooltip(Function<Point, @Nullable Tooltip> tooltipSupplier) {
        return Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> {
            Point mouse = new Point(mouseX, mouseY);
            Tooltip tooltip = (Tooltip)tooltipSupplier.apply(mouse);
            if (tooltip != null) {
                tooltip.queue();
            }
        });
    }

    public static Widget wrapVanillaWidget(class_364 element) {
        return ClientInternals.getWidgetsProvider().wrapVanillaWidget(element);
    }

    public static WidgetWithBounds withTranslate(Widget widget, double x, double y, double z) {
        return Widgets.withTranslate(widget, class_1159.method_24021((float)((float)x), (float)((float)y), (float)((float)z)));
    }

    public static WidgetWithBounds withTranslate(Widget widget, class_1159 translate) {
        return Widgets.withTranslate(widget, () -> translate);
    }

    public static <T extends Widget> WidgetWithBounds withTranslate(T widget, Function<T, class_1159> translate) {
        return Widgets.withTranslate(widget, () -> (class_1159)translate.apply(widget));
    }

    public static WidgetWithBounds withTranslate(Widget widget, Supplier<class_1159> translate) {
        WidgetWithBounds widgetWithBounds = Widgets.wrapWidgetWithBounds(widget);
        return ClientInternals.getWidgetsProvider().withTranslate(widgetWithBounds, translate);
    }

    public static WidgetWithBounds wrapRenderer(Rectangle bounds, Renderer renderer) {
        return Widgets.wrapRenderer(() -> bounds, renderer);
    }

    public static WidgetWithBounds wrapRenderer(Supplier<Rectangle> bounds, Renderer renderer) {
        if (renderer instanceof Widget) {
            Widget widget = (Widget)renderer;
            return Widgets.wrapWidgetWithBoundsSupplier(widget, bounds);
        }
        return ClientInternals.getWidgetsProvider().wrapRenderer(bounds, renderer);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval
    public static WidgetWithBounds wrapWidgetWithBounds(Widget widget) {
        return Widgets.withBounds(widget);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval
    public static WidgetWithBounds wrapWidgetWithBounds(Widget widget, Rectangle bounds) {
        return Widgets.withBounds(widget, bounds);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval
    public static WidgetWithBounds wrapWidgetWithBoundsSupplier(Widget widget, Supplier<Rectangle> bounds) {
        return Widgets.withBounds(widget, bounds);
    }

    public static WidgetWithBounds withBounds(Widget widget) {
        return Widgets.wrapWidgetWithBounds(widget, null);
    }

    public static WidgetWithBounds withBounds(Widget widget, Rectangle bounds) {
        return Widgets.wrapWidgetWithBoundsSupplier(widget, bounds == null ? null : () -> bounds);
    }

    public static WidgetWithBounds withBounds(Widget widget, Supplier<Rectangle> bounds) {
        if (widget instanceof WidgetWithBounds) {
            WidgetWithBounds withBounds = (WidgetWithBounds)widget;
            return withBounds;
        }
        if (bounds == null) {
            return new DelegateWidget(widget);
        }
        return new DelegateWidgetWithBounds(widget, bounds);
    }

    public static Widget createTexturedWidget(class_2960 identifier, Rectangle bounds) {
        return Widgets.createTexturedWidget(identifier, bounds, 0.0f, 0.0f);
    }

    public static Widget createTexturedWidget(class_2960 identifier, int x, int y, int width, int height) {
        return Widgets.createTexturedWidget(identifier, x, y, 0.0f, 0.0f, width, height);
    }

    public static Widget createTexturedWidget(class_2960 identifier, Rectangle bounds, float u, float v) {
        return Widgets.createTexturedWidget(identifier, bounds, u, v, 256, 256);
    }

    public static Widget createTexturedWidget(class_2960 identifier, int x, int y, float u, float v, int width, int height) {
        return Widgets.createTexturedWidget(identifier, x, y, u, v, width, height, 256, 256);
    }

    public static Widget createTexturedWidget(class_2960 identifier, Rectangle bounds, float u, float v, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, bounds.x, bounds.y, u, v, bounds.width, bounds.height, bounds.width, bounds.height, textureWidth, textureHeight);
    }

    public static Widget createTexturedWidget(class_2960 identifier, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, x, y, u, v, width, height, width, height, textureWidth, textureHeight);
    }

    public static Widget createTexturedWidget(class_2960 identifier, Rectangle bounds, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return Widgets.createTexturedWidget(identifier, bounds.x, bounds.y, u, v, bounds.width, bounds.height, uWidth, vHeight, textureWidth, textureHeight);
    }

    public static Widget createTexturedWidget(class_2960 identifier, int x, int y, float u, float v, int width, int height, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        return Widgets.createDrawableWidget(ClientInternals.getWidgetsProvider().createTexturedConsumer(identifier, x, y, width, height, u, v, uWidth, vHeight, textureWidth, textureHeight));
    }

    public static Widget createFilledRectangle(Rectangle rectangle, int color) {
        return Widgets.createDrawableWidget(ClientInternals.getWidgetsProvider().createFillRectangleConsumer(rectangle, color));
    }

    public static Label createLabel(Point point, class_2561 text) {
        return ClientInternals.getWidgetsProvider().createLabel(point, (class_5348)text);
    }

    public static Label createClickableLabel(Point point, class_2561 text, @Nullable Consumer<Label> onClick) {
        return Widgets.createLabel(point, text).clickable().onClick(onClick);
    }

    public static Arrow createArrow(Point point) {
        return ClientInternals.getWidgetsProvider().createArrow(new Rectangle(point, new Dimension(24, 17)));
    }

    public static BurningFire createBurningFire(Point point) {
        return ClientInternals.getWidgetsProvider().createBurningFire(new Rectangle(point, new Dimension(14, 14)));
    }

    public static Widget createSlotBackground(Point point) {
        return Widgets.createSlotBase(new Rectangle(point.x - 1, point.y - 1, 18, 18));
    }

    public static Widget createResultSlotBackground(Point point) {
        return Widgets.createSlotBase(new Rectangle(point.x - 5, point.y - 5, 26, 26));
    }

    public static Panel createCategoryBase(Rectangle rectangle) {
        return ClientInternals.getWidgetsProvider().createPanelWidget(rectangle);
    }

    public static Panel createCategoryBase(Rectangle rectangle, int color) {
        return Widgets.createCategoryBase(rectangle).color(color);
    }

    public static Panel createRecipeBase(Rectangle rectangle) {
        return ClientInternals.getWidgetsProvider().createPanelWidget(rectangle).yTextureOffset(ConfigObject.getInstance().getRecipeBorderType().getYOffset()).rendering(Widgets::shouldRecipeBaseRender);
    }

    public static Panel createRecipeBase(Rectangle rectangle, int color) {
        return Widgets.createRecipeBase(rectangle).color(color);
    }

    private static boolean shouldRecipeBaseRender(Panel panel) {
        return ConfigObject.getInstance().getRecipeBorderType().isRendering() && ClientInternals.getWidgetsProvider().isRenderingPanel(panel);
    }

    public static Panel createSlotBase(Rectangle rectangle) {
        return ClientInternals.getWidgetsProvider().createPanelWidget(rectangle).yTextureOffset(-66).rendering(Widgets::shouldSlotBaseRender);
    }

    private static boolean shouldSlotBaseRender(Panel panel) {
        return true;
    }

    public static Panel createSlotBase(Rectangle rectangle, int color) {
        return Widgets.createSlotBase(rectangle).color(color);
    }

    public static Widget createShapelessIcon(Rectangle rectangle) {
        return Widgets.createShapelessIcon(new Point(rectangle.getMaxX() - 4, rectangle.y + 4));
    }

    public static Widget createShapelessIcon(Point topRightPos) {
        return ClientInternals.getWidgetsProvider().createShapelessIcon(topRightPos);
    }

    public static Slot createSlot(Point point) {
        return ClientInternals.getWidgetsProvider().createSlot(point);
    }

    public static Slot createSlot(Rectangle bounds) {
        return ClientInternals.getWidgetsProvider().createSlot(bounds);
    }

    public static Button createButton(Rectangle bounds, class_2561 text) {
        return ClientInternals.getWidgetsProvider().createButton(bounds, text);
    }

    public static void produceClickSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
    }

    public static Widget concat(Widget ... widgets) {
        return Widgets.concat(Arrays.asList(widgets));
    }

    public static Widget concat(List<Widget> widgets) {
        return ClientInternals.getWidgetsProvider().concatWidgets(widgets);
    }

    public static <T> Iterable<T> walk(final Iterable<? extends class_364> listeners, final Predicate<class_364> predicate) {
        return () -> new AbstractIterator<T>(){
            Stack<Iterator<? extends class_364>> stack;
            Set<T> visited = new HashSet();
            {
                this.stack = new Stack();
                this.stack.push(listeners.iterator());
            }

            protected T computeNext() {
                while (!this.stack.empty()) {
                    WidgetHolder holder;
                    List<? extends class_364> children;
                    Iterator<? extends class_364> peek = this.stack.peek();
                    if (!peek.hasNext()) {
                        this.stack.pop();
                    }
                    if (this.stack.isEmpty()) break;
                    class_364 listener = peek.next();
                    if (!peek.hasNext()) {
                        this.stack.pop();
                    }
                    if (predicate.test(listener) && this.visited.add(listener)) {
                        return listener;
                    }
                    if (listener instanceof class_4069) {
                        class_4069 handler = (class_4069)listener;
                        children = handler.method_25396();
                        if (children.isEmpty()) continue;
                        this.stack.push(children.iterator());
                        continue;
                    }
                    if (!(listener instanceof WidgetHolder) || (children = (holder = (WidgetHolder)listener).children()).isEmpty()) continue;
                    this.stack.push(children.iterator());
                }
                return this.endOfData();
            }
        };
    }
}

