/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import com.google.common.collect.ImmutableList;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.function.UnaryOperator;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import me.shedaniel.rei.PluginDetector;
import me.shedaniel.rei.RoughlyEnoughItemsCoreClient;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.common.entry.comparison.FluidComparatorRegistry;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.impl.Internals;
import me.shedaniel.rei.impl.common.InternalLogger;
import me.shedaniel.rei.impl.common.category.CategoryIdentifierImpl;
import me.shedaniel.rei.impl.common.display.DisplaySerializerRegistryImpl;
import me.shedaniel.rei.impl.common.entry.DeferringEntryTypeProviderImpl;
import me.shedaniel.rei.impl.common.entry.EntryIngredientImpl;
import me.shedaniel.rei.impl.common.entry.EntryStackProviderImpl;
import me.shedaniel.rei.impl.common.entry.comparison.FluidComparatorRegistryImpl;
import me.shedaniel.rei.impl.common.entry.comparison.ItemComparatorRegistryImpl;
import me.shedaniel.rei.impl.common.entry.comparison.NbtHasherProviderImpl;
import me.shedaniel.rei.impl.common.entry.settings.EntrySettingsAdapterRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.EntryTypeRegistryImpl;
import me.shedaniel.rei.impl.common.fluid.FluidSupportProviderImpl;
import me.shedaniel.rei.impl.common.logging.FileLogger;
import me.shedaniel.rei.impl.common.logging.FilteringLogger;
import me.shedaniel.rei.impl.common.logging.Log4JLogger;
import me.shedaniel.rei.impl.common.logging.MultiLogger;
import me.shedaniel.rei.impl.common.logging.TransformingLogger;
import me.shedaniel.rei.impl.common.logging.performance.PerformanceLogger;
import me.shedaniel.rei.impl.common.logging.performance.PerformanceLoggerImpl;
import me.shedaniel.rei.impl.common.plugins.PluginManagerImpl;
import me.shedaniel.rei.impl.common.registry.RecipeManagerContextImpl;
import me.shedaniel.rei.impl.common.transfer.MenuInfoRegistryImpl;
import net.minecraft.class_3264;
import net.minecraft.class_3902;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class RoughlyEnoughItemsCore {
    @ApiStatus.Internal
    public static final InternalLogger LOGGER = new TransformingLogger(new MultiLogger((Iterable<InternalLogger>)ImmutableList.of((Object)new FileLogger(Platform.getGameFolder().resolve("logs/rei.log")), (Object)new FilteringLogger(new FileLogger(Platform.getGameFolder().resolve("logs/rei-issues.log")), Level.WARN), (Object)new Log4JLogger(LogManager.getFormatterLogger((String)"REI")))), message -> "[REI] " + message);
    public static final PerformanceLogger PERFORMANCE_LOGGER = new PerformanceLoggerImpl();

    public static void attachCommonInternals() {
        CategoryIdentifierImpl.attach();
        Internals.attachInstance(DeferringEntryTypeProviderImpl.INSTANCE, "entryTypeDeferred");
        Internals.attachInstance(EntryStackProviderImpl.INSTANCE, Internals.EntryStackProvider.class);
        Internals.attachInstance(NbtHasherProviderImpl.INSTANCE, Internals.NbtHasherProvider.class);
        Internals.attachInstance(EntryIngredientImpl.INSTANCE, Internals.EntryIngredientProvider.class);
        Internals.attachInstanceSupplier(new PluginManagerImpl<REIPlugin>(REIPlugin.class, UnaryOperator.identity(), usedTime -> LOGGER.info("Reloaded Plugin Manager [%s] with %d entry types, %d item comparators, %d fluid comparators and %d fluid support providers in %dms.", REIPlugin.class.getSimpleName(), EntryTypeRegistry.getInstance().values().size(), ItemComparatorRegistry.getInstance().comparatorSize(), FluidComparatorRegistry.getInstance().comparatorSize(), FluidSupportProvider.getInstance().size(), usedTime), new EntryTypeRegistryImpl(), new EntrySettingsAdapterRegistryImpl(), new RecipeManagerContextImpl(RecipeManagerContextImpl.supplier()), new ItemComparatorRegistryImpl(), new FluidComparatorRegistryImpl(), new DisplaySerializerRegistryImpl(), new FluidSupportProviderImpl()), "commonPluginManager");
        Internals.attachInstanceSupplier(new PluginManagerImpl<REIServerPlugin>(REIServerPlugin.class, view -> view.then(PluginView.getInstance()), usedTime -> LOGGER.info("Reloaded Plugin Manager [%s] with %d menu infos in %dms.", REIServerPlugin.class.getSimpleName(), MenuInfoRegistry.getInstance().infoSize(), usedTime), new MenuInfoRegistryImpl()), "serverPluginManager");
        Internals.attachInstanceSupplier(LOGGER, "logger");
    }

    public static void _reloadPlugins(@Nullable ReloadStage stage) {
        if (stage == null) {
            for (ReloadStage reloadStage : ReloadStage.values()) {
                RoughlyEnoughItemsCore._reloadPlugins(reloadStage);
            }
            return;
        }
        try {
            for (PluginManager<REIPlugin<?>> instance : PluginManager.getActiveInstances()) {
                instance.view().pre(stage);
            }
            for (PluginManager<REIPlugin<?>> instance : PluginManager.getActiveInstances()) {
                instance.startReload(stage);
            }
            for (PluginManager<REIPlugin<?>> instance : PluginManager.getActiveInstances()) {
                instance.view().post(stage);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void onInitialize() {
        PluginDetector.detectCommonPlugins();
        PluginDetector.detectServerPlugins();
        RoughlyEnoughItemsNetwork.onInitialize();
        if (Platform.getEnvironment() == Env.SERVER) {
            MutableLong lastReload = new MutableLong(-1L);
            ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2) -> preparationBarrier.method_18352((Object)class_3902.field_17274).thenRunAsync(() -> {
                PERFORMANCE_LOGGER.clear();
                RoughlyEnoughItemsCore._reloadPlugins(null);
            }, executor2));
        }
    }

    static {
        RoughlyEnoughItemsCore.attachCommonInternals();
        if (Platform.getEnvironment() == Env.CLIENT) {
            EnvExecutor.runInEnv((Env)Env.CLIENT, () -> RoughlyEnoughItemsCoreClient::attachClientInternals);
        }
    }
}

