/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.network.serialization;

import io.netty.buffer.ByteBuf;
import io.wispforest.owo.network.annotations.SealedPolymorphic;
import io.wispforest.owo.network.serialization.RecordSerializer;
import io.wispforest.owo.util.VectorSerializer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public record PacketBufSerializer<T>(class_2540.class_7462<T> serializer, class_2540.class_7461<T> deserializer) {
    private static final Map<Class<?>, Supplier<?>> COLLECTION_PROVIDERS = new HashMap();
    private static final Map<Class<?>, PacketBufSerializer<?>> SERIALIZERS = new HashMap();

    public static <T> void register(Class<T> clazz, PacketBufSerializer<T> serializer) {
        if (SERIALIZERS.containsKey(clazz)) {
            throw new IllegalStateException("Class '" + clazz.getName() + "' already has a serializer");
        }
        SERIALIZERS.put(clazz, serializer);
    }

    public static <T> void register(Class<T> clazz, class_2540.class_7462<T> serializer, class_2540.class_7461<T> deserializer) {
        PacketBufSerializer.register(clazz, new PacketBufSerializer<T>(serializer, deserializer));
    }

    @SafeVarargs
    private static <T> void register(class_2540.class_7462<T> serializer, class_2540.class_7461<T> deserializer, Class<T> ... classes) {
        PacketBufSerializer<T> packetSerializer = new PacketBufSerializer<T>(serializer, deserializer);
        for (Class<T> clazz : classes) {
            PacketBufSerializer.register(clazz, packetSerializer);
        }
    }

    public static PacketBufSerializer<?> getGeneric(Type type) {
        if (type instanceof Class) {
            Class klass = (Class)type;
            return PacketBufSerializer.get(klass);
        }
        ParameterizedType pType = (ParameterizedType)type;
        Class raw = (Class)pType.getRawType();
        Type[] typeArgs = pType.getActualTypeArguments();
        if (Map.class.isAssignableFrom(raw)) {
            return PacketBufSerializer.createMapSerializer(PacketBufSerializer.conform(raw, Map.class), (Class)typeArgs[0], (Class)typeArgs[1]);
        }
        if (Collection.class.isAssignableFrom(raw)) {
            return PacketBufSerializer.createCollectionSerializer(PacketBufSerializer.conform(raw, Collection.class), (Class)typeArgs[0]);
        }
        if (Optional.class.isAssignableFrom(raw)) {
            return PacketBufSerializer.createOptionalSerializer((Class)typeArgs[0]);
        }
        return PacketBufSerializer.get(raw);
    }

    public static <T> PacketBufSerializer<T> get(Class<T> clazz) {
        PacketBufSerializer<T> serializer = PacketBufSerializer.getOrNull(clazz);
        if (serializer == null) {
            throw new IllegalStateException("No serializer available for class '" + clazz.getName() + "'");
        }
        return serializer;
    }

    public static <T> Optional<PacketBufSerializer<T>> maybeGet(Class<T> clazz) {
        return Optional.ofNullable(PacketBufSerializer.getOrNull(clazz));
    }

    @Nullable
    private static <T> PacketBufSerializer<T> getOrNull(Class<T> clazz) {
        PacketBufSerializer<Object> serializer = SERIALIZERS.get(clazz);
        if (serializer == null) {
            if (Record.class.isAssignableFrom(clazz)) {
                serializer = PacketBufSerializer.createRecordSerializer(PacketBufSerializer.conform(clazz, Record.class));
            } else if (clazz.isEnum()) {
                serializer = PacketBufSerializer.createEnumSerializer(PacketBufSerializer.conform(clazz, Enum.class));
            } else if (clazz.isArray()) {
                serializer = PacketBufSerializer.createArraySerializer(clazz.getComponentType());
            } else if (clazz.isAnnotationPresent(SealedPolymorphic.class)) {
                serializer = PacketBufSerializer.createSealedSerializer(clazz);
            } else {
                return null;
            }
            SERIALIZERS.put(clazz, serializer);
        }
        return serializer;
    }

    public static <T> void registerCollectionProvider(Class<T> clazz, Supplier<T> provider) {
        if (COLLECTION_PROVIDERS.containsKey(clazz)) {
            throw new IllegalStateException("Collection class '" + clazz.getName() + "' already has a provider");
        }
        COLLECTION_PROVIDERS.put(clazz, provider);
    }

    public static <T> T createCollection(Class<? extends T> clazz) {
        if (!COLLECTION_PROVIDERS.containsKey(clazz)) {
            throw new IllegalStateException("No collection provider registered for collection class " + clazz.getName());
        }
        return (T)COLLECTION_PROVIDERS.get(clazz).get();
    }

    public static <K, V, T extends Map<K, V>> PacketBufSerializer<T> createMapSerializer(Class<T> clazz, Class<K> keyClass, Class<V> valueClass) {
        PacketBufSerializer.createCollection(clazz);
        PacketBufSerializer keySerializer = PacketBufSerializer.get(keyClass);
        PacketBufSerializer valueSerializer = PacketBufSerializer.get(valueClass);
        return new PacketBufSerializer<T>((buf, t) -> buf.method_34063(t, keySerializer.serializer(), valueSerializer.serializer()), buf -> buf.method_34069(buf1 -> (Map)PacketBufSerializer.createCollection(clazz), keySerializer.deserializer(), valueSerializer.deserializer()));
    }

    public static <E, T extends Collection<E>> PacketBufSerializer<T> createCollectionSerializer(Class<T> clazz, Class<E> elementClass) {
        PacketBufSerializer.createCollection(clazz);
        PacketBufSerializer elementSerializer = PacketBufSerializer.get(elementClass);
        return new PacketBufSerializer<T>((buf, t) -> buf.method_34062(t, elementSerializer.serializer()), buf -> buf.method_34068(value -> (Collection)PacketBufSerializer.createCollection(clazz), elementSerializer.deserializer()));
    }

    public static <E> PacketBufSerializer<Optional<E>> createOptionalSerializer(Class<E> elementClass) {
        PacketBufSerializer elementSerializer = PacketBufSerializer.get(elementClass);
        return new PacketBufSerializer<Optional<E>>((buf, t) -> buf.method_37435(t, elementSerializer.serializer()), buf -> buf.method_37436(elementSerializer.deserializer()));
    }

    public static PacketBufSerializer<?> createArraySerializer(Class<?> elementClass) {
        PacketBufSerializer<?> elementSerializer = PacketBufSerializer.get(elementClass);
        return new PacketBufSerializer((buf, t) -> {
            int length = Array.getLength(t);
            buf.method_10804(length);
            for (int i = 0; i < length; ++i) {
                elementSerializer.serializer().accept(buf, Array.get(t, i));
            }
        }, buf -> {
            int length = buf.method_10816();
            Object array = Array.newInstance(elementClass, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, elementSerializer.deserializer().apply(buf));
            }
            return array;
        });
    }

    public static <R extends Record> PacketBufSerializer<R> createRecordSerializer(Class<R> clazz) {
        RecordSerializer<R> serializer = RecordSerializer.create(clazz);
        return new PacketBufSerializer(serializer::write, serializer::read);
    }

    public static <E extends Enum<E>> PacketBufSerializer<E> createEnumSerializer(Class<E> enumClass) {
        return new PacketBufSerializer(class_2540::method_10817, buf -> buf.method_10818(enumClass));
    }

    public static <T, K> PacketBufSerializer<T> createDispatchedSerializer(Function<K, PacketBufSerializer<? extends T>> keyToSerializer, Function<T, K> keyGetter, PacketBufSerializer<K> keySerializer) {
        return new PacketBufSerializer<T>((buf, value) -> {
            Object key = keyGetter.apply(value);
            PacketBufSerializer serializer = (PacketBufSerializer)keyToSerializer.apply(key);
            keySerializer.serializer.accept(buf, key);
            serializer.serializer.accept(buf, value);
        }, buf -> {
            Object key = keySerializer.deserializer.apply(buf);
            PacketBufSerializer serializer = (PacketBufSerializer)keyToSerializer.apply(key);
            return serializer.deserializer.apply(buf);
        });
    }

    private static PacketBufSerializer<?> createSealedSerializer(Class<?> commonClass) {
        if (!commonClass.isSealed()) {
            throw new IllegalStateException("@SealedPolymorphic class should be sealed!");
        }
        List sortedPermittedSubclasses = Arrays.stream(commonClass.getPermittedSubclasses()).collect(Collectors.toList());
        for (int i = 0; i < sortedPermittedSubclasses.size(); ++i) {
            Class klass = (Class)sortedPermittedSubclasses.get(i);
            if (!klass.isSealed()) continue;
            for (Class<?> subclass : klass.getPermittedSubclasses()) {
                if (sortedPermittedSubclasses.contains(subclass)) continue;
                sortedPermittedSubclasses.add(subclass);
            }
        }
        for (Class klass : sortedPermittedSubclasses) {
            if (klass.isSealed() || Modifier.isFinal(klass.getModifiers())) continue;
            throw new IllegalStateException("Subclasses of a @SealedPolymorphic class must be sealed themselves!");
        }
        sortedPermittedSubclasses.sort(Comparator.comparing(Class::getName));
        Int2ObjectOpenHashMap serializerMap = new Int2ObjectOpenHashMap();
        Reference2IntOpenHashMap classesMap = new Reference2IntOpenHashMap();
        classesMap.defaultReturnValue(-1);
        for (int i = 0; i < sortedPermittedSubclasses.size(); ++i) {
            Class klass = (Class)sortedPermittedSubclasses.get(i);
            serializerMap.put(i, PacketBufSerializer.get(klass));
            classesMap.put((Object)klass, i);
        }
        return new PacketBufSerializer((arg_0, arg_1) -> PacketBufSerializer.lambda$createSealedSerializer$13((Reference2IntMap)classesMap, commonClass, (Int2ObjectMap)serializerMap, arg_0, arg_1), arg_0 -> PacketBufSerializer.lambda$createSealedSerializer$14((Int2ObjectMap)serializerMap, arg_0));
    }

    private static <T> Class<T> conform(Class<?> clazz, Class<T> target) {
        return clazz;
    }

    private static /* synthetic */ Object lambda$createSealedSerializer$14(Int2ObjectMap serializerMap, class_2540 buf) {
        int idx = buf.method_10816();
        PacketBufSerializer serializer = (PacketBufSerializer)serializerMap.get(idx);
        if (serializer == null) {
            throw new IllegalStateException("Unknown index " + idx);
        }
        return serializer.deserializer.apply((Object)buf);
    }

    private static /* synthetic */ void lambda$createSealedSerializer$13(Reference2IntMap classesMap, Class commonClass, Int2ObjectMap serializerMap, class_2540 buf, Object value) {
        int idx = classesMap.getInt(value.getClass());
        if (idx == -1) {
            throw new IllegalStateException("Tried to serialize instance of " + value.getClass() + " as a " + commonClass);
        }
        buf.method_10804(idx);
        ((PacketBufSerializer)serializerMap.get((int)idx)).serializer.accept(buf, value);
    }

    static {
        PacketBufSerializer.register(class_2540::writeBoolean, class_2540::readBoolean, Boolean.class, Boolean.TYPE);
        PacketBufSerializer.register(class_2540::method_10804, class_2540::method_10816, Integer.class, Integer.TYPE);
        PacketBufSerializer.register(class_2540::method_10791, class_2540::method_10792, Long.class, Long.TYPE);
        PacketBufSerializer.register(class_2540::writeFloat, class_2540::readFloat, Float.class, Float.TYPE);
        PacketBufSerializer.register(class_2540::writeDouble, class_2540::readDouble, Double.class, Double.TYPE);
        PacketBufSerializer.register(class_2540::writeByte, class_2540::readByte, Byte.class, Byte.TYPE);
        PacketBufSerializer.register(class_2540::writeShort, class_2540::readShort, Short.class, Short.TYPE);
        PacketBufSerializer.register(class_2540::writeChar, class_2540::readChar, Character.class, Character.TYPE);
        PacketBufSerializer.register(Void.class, (packetByteBuf, unused) -> {}, packetByteBuf -> null);
        PacketBufSerializer.register(String.class, class_2540::method_10814, class_2540::method_19772);
        PacketBufSerializer.register(UUID.class, class_2540::method_10797, class_2540::method_10790);
        PacketBufSerializer.register(Date.class, class_2540::method_10796, class_2540::method_10802);
        PacketBufSerializer.register(class_2540.class, (buf, other) -> {
            buf.method_10804(other.readableBytes());
            buf.writeBytes((ByteBuf)other);
        }, buf -> new class_2540(buf.readBytes(buf.method_10816())));
        PacketBufSerializer.register(class_2338.class, class_2540::method_10807, class_2540::method_10811);
        PacketBufSerializer.register(class_1923.class, class_2540::method_36130, class_2540::method_36133);
        PacketBufSerializer.register(class_1799.class, class_2540::method_10793, class_2540::method_10819);
        PacketBufSerializer.register(class_2960.class, class_2540::method_10812, class_2540::method_10810);
        PacketBufSerializer.register(class_2487.class, class_2540::method_10794, class_2540::method_10798);
        PacketBufSerializer.register(class_3965.class, class_2540::method_17813, class_2540::method_17814);
        PacketBufSerializer.register(BitSet.class, class_2540::method_33557, class_2540::method_33558);
        PacketBufSerializer.register(class_2561.class, class_2540::method_10805, class_2540::method_10808);
        PacketBufSerializer.register(class_2394.class, (buf, particleEffect) -> {
            buf.writeInt(class_2378.field_11141.method_10206((Object)particleEffect.method_10295()));
            particleEffect.method_10294(buf);
        }, buf -> {
            class_2396 particleType = (class_2396)class_2378.field_11141.method_10200(buf.readInt());
            return particleType.method_10298().method_10297(particleType, buf);
        });
        PacketBufSerializer.register(class_243.class, VectorSerializer::write, VectorSerializer::read);
        PacketBufSerializer.register(class_1160.class, VectorSerializer::writef, VectorSerializer::readf);
        PacketBufSerializer.registerCollectionProvider(Collection.class, HashSet::new);
        PacketBufSerializer.registerCollectionProvider(List.class, ArrayList::new);
        PacketBufSerializer.registerCollectionProvider(Map.class, HashMap::new);
    }
}

