/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.itemgroup;

import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.OwoItemExtensions;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.itemgroup.gui.ItemGroupTab;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.impl.item.group.ItemGroupExtensions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import org.jetbrains.annotations.ApiStatus;

public abstract class OwoItemGroup
extends class_1761 {
    public static final BiConsumer<class_1792, class_2371<class_1799>> DEFAULT_STACK_GENERATOR = (item, stacks) -> stacks.add((Object)item.method_7854());
    public final List<ItemGroupTab> tabs = new ArrayList<ItemGroupTab>();
    public final List<ItemGroupButton> buttons = new ArrayList<ItemGroupButton>();
    private int selectedTab = 0;
    private boolean initialized = false;
    private int stackHeight = 4;
    private class_2960 customTexture = null;
    private boolean displayTabNamesAsTitle = true;
    private boolean displaySingleTab = false;

    protected OwoItemGroup(class_2960 id) {
        super(OwoItemGroup.createTabIndex(), String.format("%s.%s", id.method_12836(), id.method_12832()));
    }

    @ApiStatus.Internal
    protected OwoItemGroup(int index, String name) {
        super(index, name);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            this.setup();
        }
        if (this.tabs.size() == 0) {
            this.addTab(Icon.of((class_1935)class_1802.field_8162), "based_placeholder_tab", null);
        }
        this.initialized = true;
    }

    protected void addButton(ItemGroupButton button) {
        this.buttons.add(button);
    }

    protected void addTab(Icon icon, String name, class_6862<class_1792> contentTag, class_2960 texture) {
        this.tabs.add(new ItemGroupTab(icon, name, contentTag, texture));
    }

    protected void addTab(Icon icon, String name, class_6862<class_1792> contentTag) {
        this.addTab(icon, name, contentTag, ItemGroupTab.DEFAULT_TEXTURE);
    }

    protected void setCustomTexture(class_2960 texture) {
        this.customTexture = texture;
    }

    protected void setStackHeight(int height) {
        if (height < 4) {
            throw new IllegalArgumentException("Stack height must not be lower than 4");
        }
        this.stackHeight = height;
    }

    protected void displaySingleTab() {
        this.displaySingleTab = true;
    }

    protected void keepStaticTitle() {
        this.displayTabNamesAsTitle = false;
    }

    protected abstract void setup();

    public void setSelectedTab(int selectedTab) {
        this.selectedTab = selectedTab;
    }

    public ItemGroupTab getSelectedTab() {
        return this.tabs.get(this.selectedTab);
    }

    public int getSelectedTabIndex() {
        return this.selectedTab;
    }

    public class_2960 getCustomTexture() {
        return this.customTexture;
    }

    public int getStackHeight() {
        return this.stackHeight;
    }

    public boolean shouldDisplayTabNamesAsTitle() {
        return this.displayTabNamesAsTitle && this.tabs.size() > 1;
    }

    public boolean shouldDisplaySingleTab() {
        return this.displaySingleTab;
    }

    public List<ItemGroupButton> getButtons() {
        return this.buttons;
    }

    public ItemGroupTab getTab(int index) {
        return index < this.tabs.size() ? this.tabs.get(index) : null;
    }

    public void method_7738(class_2371<class_1799> stacks) {
        if (!this.initialized) {
            throw new IllegalStateException("Owo item group not initialized, was 'initialize()' called?");
        }
        class_2378.field_11142.method_10220().filter(this::includes).forEach(item -> ((OwoItemExtensions)item).getStackGenerator().accept((class_1792)item, stacks));
    }

    protected boolean includes(class_1792 item) {
        if (this.tabs.size() > 1) {
            return this.getSelectedTab().includes(item) || item.method_7859() == this && ((OwoItemExtensions)item).getTab() == this.getSelectedTabIndex();
        }
        return item.method_7859() != null && Objects.equals(item.method_7859().method_7751(), this.method_7751());
    }

    private static int createTabIndex() {
        ((ItemGroupExtensions)class_1761.field_7931).fabric_expandArray();
        return class_1761.field_7921.length - 1;
    }

    public static interface ButtonDefinition {
        public Icon icon();

        public class_2960 texture();

        public String getTranslationKey(String var1);
    }
}

