/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.Symmetry;
import me.pepperbell.continuity.client.resource.ResourceRedirectHandler;
import net.minecraft.class_151;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public final class PropertiesParsingHelper {
    @Nullable
    public static ImmutableSet<class_2960> parseMatchTiles(Properties properties, String propertyKey, class_2960 fileLocation, String packName, boolean nullIfEmpty) {
        String[] matchTileStrs;
        String matchTilesStr = properties.getProperty(propertyKey);
        if (matchTilesStr != null && (matchTileStrs = (matchTilesStr = matchTilesStr.trim()).split(" ")).length != 0) {
            String basePath = FilenameUtils.getPath((String)fileLocation.method_12832());
            ResourceRedirectHandler redirectHandler = ResourceRedirectHandler.get();
            ImmutableSet.Builder setBuilder = ImmutableSet.builder();
            for (int i = 0; i < matchTileStrs.length; ++i) {
                Object path;
                String namespace;
                String[] parts;
                String matchTileStr = matchTileStrs[i];
                if (matchTileStr.isEmpty() || (parts = matchTileStr.split(":", 2)).length == 0) continue;
                if (parts.length > 1) {
                    namespace = parts[0];
                    path = parts[1];
                } else {
                    namespace = fileLocation.method_12836();
                    path = parts[0];
                }
                if (((String)path).endsWith(".png")) {
                    path = ((String)path).substring(0, ((String)path).length() - 4);
                }
                if (((String)path).startsWith("./")) {
                    path = basePath + ((String)path).substring(2);
                } else if (((String)path).startsWith("~/")) {
                    path = "optifine/" + ((String)path).substring(2);
                } else if (((String)path).startsWith("/")) {
                    path = "optifine/" + ((String)path).substring(1);
                } else if (!((String)path).contains("/")) {
                    namespace = null;
                    path = "textures/block/" + (String)path;
                }
                if (((String)path).startsWith("textures/")) {
                    path = ((String)path).substring(9);
                } else if (((String)path).startsWith("optifine/")) {
                    if (redirectHandler == null) continue;
                    path = redirectHandler.getSourceSpritePath((String)path + ".png");
                }
                try {
                    setBuilder.add((Object)new class_2960(namespace, (String)path));
                    continue;
                }
                catch (class_151 e) {
                    ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + matchTileStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packName + "'", (Throwable)e);
                }
            }
            ImmutableSet set = setBuilder.build();
            if (!set.isEmpty() || !nullIfEmpty) {
                return set;
            }
        }
        return null;
    }

    @Nullable
    public static Predicate<class_2680> parseBlockStates(Properties properties, String propertyKey, class_2960 fileLocation, String packName, boolean nullIfEmpty) {
        String[] blockStateStrs;
        String blockStatesStr = properties.getProperty(propertyKey);
        if (blockStatesStr != null && (blockStateStrs = (blockStatesStr = blockStatesStr.trim()).split(" ")).length != 0) {
            ImmutableList.Builder predicateListBuilder = ImmutableList.builder();
            block2: for (int i = 0; i < blockStateStrs.length; ++i) {
                int startIndex;
                class_2960 blockId;
                String[] parts;
                String blockStateStr = blockStateStrs[i];
                if (blockStateStr.isEmpty() || (parts = blockStateStr.split(":")).length == 0) continue;
                try {
                    if (parts.length == 1 || parts[1].contains("=")) {
                        blockId = new class_2960(parts[0]);
                        startIndex = 1;
                    } else {
                        blockId = new class_2960(parts[0], parts[1]);
                        startIndex = 2;
                    }
                }
                catch (class_151 e) {
                    ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packName + "'", (Throwable)e);
                    continue;
                }
                class_2248 block = (class_2248)class_2378.field_11146.method_10223(blockId);
                if (block != class_2246.field_10124) {
                    if (parts.length > startIndex) {
                        ImmutableMap.Builder propertyMapBuilder = ImmutableMap.builder();
                        for (int j = startIndex; j < parts.length; ++j) {
                            String part = parts[j];
                            String[] propertyParts = part.split("=");
                            if (propertyParts.length == 2) {
                                String propertyName = propertyParts[0];
                                class_2769 property = block.method_9595().method_11663(propertyName);
                                if (property != null) {
                                    String propertyValuesStr = propertyParts[1];
                                    String[] propertyValueStrs = propertyValuesStr.split(",");
                                    if (propertyValueStrs.length == 0) continue;
                                    ImmutableList.Builder valuesListBuilder = ImmutableList.builder();
                                    for (String propertyValueStr : propertyValueStrs) {
                                        Optional optional = property.method_11900(propertyValueStr);
                                        if (!optional.isPresent()) {
                                            ContinuityClient.LOGGER.warn("Invalid block property value '" + propertyValueStr + "' for property '" + propertyName + "' for block '" + blockId + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packName + "'");
                                            continue block2;
                                        }
                                        valuesListBuilder.add((Object)((Comparable)optional.get()));
                                    }
                                    ImmutableList valuesList = valuesListBuilder.build();
                                    if (valuesList.isEmpty()) continue;
                                    propertyMapBuilder.put((Object)property, (Object)valuesList);
                                    continue;
                                }
                                ContinuityClient.LOGGER.warn("Invalid block property '" + propertyName + "' for block '" + blockId + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packName + "'");
                                continue block2;
                            }
                            ContinuityClient.LOGGER.warn("Invalid block property definition for block '" + blockId + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packName + "'");
                            continue block2;
                        }
                        ImmutableMap propertyMap = propertyMapBuilder.build();
                        if (!propertyMap.isEmpty()) {
                            predicateListBuilder.add(state -> {
                                if (state.method_26204() == block) {
                                    block0: for (Map.Entry entry : propertyMap.entrySet()) {
                                        Comparable targetValue = state.method_11654((class_2769)entry.getKey());
                                        for (Comparable value : (ImmutableList)entry.getValue()) {
                                            if (targetValue != value) continue;
                                            continue block0;
                                        }
                                        return false;
                                    }
                                    return true;
                                }
                                return false;
                            });
                            continue;
                        }
                    }
                    predicateListBuilder.add(state -> state.method_26204() == block);
                    continue;
                }
                ContinuityClient.LOGGER.warn("Invalid block '" + blockId + "' in '" + propertyKey + "' element '" + blockStateStr + "' at index " + i + " in file '" + fileLocation + "' in pack '" + packName + "'");
            }
            ImmutableList predicateList = predicateListBuilder.build();
            if (!predicateList.isEmpty()) {
                int amount = predicateList.size();
                return state -> {
                    for (int i = 0; i < amount; ++i) {
                        if (!((Predicate)predicateList.get(i)).test(state)) continue;
                        return true;
                    }
                    return false;
                };
            }
            if (!nullIfEmpty) {
                return state -> false;
            }
        }
        return null;
    }

    @Nullable
    public static Symmetry parseSymmetry(Properties properties, String propertyKey, class_2960 fileLocation, String packName) {
        String symmetryStr = properties.getProperty(propertyKey);
        if (symmetryStr != null) {
            symmetryStr = symmetryStr.trim();
            try {
                return Symmetry.valueOf(symmetryStr.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                ContinuityClient.LOGGER.warn("Invalid '" + propertyKey + "' value '" + symmetryStr + "' in file '" + fileLocation + "' in pack '" + packName + "'");
            }
        }
        return null;
    }
}

