/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.api.client.QuadProcessorFactory;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.BaseProcessingPredicate;
import me.pepperbell.continuity.client.processor.ConnectingQuadProcessor;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.DirectionMaps;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.simple.CTMSpriteProvider;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.properties.CompactConnectingCTMProperties;
import me.pepperbell.continuity.client.util.MathUtil;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import org.apache.commons.lang3.ArrayUtils;

public class CompactCTMQuadProcessor
extends ConnectingQuadProcessor {
    protected static int[][] QUAD_INDEX_MAP;
    protected boolean innerSeams;
    protected class_1058[] replacementSprites;

    public CompactCTMQuadProcessor(class_1058[] sprites, ProcessingPredicate processingPredicate, ConnectionPredicate connectionPredicate, boolean innerSeams, class_1058[] replacementSprites) {
        super(sprites, processingPredicate, connectionPredicate);
        this.innerSeams = innerSeams;
        this.replacementSprites = replacementSprites;
    }

    @Override
    public QuadProcessor.ProcessingResult processQuadInner(MutableQuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, int pass, int processorIndex, QuadProcessor.ProcessingContext context) {
        int spriteIndexB;
        int spriteIndexA;
        boolean firstHalf;
        boolean firstSplit;
        boolean vSplit;
        int ctmIndex;
        class_1058 replacementSprite;
        int orientation = QuadUtil.getTextureOrientation((QuadView)quad);
        class_2350[] directions = DirectionMaps.getMap(quad.lightFace())[orientation];
        class_2338.class_2339 mutablePos = context.getData(ProcessingDataKeys.MUTABLE_POS_KEY);
        int connections = CTMSpriteProvider.getConnections(this.connectionPredicate, this.innerSeams, directions, mutablePos, blockView, state, pos, quad.lightFace(), sprite);
        if (this.replacementSprites != null && (replacementSprite = this.replacementSprites[ctmIndex = CTMSpriteProvider.SPRITE_INDEX_MAP[connections]]) != null) {
            if (!TextureUtil.isMissingSprite(replacementSprite)) {
                QuadUtil.interpolate(quad, sprite, replacementSprite);
            }
            return QuadProcessor.ProcessingResult.STOP;
        }
        float un0 = class_3532.method_37960((float)quad.spriteU(0, 0), (float)sprite.method_4594(), (float)sprite.method_4577()) - 0.5f;
        float vn0 = class_3532.method_37960((float)quad.spriteV(0, 0), (float)sprite.method_4593(), (float)sprite.method_4575()) - 0.5f;
        float un1 = class_3532.method_37960((float)quad.spriteU(1, 0), (float)sprite.method_4594(), (float)sprite.method_4577()) - 0.5f;
        float vn1 = class_3532.method_37960((float)quad.spriteV(1, 0), (float)sprite.method_4593(), (float)sprite.method_4575()) - 0.5f;
        float un2 = class_3532.method_37960((float)quad.spriteU(2, 0), (float)sprite.method_4594(), (float)sprite.method_4577()) - 0.5f;
        float vn2 = class_3532.method_37960((float)quad.spriteV(2, 0), (float)sprite.method_4593(), (float)sprite.method_4575()) - 0.5f;
        float un3 = class_3532.method_37960((float)quad.spriteU(3, 0), (float)sprite.method_4594(), (float)sprite.method_4577()) - 0.5f;
        float vn3 = class_3532.method_37960((float)quad.spriteV(3, 0), (float)sprite.method_4593(), (float)sprite.method_4575()) - 0.5f;
        int uSignum0 = (int)Math.signum(un0);
        int vSignum0 = (int)Math.signum(vn0);
        int uSignum1 = (int)Math.signum(un1);
        int vSignum1 = (int)Math.signum(vn1);
        int uSignum2 = (int)Math.signum(un2);
        int vSignum2 = (int)Math.signum(vn2);
        int uSignum3 = (int)Math.signum(un3);
        int vSignum3 = (int)Math.signum(vn3);
        boolean uSplit01 = CompactCTMQuadProcessor.shouldSplitUV(uSignum0, uSignum1);
        boolean vSplit01 = CompactCTMQuadProcessor.shouldSplitUV(vSignum0, vSignum1);
        boolean uSplit12 = CompactCTMQuadProcessor.shouldSplitUV(uSignum1, uSignum2);
        boolean vSplit12 = CompactCTMQuadProcessor.shouldSplitUV(vSignum1, vSignum2);
        boolean uSplit23 = CompactCTMQuadProcessor.shouldSplitUV(uSignum2, uSignum3);
        boolean vSplit23 = CompactCTMQuadProcessor.shouldSplitUV(vSignum2, vSignum3);
        boolean uSplit30 = CompactCTMQuadProcessor.shouldSplitUV(uSignum3, uSignum0);
        boolean vSplit30 = CompactCTMQuadProcessor.shouldSplitUV(vSignum3, vSignum0);
        if (uSplit01 & vSplit01 || uSplit12 & vSplit12 || uSplit23 & vSplit23 || uSplit30 & vSplit30) {
            return QuadProcessor.ProcessingResult.CONTINUE;
        }
        if (uSplit01 & uSplit12 || uSplit12 & uSplit23 || uSplit23 & uSplit30 || uSplit30 & uSplit01) {
            return QuadProcessor.ProcessingResult.CONTINUE;
        }
        if (vSplit01 & vSplit12 || vSplit12 & vSplit23 || vSplit23 & vSplit30 || vSplit30 & vSplit01) {
            return QuadProcessor.ProcessingResult.CONTINUE;
        }
        boolean uSplit = (uSplit01 ? 1 : 0) + (uSplit12 ? 1 : 0) + (uSplit23 ? 1 : 0) + (uSplit30 ? 1 : 0) == 2;
        boolean bl = vSplit = (vSplit01 ? 1 : 0) + (vSplit12 ? 1 : 0) + (vSplit23 ? 1 : 0) + (vSplit30 ? 1 : 0) == 2;
        if (!uSplit && !vSplit) {
            return QuadProcessor.ProcessingResult.ABORT_AND_RENDER_QUAD;
        }
        int[] quadIndices = QUAD_INDEX_MAP[orientation];
        if (uSplit && vSplit) {
            boolean split30;
            int spriteIndex0 = this.getSpriteIndex(quadIndices[0], connections);
            int spriteIndex1 = this.getSpriteIndex(quadIndices[1], connections);
            int spriteIndex2 = this.getSpriteIndex(quadIndices[2], connections);
            int spriteIndex3 = this.getSpriteIndex(quadIndices[3], connections);
            boolean split01 = spriteIndex0 != spriteIndex1;
            boolean split12 = spriteIndex1 != spriteIndex2;
            boolean split23 = spriteIndex2 != spriteIndex3;
            boolean bl2 = split30 = spriteIndex3 != spriteIndex0;
            if (!(split01 | split12 | split23 | split30)) {
                this.tryInterpolate(quad, sprite, spriteIndex0);
                return QuadProcessor.ProcessingResult.ABORT_AND_RENDER_QUAD;
            }
            VertexContainer vertexContainer = context.getData(ProcessingDataKeys.VERTEX_CONTAINER_KEY);
            vertexContainer.fillBaseVertices((QuadView)quad);
            QuadEmitter extraQuadEmitter = context.getExtraQuadEmitter();
            RenderMaterial material = quad.material();
            if (split01 & split12 & split23 & split30) {
                float delta4;
                float delta30;
                float delta12;
                float delta23;
                float delta01;
                if (uSplit01) {
                    delta01 = class_3532.method_37960((float)0.0f, (float)un0, (float)un1);
                    delta23 = class_3532.method_37960((float)0.0f, (float)un2, (float)un3);
                    delta12 = class_3532.method_37960((float)0.0f, (float)vn1, (float)vn2);
                    delta30 = class_3532.method_37960((float)0.0f, (float)vn3, (float)vn0);
                    delta4 = class_3532.method_37960((float)0.0f, (float)class_3532.method_16439((float)delta01, (float)vn0, (float)vn1), (float)class_3532.method_16439((float)delta23, (float)vn2, (float)vn3));
                } else {
                    delta01 = class_3532.method_37960((float)0.0f, (float)vn0, (float)vn1);
                    delta23 = class_3532.method_37960((float)0.0f, (float)vn2, (float)vn3);
                    delta12 = class_3532.method_37960((float)0.0f, (float)un1, (float)un2);
                    delta30 = class_3532.method_37960((float)0.0f, (float)un3, (float)un0);
                    delta4 = class_3532.method_37960((float)0.0f, (float)class_3532.method_16439((float)delta01, (float)un0, (float)un1), (float)class_3532.method_16439((float)delta23, (float)un2, (float)un3));
                }
                vertexContainer.vertex01.setLerped(delta01, vertexContainer.vertex0, vertexContainer.vertex1);
                vertexContainer.vertex12.setLerped(delta12, vertexContainer.vertex1, vertexContainer.vertex2);
                vertexContainer.vertex23.setLerped(delta23, vertexContainer.vertex2, vertexContainer.vertex3);
                vertexContainer.vertex30.setLerped(delta30, vertexContainer.vertex3, vertexContainer.vertex0);
                vertexContainer.vertex4.setLerped(delta4, vertexContainer.vertex01, vertexContainer.vertex23);
                this.splitQuadrant((QuadView)quad, sprite, material, vertexContainer, 0, extraQuadEmitter, spriteIndex0);
                this.splitQuadrant((QuadView)quad, sprite, material, vertexContainer, 1, extraQuadEmitter, spriteIndex1);
                this.splitQuadrant((QuadView)quad, sprite, material, vertexContainer, 2, extraQuadEmitter, spriteIndex2);
                this.splitQuadrant((QuadView)quad, sprite, material, vertexContainer, 3, extraQuadEmitter, spriteIndex3);
            } else {
                if (!(split01 | split12)) {
                    split12 = true;
                } else if (!(split12 | split23)) {
                    split23 = true;
                } else if (!(split23 | split30)) {
                    split30 = true;
                } else if (!(split30 | split01)) {
                    split01 = true;
                }
                int splits = (split01 ? 1 : 0) + (split12 ? 1 : 0) + (split23 ? 1 : 0) + (split30 ? 1 : 0);
                if (splits == 2) {
                    if (split01) {
                        float delta23;
                        float delta01;
                        if (uSplit01) {
                            delta01 = class_3532.method_37960((float)0.0f, (float)un0, (float)un1);
                            delta23 = class_3532.method_37960((float)0.0f, (float)un2, (float)un3);
                        } else {
                            delta01 = class_3532.method_37960((float)0.0f, (float)vn0, (float)vn1);
                            delta23 = class_3532.method_37960((float)0.0f, (float)vn2, (float)vn3);
                        }
                        vertexContainer.vertex01.setLerped(delta01, vertexContainer.vertex0, vertexContainer.vertex1);
                        vertexContainer.vertex23.setLerped(delta23, vertexContainer.vertex2, vertexContainer.vertex3);
                        this.splitHalf((QuadView)quad, sprite, material, vertexContainer, 1, extraQuadEmitter, spriteIndex1);
                        this.splitHalf((QuadView)quad, sprite, material, vertexContainer, 3, extraQuadEmitter, spriteIndex3);
                    } else {
                        float delta30;
                        float delta12;
                        if (uSplit01) {
                            delta12 = class_3532.method_37960((float)0.0f, (float)vn1, (float)vn2);
                            delta30 = class_3532.method_37960((float)0.0f, (float)vn3, (float)vn0);
                        } else {
                            delta12 = class_3532.method_37960((float)0.0f, (float)un1, (float)un2);
                            delta30 = class_3532.method_37960((float)0.0f, (float)un3, (float)un0);
                        }
                        vertexContainer.vertex12.setLerped(delta12, vertexContainer.vertex1, vertexContainer.vertex2);
                        vertexContainer.vertex30.setLerped(delta30, vertexContainer.vertex3, vertexContainer.vertex0);
                        this.splitHalf((QuadView)quad, sprite, material, vertexContainer, 0, extraQuadEmitter, spriteIndex0);
                        this.splitHalf((QuadView)quad, sprite, material, vertexContainer, 2, extraQuadEmitter, spriteIndex2);
                    }
                } else if (!split01) {
                    float delta4;
                    float delta30;
                    float delta12;
                    float delta23;
                    if (uSplit01) {
                        delta23 = class_3532.method_37960((float)0.0f, (float)un2, (float)un3);
                        delta12 = class_3532.method_37960((float)0.0f, (float)vn1, (float)vn2);
                        delta30 = class_3532.method_37960((float)0.0f, (float)vn3, (float)vn0);
                        delta4 = class_3532.method_37960((float)0.0f, (float)class_3532.method_16439((float)delta12, (float)un1, (float)un2), (float)class_3532.method_16439((float)delta30, (float)un3, (float)un0));
                    } else {
                        delta23 = class_3532.method_37960((float)0.0f, (float)vn2, (float)vn3);
                        delta12 = class_3532.method_37960((float)0.0f, (float)un1, (float)un2);
                        delta30 = class_3532.method_37960((float)0.0f, (float)un3, (float)un0);
                        delta4 = class_3532.method_37960((float)0.0f, (float)class_3532.method_16439((float)delta12, (float)vn1, (float)vn2), (float)class_3532.method_16439((float)delta30, (float)vn3, (float)vn0));
                    }
                    vertexContainer.vertex23.setLerped(delta23, vertexContainer.vertex2, vertexContainer.vertex3);
                    vertexContainer.vertex12.setLerped(delta12, vertexContainer.vertex1, vertexContainer.vertex2);
                    vertexContainer.vertex30.setLerped(delta30, vertexContainer.vertex3, vertexContainer.vertex0);
                    vertexContainer.vertex4.setLerped(delta4, vertexContainer.vertex12, vertexContainer.vertex30);
                    this.splitHalf((QuadView)quad, sprite, material, vertexContainer, 0, extraQuadEmitter, spriteIndex0);
                    this.splitQuadrant((QuadView)quad, sprite, material, vertexContainer, 2, extraQuadEmitter, spriteIndex2);
                    this.splitQuadrant((QuadView)quad, sprite, material, vertexContainer, 3, extraQuadEmitter, spriteIndex3);
                } else if (!split12) {
                    float delta4;
                    float delta30;
                    float delta23;
                    float delta01;
                    if (uSplit01) {
                        delta01 = class_3532.method_37960((float)0.0f, (float)un0, (float)un1);
                        delta23 = class_3532.method_37960((float)0.0f, (float)un2, (float)un3);
                        delta30 = class_3532.method_37960((float)0.0f, (float)vn3, (float)vn0);
                        delta4 = class_3532.method_37960((float)0.0f, (float)class_3532.method_16439((float)delta01, (float)vn0, (float)vn1), (float)class_3532.method_16439((float)delta23, (float)vn2, (float)vn3));
                    } else {
                        delta01 = class_3532.method_37960((float)0.0f, (float)vn0, (float)vn1);
                        delta23 = class_3532.method_37960((float)0.0f, (float)vn2, (float)vn3);
                        delta30 = class_3532.method_37960((float)0.0f, (float)un3, (float)un0);
                        delta4 = class_3532.method_37960((float)0.0f, (float)class_3532.method_16439((float)delta01, (float)un0, (float)un1), (float)class_3532.method_16439((float)delta23, (float)un2, (float)un3));
                    }
                    vertexContainer.vertex01.setLerped(delta01, vertexContainer.vertex0, vertexContainer.vertex1);
                    vertexContainer.vertex23.setLerped(delta23, vertexContainer.vertex2, vertexContainer.vertex3);
                    vertexContainer.vertex30.setLerped(delta30, vertexContainer.vertex3, vertexContainer.vertex0);
                    vertexContainer.vertex4.setLerped(delta4, vertexContainer.vertex01, vertexContainer.vertex23);
                    this.splitQuadrant((QuadView)quad, sprite, material, vertexContainer, 0, extraQuadEmitter, spriteIndex0);
                    this.splitHalf((QuadView)quad, sprite, material, vertexContainer, 1, extraQuadEmitter, spriteIndex1);
                    this.splitQuadrant((QuadView)quad, sprite, material, vertexContainer, 3, extraQuadEmitter, spriteIndex3);
                } else if (!split23) {
                    float delta4;
                    float delta30;
                    float delta12;
                    float delta01;
                    if (uSplit01) {
                        delta01 = class_3532.method_37960((float)0.0f, (float)un0, (float)un1);
                        delta12 = class_3532.method_37960((float)0.0f, (float)vn1, (float)vn2);
                        delta30 = class_3532.method_37960((float)0.0f, (float)vn3, (float)vn0);
                        delta4 = class_3532.method_37960((float)0.0f, (float)class_3532.method_16439((float)delta12, (float)un1, (float)un2), (float)class_3532.method_16439((float)delta30, (float)un3, (float)un0));
                    } else {
                        delta01 = class_3532.method_37960((float)0.0f, (float)vn0, (float)vn1);
                        delta12 = class_3532.method_37960((float)0.0f, (float)un1, (float)un2);
                        delta30 = class_3532.method_37960((float)0.0f, (float)un3, (float)un0);
                        delta4 = class_3532.method_37960((float)0.0f, (float)class_3532.method_16439((float)delta12, (float)vn1, (float)vn2), (float)class_3532.method_16439((float)delta30, (float)vn3, (float)vn0));
                    }
                    vertexContainer.vertex01.setLerped(delta01, vertexContainer.vertex0, vertexContainer.vertex1);
                    vertexContainer.vertex12.setLerped(delta12, vertexContainer.vertex1, vertexContainer.vertex2);
                    vertexContainer.vertex30.setLerped(delta30, vertexContainer.vertex3, vertexContainer.vertex0);
                    vertexContainer.vertex4.setLerped(delta4, vertexContainer.vertex12, vertexContainer.vertex30);
                    this.splitQuadrant((QuadView)quad, sprite, material, vertexContainer, 0, extraQuadEmitter, spriteIndex0);
                    this.splitQuadrant((QuadView)quad, sprite, material, vertexContainer, 1, extraQuadEmitter, spriteIndex1);
                    this.splitHalf((QuadView)quad, sprite, material, vertexContainer, 2, extraQuadEmitter, spriteIndex2);
                } else {
                    float delta4;
                    float delta12;
                    float delta23;
                    float delta01;
                    if (uSplit01) {
                        delta01 = class_3532.method_37960((float)0.0f, (float)un0, (float)un1);
                        delta23 = class_3532.method_37960((float)0.0f, (float)un2, (float)un3);
                        delta12 = class_3532.method_37960((float)0.0f, (float)vn1, (float)vn2);
                        delta4 = class_3532.method_37960((float)0.0f, (float)class_3532.method_16439((float)delta01, (float)vn0, (float)vn1), (float)class_3532.method_16439((float)delta23, (float)vn2, (float)vn3));
                    } else {
                        delta01 = class_3532.method_37960((float)0.0f, (float)vn0, (float)vn1);
                        delta23 = class_3532.method_37960((float)0.0f, (float)vn2, (float)vn3);
                        delta12 = class_3532.method_37960((float)0.0f, (float)un1, (float)un2);
                        delta4 = class_3532.method_37960((float)0.0f, (float)class_3532.method_16439((float)delta01, (float)un0, (float)un1), (float)class_3532.method_16439((float)delta23, (float)un2, (float)un3));
                    }
                    vertexContainer.vertex01.setLerped(delta01, vertexContainer.vertex0, vertexContainer.vertex1);
                    vertexContainer.vertex12.setLerped(delta12, vertexContainer.vertex1, vertexContainer.vertex2);
                    vertexContainer.vertex23.setLerped(delta23, vertexContainer.vertex2, vertexContainer.vertex3);
                    vertexContainer.vertex4.setLerped(delta4, vertexContainer.vertex01, vertexContainer.vertex23);
                    this.splitHalf((QuadView)quad, sprite, material, vertexContainer, 3, extraQuadEmitter, spriteIndex3);
                    this.splitQuadrant((QuadView)quad, sprite, material, vertexContainer, 1, extraQuadEmitter, spriteIndex1);
                    this.splitQuadrant((QuadView)quad, sprite, material, vertexContainer, 2, extraQuadEmitter, spriteIndex2);
                }
            }
            context.markHasExtraQuads();
            return QuadProcessor.ProcessingResult.ABORT_AND_CANCEL_QUAD;
        }
        if (uSplit) {
            firstSplit = uSplit01;
            boolean bl3 = firstHalf = vSignum0 + vSignum1 + vSignum2 + vSignum3 <= 0;
            if (orientation == 2 || orientation == 3 || orientation == 5 || orientation == 6) {
                firstHalf = !firstHalf;
            }
        } else {
            firstSplit = vSplit01;
            boolean bl4 = firstHalf = uSignum0 + uSignum1 + uSignum2 + uSignum3 <= 0;
            if (orientation == 1 || orientation == 2 || orientation == 6 || orientation == 7) {
                boolean bl5 = firstHalf = !firstHalf;
            }
        }
        if (firstHalf) {
            spriteIndexA = this.getSpriteIndex(quadIndices[0], connections);
            spriteIndexB = this.getSpriteIndex(quadIndices[firstSplit ? 1 : 3], connections);
        } else {
            spriteIndexA = this.getSpriteIndex(quadIndices[firstSplit ? 3 : 1], connections);
            spriteIndexB = this.getSpriteIndex(quadIndices[2], connections);
        }
        if (spriteIndexA == spriteIndexB) {
            this.tryInterpolate(quad, sprite, spriteIndexA);
            return QuadProcessor.ProcessingResult.ABORT_AND_RENDER_QUAD;
        }
        VertexContainer vertexContainer = context.getData(ProcessingDataKeys.VERTEX_CONTAINER_KEY);
        vertexContainer.fillBaseVertices((QuadView)quad);
        QuadEmitter extraQuadEmitter = context.getExtraQuadEmitter();
        RenderMaterial material = quad.material();
        if (firstSplit) {
            float delta23;
            float delta01;
            if (uSplit) {
                delta01 = class_3532.method_37960((float)0.0f, (float)un0, (float)un1);
                delta23 = class_3532.method_37960((float)0.0f, (float)un2, (float)un3);
            } else {
                delta01 = class_3532.method_37960((float)0.0f, (float)vn0, (float)vn1);
                delta23 = class_3532.method_37960((float)0.0f, (float)vn2, (float)vn3);
            }
            vertexContainer.vertex01.setLerped(delta01, vertexContainer.vertex0, vertexContainer.vertex1);
            vertexContainer.vertex23.setLerped(delta23, vertexContainer.vertex2, vertexContainer.vertex3);
            this.splitHalf((QuadView)quad, sprite, material, vertexContainer, 3, extraQuadEmitter, spriteIndexA);
            this.splitHalf((QuadView)quad, sprite, material, vertexContainer, 1, extraQuadEmitter, spriteIndexB);
        } else {
            float delta30;
            float delta12;
            if (uSplit) {
                delta12 = class_3532.method_37960((float)0.0f, (float)un1, (float)un2);
                delta30 = class_3532.method_37960((float)0.0f, (float)un3, (float)un0);
            } else {
                delta12 = class_3532.method_37960((float)0.0f, (float)vn1, (float)vn2);
                delta30 = class_3532.method_37960((float)0.0f, (float)vn3, (float)vn0);
            }
            vertexContainer.vertex12.setLerped(delta12, vertexContainer.vertex1, vertexContainer.vertex2);
            vertexContainer.vertex30.setLerped(delta30, vertexContainer.vertex3, vertexContainer.vertex0);
            this.splitHalf((QuadView)quad, sprite, material, vertexContainer, 0, extraQuadEmitter, spriteIndexA);
            this.splitHalf((QuadView)quad, sprite, material, vertexContainer, 2, extraQuadEmitter, spriteIndexB);
        }
        context.markHasExtraQuads();
        return QuadProcessor.ProcessingResult.ABORT_AND_CANCEL_QUAD;
    }

    protected static boolean shouldSplitUV(int signumA, int signumB) {
        return (signumA ^ signumB) == -2;
    }

    protected int getSpriteIndex(int quadIndex, int connections) {
        boolean connected2;
        int index1 = quadIndex;
        int index2 = (quadIndex + 3) % 4;
        boolean connected1 = (connections >> index1 * 2 & 1) == 1;
        boolean bl = connected2 = (connections >> index2 * 2 & 1) == 1;
        if (connected1 && connected2) {
            if ((connections >> index2 * 2 + 1 & 1) == 1) {
                return 1;
            }
            return 4;
        }
        if (connected1) {
            return 3 - quadIndex % 2;
        }
        if (connected2) {
            return 2 + quadIndex % 2;
        }
        return 0;
    }

    protected void tryInterpolate(MutableQuadView quad, class_1058 oldSprite, int spriteIndex) {
        class_1058 newSprite = this.sprites[spriteIndex];
        if (!TextureUtil.isMissingSprite(newSprite)) {
            QuadUtil.interpolate(quad, oldSprite, newSprite);
        }
    }

    protected void splitHalf(QuadView quad, class_1058 sprite, RenderMaterial material, VertexContainer vertexContainer, int id, QuadEmitter quadEmitter, int spriteIndex) {
        quad.copyTo((MutableQuadView)quadEmitter);
        quadEmitter.material(material);
        vertexContainer.lerpedVertices[(id + 1) % 4].writeToQuad((MutableQuadView)quadEmitter, (id + 2) % 4);
        int id3 = (id + 3) % 4;
        vertexContainer.lerpedVertices[id3].writeToQuad((MutableQuadView)quadEmitter, id3);
        this.tryInterpolate((MutableQuadView)quadEmitter, sprite, spriteIndex);
        quadEmitter.emit();
    }

    protected void splitQuadrant(QuadView quad, class_1058 sprite, RenderMaterial material, VertexContainer vertexContainer, int id, QuadEmitter quadEmitter, int spriteIndex) {
        quad.copyTo((MutableQuadView)quadEmitter);
        quadEmitter.material(material);
        vertexContainer.lerpedVertices[id].writeToQuad((MutableQuadView)quadEmitter, (id + 1) % 4);
        vertexContainer.vertex4.writeToQuad((MutableQuadView)quadEmitter, (id + 2) % 4);
        int id3 = (id + 3) % 4;
        vertexContainer.lerpedVertices[id3].writeToQuad((MutableQuadView)quadEmitter, id3);
        this.tryInterpolate((MutableQuadView)quadEmitter, sprite, spriteIndex);
        quadEmitter.emit();
    }

    static {
        int[][] map = QUAD_INDEX_MAP = (int[][])new int[8][];
        map[0] = new int[]{0, 1, 2, 3};
        map[1] = (int[])map[0].clone();
        ArrayUtils.shift((int[])map[1], (int)1);
        map[2] = (int[])map[1].clone();
        ArrayUtils.shift((int[])map[2], (int)1);
        map[3] = (int[])map[2].clone();
        ArrayUtils.shift((int[])map[3], (int)1);
        map[4] = (int[])map[3].clone();
        ArrayUtils.reverse((int[])map[4]);
        map[5] = (int[])map[4].clone();
        ArrayUtils.shift((int[])map[5], (int)1);
        map[6] = (int[])map[5].clone();
        ArrayUtils.shift((int[])map[6], (int)1);
        map[7] = (int[])map[6].clone();
        ArrayUtils.shift((int[])map[7], (int)1);
    }

    public static class VertexContainer {
        public final Vertex vertex0 = new Vertex();
        public final Vertex vertex1 = new Vertex();
        public final Vertex vertex2 = new Vertex();
        public final Vertex vertex3 = new Vertex();
        public final Vertex vertex01 = new Vertex();
        public final Vertex vertex12 = new Vertex();
        public final Vertex vertex23 = new Vertex();
        public final Vertex vertex30 = new Vertex();
        public final Vertex vertex4 = new Vertex();
        public final Vertex[] lerpedVertices = new Vertex[]{this.vertex01, this.vertex12, this.vertex23, this.vertex30};

        public void fillBaseVertices(QuadView quad) {
            this.vertex0.readFromQuad(quad, 0);
            this.vertex1.readFromQuad(quad, 1);
            this.vertex2.readFromQuad(quad, 2);
            this.vertex3.readFromQuad(quad, 3);
        }
    }

    public static class Vertex {
        public float x;
        public float y;
        public float z;
        public int color;
        public int light;
        public float u;
        public float v;
        public boolean hasNormal;
        public float normalX;
        public float normalY;
        public float normalZ;

        public void readFromQuad(QuadView quad, int vertexIndex) {
            this.x = quad.x(vertexIndex);
            this.y = quad.y(vertexIndex);
            this.z = quad.z(vertexIndex);
            this.color = quad.spriteColor(vertexIndex, 0);
            this.light = quad.lightmap(vertexIndex);
            this.u = quad.spriteU(vertexIndex, 0);
            this.v = quad.spriteV(vertexIndex, 0);
            this.hasNormal = quad.hasNormal(vertexIndex);
            if (this.hasNormal) {
                this.normalX = quad.normalX(vertexIndex);
                this.normalY = quad.normalY(vertexIndex);
                this.normalZ = quad.normalZ(vertexIndex);
            }
        }

        public void writeToQuad(MutableQuadView quad, int vertexIndex) {
            quad.pos(vertexIndex, this.x, this.y, this.z);
            quad.spriteColor(vertexIndex, 0, this.color);
            quad.lightmap(vertexIndex, this.light);
            quad.sprite(vertexIndex, 0, this.u, this.v);
            if (this.hasNormal) {
                quad.normal(vertexIndex, this.normalX, this.normalY, this.normalZ);
            }
        }

        public void set(Vertex other) {
            this.x = other.x;
            this.y = other.y;
            this.z = other.z;
            this.color = other.color;
            this.light = other.light;
            this.u = other.u;
            this.v = other.v;
            this.hasNormal = other.hasNormal;
            if (this.hasNormal) {
                this.normalX = other.normalX;
                this.normalY = other.normalY;
                this.normalZ = other.normalZ;
            }
        }

        public void setLerped(float delta, Vertex vertexA, Vertex vertexB) {
            this.x = class_3532.method_16439((float)delta, (float)vertexA.x, (float)vertexB.x);
            this.y = class_3532.method_16439((float)delta, (float)vertexA.y, (float)vertexB.y);
            this.z = class_3532.method_16439((float)delta, (float)vertexA.z, (float)vertexB.z);
            this.color = MathUtil.lerpColor(delta, vertexA.color, vertexB.color);
            this.light = MathUtil.lerpLight(delta, vertexA.light, vertexB.light);
            this.u = class_3532.method_16439((float)delta, (float)vertexA.u, (float)vertexB.u);
            this.v = class_3532.method_16439((float)delta, (float)vertexA.v, (float)vertexB.v);
            if (vertexA.hasNormal && vertexB.hasNormal) {
                this.normalX = class_3532.method_16439((float)delta, (float)vertexA.normalX, (float)vertexB.normalX);
                this.normalY = class_3532.method_16439((float)delta, (float)vertexA.normalY, (float)vertexB.normalY);
                this.normalZ = class_3532.method_16439((float)delta, (float)vertexA.normalZ, (float)vertexB.normalZ);
                float scale = 1.0f / (float)Math.sqrt(this.normalX * this.normalX + this.normalY * this.normalY + this.normalZ * this.normalZ);
                this.normalX *= scale;
                this.normalY *= scale;
                this.normalZ *= scale;
            }
        }
    }

    public static class Factory
    implements QuadProcessorFactory<CompactConnectingCTMProperties> {
        @Override
        public QuadProcessor createProcessor(CompactConnectingCTMProperties properties, Function<class_4730, class_1058> textureGetter) {
            int i;
            int provided;
            int textureAmount = this.getTextureAmount(properties);
            List<class_4730> spriteIds = properties.getSpriteIds();
            int max = provided = spriteIds.size();
            class_1058[] replacementSprites = null;
            Int2IntMap replacementMap = properties.getTileReplacementMap();
            if (replacementMap != null) {
                ObjectIterator entryIterator;
                int replacementTextureAmount = this.getReplacementTextureAmount(properties);
                replacementSprites = new class_1058[replacementTextureAmount];
                ObjectSet entrySet = replacementMap.int2IntEntrySet();
                if (entrySet instanceof Int2IntMap.FastEntrySet) {
                    Int2IntMap.FastEntrySet fastEntrySet = (Int2IntMap.FastEntrySet)entrySet;
                    entryIterator = fastEntrySet.fastIterator();
                } else {
                    entryIterator = entrySet.iterator();
                }
                while (entryIterator.hasNext()) {
                    Int2IntMap.Entry entry = (Int2IntMap.Entry)entryIterator.next();
                    int key = entry.getIntKey();
                    if (key < replacementTextureAmount) {
                        int value = entry.getIntValue();
                        if (value < provided) {
                            replacementSprites[key] = textureGetter.apply(spriteIds.get(value));
                            continue;
                        }
                        ContinuityClient.LOGGER.warn("Cannot replace tile " + key + " with tile " + value + " as only " + provided + " tiles were provided in file '" + properties.getId() + "' in pack '" + properties.getPackName() + "'");
                        continue;
                    }
                    ContinuityClient.LOGGER.warn("Cannot replace tile " + key + " as method '" + properties.getMethod() + "' only supports " + replacementTextureAmount + " replacement tiles in file '" + properties.getId() + "' in pack '" + properties.getPackName() + "'");
                }
            }
            if (provided > textureAmount) {
                if (replacementSprites == null) {
                    ContinuityClient.LOGGER.warn("Method '" + properties.getMethod() + "' requires " + textureAmount + " tiles but " + provided + " were provided in file '" + properties.getId() + "' in pack '" + properties.getPackName() + "'");
                }
                max = textureAmount;
            }
            class_1058[] sprites = new class_1058[textureAmount];
            class_1058 missingSprite = textureGetter.apply(TextureUtil.MISSING_SPRITE_ID);
            boolean supportsNullSprites = this.supportsNullSprites(properties);
            for (i = 0; i < max; ++i) {
                class_4730 spriteId = spriteIds.get(i);
                class_1058 sprite = spriteId.equals((Object)BaseCTMProperties.SPECIAL_SKIP_SPRITE_ID) ? missingSprite : (spriteId.equals((Object)BaseCTMProperties.SPECIAL_DEFAULT_SPRITE_ID) ? (supportsNullSprites ? null : missingSprite) : textureGetter.apply(spriteId));
                sprites[i] = sprite;
            }
            if (provided < textureAmount) {
                ContinuityClient.LOGGER.error("Method '" + properties.getMethod() + "' requires at least " + textureAmount + " tiles but only " + provided + " were provided in file '" + properties.getId() + "' in pack '" + properties.getPackName() + "'");
                for (i = provided; i < textureAmount; ++i) {
                    sprites[i] = missingSprite;
                }
            }
            return this.createProcessor(properties, sprites, replacementSprites);
        }

        public QuadProcessor createProcessor(CompactConnectingCTMProperties properties, class_1058[] sprites, class_1058[] replacementSprites) {
            return new CompactCTMQuadProcessor(sprites, BaseProcessingPredicate.fromProperties(properties), properties.getConnectionPredicate(), properties.getInnerSeams(), replacementSprites);
        }

        public int getTextureAmount(CompactConnectingCTMProperties properties) {
            return 5;
        }

        public int getReplacementTextureAmount(CompactConnectingCTMProperties properties) {
            return 47;
        }

        public boolean supportsNullSprites(CompactConnectingCTMProperties properties) {
            return false;
        }
    }
}

