/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.model.CTMBakedModel;
import me.pepperbell.continuity.client.model.WrappingUnbakedModel;
import me.pepperbell.continuity.client.resource.CTMLoadingContainer;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

public class CTMUnbakedModel
extends WrappingUnbakedModel {
    private final List<CTMLoadingContainer<?>> containerList;
    @Nullable
    private final List<CTMLoadingContainer<?>> multipassContainerList;

    public CTMUnbakedModel(class_1100 wrapped, List<CTMLoadingContainer<?>> containerList, @Nullable List<CTMLoadingContainer<?>> multipassContainerList) {
        super(wrapped);
        this.containerList = containerList;
        this.multipassContainerList = multipassContainerList;
    }

    public Set<class_4730> getTextureDependencies(Function<class_2960, class_1100> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
        ObjectOpenHashSet dependencies = new ObjectOpenHashSet(this.wrapped.method_4754(unbakedModelGetter, unresolvedTextureReferences));
        for (CTMLoadingContainer<?> container : this.containerList) {
            dependencies.addAll(container.getProperties().getTextureDependencies());
        }
        if (this.multipassContainerList != null) {
            for (CTMLoadingContainer<?> container : this.multipassContainerList) {
                dependencies.addAll(container.getProperties().getTextureDependencies());
            }
        }
        return dependencies;
    }

    @Override
    @Nullable
    public class_1087 wrapBaked(@Nullable class_1087 bakedWrapped, class_1088 loader, Function<class_4730, class_1058> textureGetter, class_3665 rotationContainer, class_2960 modelId) {
        if (bakedWrapped == null || bakedWrapped.method_4713()) {
            return bakedWrapped;
        }
        return new CTMBakedModel(bakedWrapped, (List<QuadProcessor>)CTMUnbakedModel.toProcessorList(this.containerList, textureGetter), (List<QuadProcessor>)(this.multipassContainerList == null ? null : CTMUnbakedModel.toProcessorList(this.multipassContainerList, textureGetter)));
    }

    protected static ImmutableList<QuadProcessor> toProcessorList(List<CTMLoadingContainer<?>> containerList, Function<class_4730, class_1058> textureGetter) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (CTMLoadingContainer<?> container : containerList) {
            listBuilder.add((Object)container.toProcessor(textureGetter));
        }
        return listBuilder.build();
    }
}

