/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client;

import me.pepperbell.continuity.api.client.CTMLoader;
import me.pepperbell.continuity.api.client.CTMLoaderRegistry;
import me.pepperbell.continuity.api.client.CTMPropertiesFactory;
import me.pepperbell.continuity.client.processor.CompactCTMQuadProcessor;
import me.pepperbell.continuity.client.processor.HorizontalQuadProcessor;
import me.pepperbell.continuity.client.processor.HorizontalVerticalQuadProcessor;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.TopQuadProcessor;
import me.pepperbell.continuity.client.processor.VerticalHorizontalQuadProcessor;
import me.pepperbell.continuity.client.processor.VerticalQuadProcessor;
import me.pepperbell.continuity.client.processor.overlay.SimpleOverlayQuadProcessor;
import me.pepperbell.continuity.client.processor.overlay.StandardOverlayQuadProcessor;
import me.pepperbell.continuity.client.processor.simple.CTMSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.FixedSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.RandomSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.RepeatSpriteProvider;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.properties.CompactConnectingCTMProperties;
import me.pepperbell.continuity.client.properties.ConnectingCTMProperties;
import me.pepperbell.continuity.client.properties.RandomCTMProperties;
import me.pepperbell.continuity.client.properties.RepeatCTMProperties;
import me.pepperbell.continuity.client.properties.StandardConnectingCTMProperties;
import me.pepperbell.continuity.client.properties.TileAmountValidator;
import me.pepperbell.continuity.client.properties.overlay.BaseOverlayCTMProperties;
import me.pepperbell.continuity.client.properties.overlay.RandomOverlayCTMProperties;
import me.pepperbell.continuity.client.properties.overlay.RepeatOverlayCTMProperties;
import me.pepperbell.continuity.client.properties.overlay.StandardConnectingOverlayCTMProperties;
import me.pepperbell.continuity.client.properties.overlay.StandardOverlayCTMProperties;
import me.pepperbell.continuity.client.resource.CustomBlockLayers;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.client.util.biome.BiomeHolderManager;
import me.pepperbell.continuity.client.util.biome.BiomeRetriever;
import me.pepperbell.continuity.impl.client.ProcessingDataKeyRegistryImpl;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuityClient
implements ClientModInitializer {
    public static final String ID = "continuity";
    public static final String NAME = "Continuity";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Continuity");

    public void onInitializeClient() {
        ProcessingDataKeyRegistryImpl.INSTANCE.init();
        BiomeHolderManager.init();
        BiomeRetriever.init();
        ProcessingDataKeys.init();
        RenderUtil.ReloadListener.init();
        CustomBlockLayers.ReloadListener.init();
        FabricLoader.getInstance().getModContainer(ID).ifPresent(container -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ContinuityClient.asId("default"), (ModContainer)container, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ContinuityClient.asId("glass_pane_culling_fix"), (ModContainer)container, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        });
        CTMLoaderRegistry registry = CTMLoaderRegistry.get();
        CTMLoader<BaseCTMProperties> loader = CTMLoader.of(ContinuityClient.wrapFactory(StandardConnectingCTMProperties::new, new TileAmountValidator.AtLeast(47)), new SimpleQuadProcessor.Factory<StandardConnectingCTMProperties>(new CTMSpriteProvider.Factory(true)));
        registry.registerLoader("ctm", loader);
        registry.registerLoader("glass", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(CompactConnectingCTMProperties::new, new TileAmountValidator.AtLeast(5)), new CompactCTMQuadProcessor.Factory());
        registry.registerLoader("ctm_compact", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(ConnectingCTMProperties::new, new TileAmountValidator.Exactly(4)), new HorizontalQuadProcessor.Factory());
        registry.registerLoader("horizontal", loader);
        registry.registerLoader("bookshelf", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(ConnectingCTMProperties::new, new TileAmountValidator.Exactly(4)), new VerticalQuadProcessor.Factory());
        registry.registerLoader("vertical", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(ConnectingCTMProperties::new, new TileAmountValidator.Exactly(7)), new HorizontalVerticalQuadProcessor.Factory());
        registry.registerLoader("horizontal+vertical", loader);
        registry.registerLoader("h+v", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(ConnectingCTMProperties::new, new TileAmountValidator.Exactly(7)), new VerticalHorizontalQuadProcessor.Factory());
        registry.registerLoader("vertical+horizontal", loader);
        registry.registerLoader("v+h", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(ConnectingCTMProperties::new, new TileAmountValidator.Exactly(1)), new TopQuadProcessor.Factory());
        registry.registerLoader("top", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(RandomCTMProperties::new), new SimpleQuadProcessor.Factory<RandomCTMProperties>(new RandomSpriteProvider.Factory()));
        registry.registerLoader("random", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(RepeatCTMProperties::new, new RepeatCTMProperties.Validator()), new SimpleQuadProcessor.Factory<RepeatCTMProperties>(new RepeatSpriteProvider.Factory()));
        registry.registerLoader("repeat", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(BaseCTMProperties::new, new TileAmountValidator.Exactly(1)), new SimpleQuadProcessor.Factory<BaseCTMProperties>(new FixedSpriteProvider.Factory()));
        registry.registerLoader("fixed", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(StandardOverlayCTMProperties::new, new TileAmountValidator.AtLeast(17)), new StandardOverlayQuadProcessor.Factory());
        registry.registerLoader("overlay", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(StandardConnectingOverlayCTMProperties::new, new TileAmountValidator.AtLeast(47)), new SimpleOverlayQuadProcessor.Factory<StandardConnectingCTMProperties>(new CTMSpriteProvider.Factory(false)));
        registry.registerLoader("overlay_ctm", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(RandomOverlayCTMProperties::new), new SimpleOverlayQuadProcessor.Factory<RandomCTMProperties>(new RandomSpriteProvider.Factory()));
        registry.registerLoader("overlay_random", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(RepeatOverlayCTMProperties::new, new RepeatCTMProperties.Validator()), new SimpleOverlayQuadProcessor.Factory<RepeatCTMProperties>(new RepeatSpriteProvider.Factory()));
        registry.registerLoader("overlay_repeat", loader);
        loader = CTMLoader.of(ContinuityClient.wrapFactory(BaseOverlayCTMProperties::new, new TileAmountValidator.Exactly(1)), new SimpleOverlayQuadProcessor.Factory<BaseCTMProperties>(new FixedSpriteProvider.Factory()));
        registry.registerLoader("overlay_fixed", loader);
    }

    private static <T extends BaseCTMProperties> CTMPropertiesFactory<T> wrapFactory(CTMPropertiesFactory<T> factory) {
        return BaseCTMProperties.wrapFactory(factory);
    }

    private static <T extends BaseCTMProperties> CTMPropertiesFactory<T> wrapFactory(CTMPropertiesFactory<T> factory, TileAmountValidator<T> validator) {
        return TileAmountValidator.wrapFactory(ContinuityClient.wrapFactory(factory), validator);
    }

    public static class_2960 asId(String path) {
        return new class_2960(ID, path);
    }
}

