/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.common;

import fr.raksrinana.fallingtree.common.config.Configuration;
import fr.raksrinana.fallingtree.common.config.ToolConfiguration;
import fr.raksrinana.fallingtree.common.leaf.LeafBreakingHandler;
import fr.raksrinana.fallingtree.common.tree.TreeHandler;
import fr.raksrinana.fallingtree.common.tree.TreePartType;
import fr.raksrinana.fallingtree.common.tree.builder.TreeBuilder;
import fr.raksrinana.fallingtree.common.wrapper.DirectionCompat;
import fr.raksrinana.fallingtree.common.wrapper.IBlock;
import fr.raksrinana.fallingtree.common.wrapper.IBlockPos;
import fr.raksrinana.fallingtree.common.wrapper.IBlockState;
import fr.raksrinana.fallingtree.common.wrapper.IComponent;
import fr.raksrinana.fallingtree.common.wrapper.IEnchantment;
import fr.raksrinana.fallingtree.common.wrapper.IItem;
import fr.raksrinana.fallingtree.common.wrapper.IItemStack;
import fr.raksrinana.fallingtree.common.wrapper.ILevel;
import fr.raksrinana.fallingtree.common.wrapper.IPlayer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class FallingTreeCommon<D extends Enum<D>> {
    private final Configuration configuration;
    private final TreeBuilder treeBuilder;
    private final TreeHandler treeHandler;

    public FallingTreeCommon() {
        this.configuration = Configuration.read();
        this.treeBuilder = new TreeBuilder(this);
        this.treeHandler = new TreeHandler(this);
    }

    @NotNull
    public abstract IComponent translate(@NotNull String var1, Object ... var2);

    public void notifyPlayer(@NotNull IPlayer player, @NotNull IComponent component) {
        player.sendMessage(component, this.getConfiguration().getNotificationMode());
    }

    public boolean isPlayerInRightState(@NotNull IPlayer player) {
        if (player.isCreative() && !this.getConfiguration().isBreakInCreative()) {
            return false;
        }
        if (!this.configuration.getSneakMode().test(player.isCrouching())) {
            return false;
        }
        if (!this.playerHasRequiredTags(player)) {
            return false;
        }
        return this.canPlayerBreakTree(player);
    }

    private boolean playerHasRequiredTags(@NotNull IPlayer player) {
        List<String> tags = this.configuration.getPlayer().getAllowedTags();
        if (tags.isEmpty()) {
            return true;
        }
        Set<String> playerTags = player.getTags();
        return tags.stream().anyMatch(playerTags::contains);
    }

    public boolean canPlayerBreakTree(@NotNull IPlayer player) {
        IItemStack heldItemStack = player.getMainHandItem();
        if (!this.isValidTool(heldItemStack)) {
            return false;
        }
        return !this.getConfiguration().getEnchantment().isAtLeastOneEnchantRegistered() || heldItemStack.hasOneOfEnchantAtLeast(this.getChopperEnchantments(), 1);
    }

    public boolean isValidTool(@NotNull IItemStack heldItemStack) {
        boolean isAllowedTool;
        ToolConfiguration toolConfiguration = this.getConfiguration().getTools();
        IItem heldItem = heldItemStack.getItem();
        boolean bl = isAllowedTool = toolConfiguration.isIgnoreTools() || heldItem.isAxe() || toolConfiguration.getAllowedItems(this).stream().anyMatch(tool -> tool.equals(heldItem));
        if (!isAllowedTool) {
            return false;
        }
        boolean isDeniedTool = toolConfiguration.getDeniedItems(this).stream().anyMatch(tool -> tool.equals(heldItem));
        return !isDeniedTool;
    }

    @NotNull
    public TreeHandler getTreeHandler() {
        return this.treeHandler;
    }

    @NotNull
    public TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    @NotNull
    public abstract LeafBreakingHandler getLeafBreakingHandler();

    @NotNull
    public Set<IBlock> getAsBlocks(@NotNull Collection<String> names) {
        return names.stream().filter(Objects::nonNull).filter(val -> !val.isEmpty()).flatMap(this::getBlock).filter(Objects::nonNull).filter(block -> !block.isAir()).collect(Collectors.toSet());
    }

    @NotNull
    public abstract Stream<IBlock> getBlock(@NotNull String var1);

    @NotNull
    public Set<IItem> getAsItems(Collection<String> names) {
        return names.stream().filter(Objects::nonNull).filter(val -> !val.isEmpty()).flatMap(this::getItem).filter(Objects::nonNull).filter(item -> !item.isAir()).collect(Collectors.toSet());
    }

    @NotNull
    public abstract Stream<IItem> getItem(@NotNull String var1);

    public abstract boolean isLeafBlock(@NotNull IBlock var1);

    public abstract boolean isLogBlock(@NotNull IBlock var1);

    @NotNull
    public abstract Set<IBlock> getAllNonStrippedLogsBlocks();

    @NotNull
    public abstract DirectionCompat asDirectionCompat(@NotNull D var1);

    @NotNull
    public abstract D asDirection(@NotNull DirectionCompat var1);

    public boolean isLeafNeedBreakBlock(@NotNull IBlock block) {
        return this.getConfiguration().getTrees().getAllowedNonDecayLeaveBlocks(this).stream().anyMatch(log -> log.equals(block));
    }

    public abstract boolean isNetherWartOrShroomlight(@NotNull IBlock var1);

    public abstract boolean isMangroveRoots(@NotNull IBlock var1);

    @NotNull
    public TreePartType getTreePart(@NotNull IBlock checkBlock) {
        if (this.isLogBlock(checkBlock)) {
            return TreePartType.LOG;
        }
        if (this.isNetherWartOrShroomlight(checkBlock)) {
            return TreePartType.NETHER_WART;
        }
        if (this.isMangroveRoots(checkBlock)) {
            return TreePartType.NETHER_WART;
        }
        if (this.isLeafNeedBreakBlock(checkBlock)) {
            return TreePartType.LEAF_NEED_BREAK;
        }
        if (this.isLeafBlock(checkBlock)) {
            return TreePartType.LEAF;
        }
        return TreePartType.OTHER;
    }

    public abstract boolean checkCanBreakBlock(@NotNull ILevel var1, @NotNull IBlockPos var2, @NotNull IBlockState var3, @NotNull IPlayer var4);

    public void registerEnchant() {
        if (this.configuration.getEnchantment().isRegisterEnchant()) {
            this.performDefaultEnchantRegister();
        }
        if (this.configuration.getEnchantment().isRegisterSpecificEnchant()) {
            this.performSpecificEnchantRegister();
        }
        this.performCommitEnchantRegister();
    }

    protected abstract void performDefaultEnchantRegister();

    protected abstract void performSpecificEnchantRegister();

    protected abstract void performCommitEnchantRegister();

    @NotNull
    public abstract Collection<IEnchantment> getChopperEnchantments();

    public FallingTreeCommon(Configuration configuration, TreeBuilder treeBuilder, TreeHandler treeHandler) {
        this.configuration = configuration;
        this.treeBuilder = treeBuilder;
        this.treeHandler = treeHandler;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }
}

