/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Consumer;
import link.infra.indium.renderer.IndiumRenderer;
import link.infra.indium.renderer.RenderMaterialImpl;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.mesh.EncodingFormat;
import link.infra.indium.renderer.mesh.MeshImpl;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.BaseQuadRenderer;
import link.infra.indium.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1921;
import net.minecraft.class_310;

public class BaseMeshConsumer
extends BaseQuadRenderer
implements Consumer<Mesh> {
    private final Maker editorQuad = new Maker();

    protected BaseMeshConsumer(BaseQuadRenderer.QuadBufferer bufferer, BlockRenderInfo blockInfo, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        super(bufferer, blockInfo, aoCalc, transform);
    }

    @Override
    public void accept(Mesh mesh) {
        MeshImpl m = (MeshImpl)mesh;
        int[] data = m.data();
        int limit = data.length;
        for (int index = 0; index < limit; index += EncodingFormat.TOTAL_STRIDE) {
            System.arraycopy(data, index, this.editorQuad.data(), 0, EncodingFormat.TOTAL_STRIDE);
            this.editorQuad.load();
            this.renderQuad(this.editorQuad);
        }
    }

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    private void renderQuad(MutableQuadViewImpl quad) {
        if (!this.transform.transform((MutableQuadView)quad)) {
            return;
        }
        if (!this.blockInfo.shouldDrawFace(quad.cullFace())) {
            return;
        }
        RenderMaterialImpl.Value mat = quad.material();
        if (!mat.disableAo(0) && class_310.method_1588()) {
            this.aoCalc.compute(quad, false);
        }
        this.tessellateQuad(quad, mat, 0);
    }

    private void tessellateQuad(MutableQuadViewImpl quad, RenderMaterialImpl.Value mat, int textureIndex) {
        int colorIndex = mat.disableColorIndex(textureIndex) ? -1 : quad.colorIndex();
        class_1921 renderLayer = this.blockInfo.effectiveRenderLayer(mat.blendMode(textureIndex));
        if (this.blockInfo.defaultAo && !mat.disableAo(textureIndex)) {
            if (mat.emissive(textureIndex)) {
                this.tessellateSmoothEmissive(quad, renderLayer, colorIndex);
            } else {
                this.tessellateSmooth(quad, renderLayer, colorIndex);
            }
        } else if (mat.emissive(textureIndex)) {
            this.tessellateFlatEmissive(quad, renderLayer, colorIndex);
        } else {
            this.tessellateFlat(quad, renderLayer, colorIndex);
        }
    }

    private class Maker
    extends MutableQuadViewImpl {
        private Maker() {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.material(IndiumRenderer.MATERIAL_STANDARD);
        }

        public Maker emit() {
            this.computeGeometry();
            BaseMeshConsumer.this.renderQuad(this);
            this.clear();
            return this;
        }
    }
}

