/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.skinlayers.Config;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.config.CustomConfigScreen;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SkinLayersModBase {
    public static SkinLayersModBase instance;
    public static final Logger LOGGER;
    public static Config config;
    private File settingsFile = new File("config", "skinlayers.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static boolean disguiseHeadsCompatibility;

    public void onInitialize() {
        instance = this;
        if (this.settingsFile.exists()) {
            try {
                config = (Config)new Gson().fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), Config.class);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (config == null) {
            config = new Config();
            this.writeConfig();
        }
        try {
            Class<?> clientClass = Class.forName("dev.tr7zw.disguiseheads.DisguiseHeadsShared");
            disguiseHeadsCompatibility = clientClass != null;
            LOGGER.info("Found DisguiseHeads, enable compatibility!");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void writeConfig() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public Screen createConfigScreen(Screen parent) {
        CustomConfigScreen screen = new CustomConfigScreen(parent, "text.skinlayers.title"){

            @Override
            public void initialize() {
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getOnOffOption("text.skinlayers.enable.hat", () -> SkinLayersModBase.config.enableHat, b -> {
                    SkinLayersModBase.config.enableHat = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.jacket", () -> SkinLayersModBase.config.enableJacket, b -> {
                    SkinLayersModBase.config.enableJacket = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.leftsleeve", () -> SkinLayersModBase.config.enableLeftSleeve, b -> {
                    SkinLayersModBase.config.enableLeftSleeve = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.rightsleeve", () -> SkinLayersModBase.config.enableRightSleeve, b -> {
                    SkinLayersModBase.config.enableRightSleeve = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.leftpants", () -> SkinLayersModBase.config.enableLeftPants, b -> {
                    SkinLayersModBase.config.enableLeftPants = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.enable.rightpants", () -> SkinLayersModBase.config.enableRightPants, b -> {
                    SkinLayersModBase.config.enableRightPants = b;
                }));
                options.add(this.getIntOption("text.skinlayers.renderdistancelod", 5, 40, () -> SkinLayersModBase.config.renderDistanceLOD, i -> {
                    SkinLayersModBase.config.renderDistanceLOD = i;
                }));
                options.add(this.getDoubleOption("text.skinlayers.basevoxelsize", 1.001f, 1.4f, 0.001f, () -> SkinLayersModBase.config.baseVoxelSize, i -> {
                    SkinLayersModBase.config.baseVoxelSize = i.floatValue();
                    SkinLayersModBase.this.refreshLayers((Player)this.f_96541_.f_91074_);
                }));
                options.add(this.getDoubleOption("text.skinlayers.headvoxelsize", 1.001f, 1.25f, 0.001f, () -> SkinLayersModBase.config.headVoxelSize, i -> {
                    SkinLayersModBase.config.headVoxelSize = i.floatValue();
                    SkinLayersModBase.this.refreshLayers((Player)this.f_96541_.f_91074_);
                }));
                options.add(this.getDoubleOption("text.skinlayers.bodyvoxelwidthsize", 1.001f, 1.4f, 0.001f, () -> SkinLayersModBase.config.bodyVoxelWidthSize, i -> {
                    SkinLayersModBase.config.bodyVoxelWidthSize = i.floatValue();
                    SkinLayersModBase.this.refreshLayers((Player)this.f_96541_.f_91074_);
                }));
                options.add(this.getOnOffOption("text.skinlayers.skulls.enable", () -> SkinLayersModBase.config.enableSkulls, b -> {
                    SkinLayersModBase.config.enableSkulls = b;
                }));
                options.add(this.getOnOffOption("text.skinlayers.skullsitems.enable", () -> SkinLayersModBase.config.enableSkullsItems, b -> {
                    SkinLayersModBase.config.enableSkullsItems = b;
                }));
                options.add(this.getDoubleOption("text.skinlayers.skulls.voxelsize", 1.001f, 1.2f, 0.001f, () -> SkinLayersModBase.config.skullVoxelSize, i -> {
                    SkinLayersModBase.config.skullVoxelSize = i.floatValue();
                }));
                options.add(this.getOnOffOption("text.skinlayers.fastrender.enable", () -> SkinLayersModBase.config.fastRender, b -> {
                    SkinLayersModBase.config.fastRender = b;
                }));
                this.getOptions().m_232533_(options.toArray(new OptionInstance[0]));
            }

            @Override
            public void save() {
                SkinLayersModBase.this.writeConfig();
            }

            @Override
            public void m_6305_(PoseStack poseStack, int xMouse, int yMouse, float f) {
                super.m_6305_(poseStack, xMouse, yMouse, f);
                if (this.f_96541_.f_91073_ != null) {
                    int x = this.f_96541_.m_91268_().m_85445_() / 2;
                    int y = this.f_96541_.m_91268_().m_85446_() - 45;
                    int size = (int)(40.0f * ((float)this.f_96541_.m_91268_().m_85446_() / 200.0f));
                    int lookX = x - xMouse;
                    int lookY = y - 80 - yMouse;
                    lookY = Math.min(lookY, 10);
                    InventoryScreen.m_98850_((int)x, (int)y, (int)size, (float)lookX, (float)lookY, (LivingEntity)this.f_96541_.f_91074_);
                }
            }

            @Override
            public void reset() {
                config = new Config();
                SkinLayersModBase.this.writeConfig();
            }
        };
        return screen;
    }

    public void refreshLayers(Player player) {
        if (player == null || !(player instanceof PlayerSettings)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        settings.setupSkinLayers(null);
        settings.setupHeadLayers(null);
        settings.setCurrentSkin(null);
    }

    static {
        LOGGER = LogManager.getLogger();
        config = null;
        disguiseHeadsCompatibility = false;
    }
}

