/*
 * Decompiled with CFR 0.152.
 */
package safro.oxidized.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class OxidizedConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public int copper_rail_range = 50;
    public boolean enable_copper_pulsar = true;
    public int pulsar_reach = 10;
    public float iron_nugget_chance = 0.15f;
    public float gold_nugget_chance = 0.15f;
    public float sand_chance = 0.24f;
    public float gravel_chance = 0.12f;
    public float emerald_chance = 0.02f;
    public int copper_golem_button_chance = 30;
    public boolean enable_copper_golem = true;
    public boolean enable_rose_gold_tools = true;

    public static OxidizedConfig loadConfig(File file) {
        OxidizedConfig config;
        block18: {
            if (file.exists() && file.isFile()) {
                try (FileInputStream fileInputStream = new FileInputStream(file);
                     InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    config = (OxidizedConfig)GSON.fromJson((Reader)bufferedReader, OxidizedConfig.class);
                    break block18;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load config", e);
                }
            }
            config = new OxidizedConfig();
        }
        config.saveConfig(file);
        return config;
    }

    public void saveConfig(File config) {
        try (FileOutputStream stream = new FileOutputStream(config);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config", e);
        }
    }
}

