/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.renderer;

import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.provider.EmptyPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.util.MergedItemStack;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_918;

public abstract class BasePreviewRenderer
implements PreviewRenderer {
    protected PreviewType previewType;
    protected int compactMaxRowSize;
    protected int maxRowSize = 9;
    protected class_2960 textureOverride;
    protected PreviewProvider provider;
    protected List<MergedItemStack> items = new ArrayList<MergedItemStack>();
    protected PreviewContext previewContext;
    private final int slotWidth;
    private final int slotHeight;
    private final int slotXOffset;
    private final int slotYOffset;

    protected BasePreviewRenderer(int slotWidth, int slotHeight, int slotXOffset, int slotYOffset) {
        this.previewType = PreviewType.FULL;
        this.slotWidth = slotWidth;
        this.slotHeight = slotHeight;
        this.slotXOffset = slotXOffset;
        this.slotYOffset = slotYOffset;
        this.setPreview(PreviewContext.of(class_1799.field_8037), EmptyPreviewProvider.INSTANCE);
    }

    protected int getMaxRowSize() {
        return this.previewType == PreviewType.COMPACT ? this.compactMaxRowSize : this.maxRowSize;
    }

    protected int getInvSize() {
        return this.previewType == PreviewType.COMPACT ? Math.max(1, this.items.size()) : this.provider.getInventoryMaxSize(this.previewContext);
    }

    @Override
    public void setPreviewType(PreviewType type) {
        this.previewType = type;
    }

    @Override
    public void setPreview(PreviewContext context, PreviewProvider provider) {
        List<class_1799> inventory = provider.getInventory(context);
        int rowSize = provider.getMaxRowSize(context);
        this.compactMaxRowSize = ShulkerBoxTooltip.config.preview.defaultMaxRowSize;
        if (this.compactMaxRowSize <= 0) {
            this.compactMaxRowSize = 9;
        }
        if (rowSize <= 0) {
            rowSize = this.compactMaxRowSize;
        }
        this.maxRowSize = rowSize;
        this.textureOverride = provider.getTextureOverride(context);
        this.provider = provider;
        this.items = MergedItemStack.mergeInventory(inventory, provider.getInventoryMaxSize(context), ShulkerBoxTooltip.config.preview.compactPreviewNbtBehavior != Configuration.CompactPreviewNbtBehavior.SEPARATE);
        this.previewContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawItem(class_1799 stack, int x, int y, class_327 textRenderer, class_918 itemRenderer, int slot, boolean shortItemCount) {
        String countLabel = null;
        int prevCount = stack.method_7947();
        int maxRowSize = this.getMaxRowSize();
        if (prevCount > 1) {
            countLabel = shortItemCount ? ShulkerBoxTooltipUtil.abrieviateInteger(stack.method_7947()) : String.valueOf(stack.method_7947());
        }
        stack.method_7939(1);
        x = this.slotXOffset + x + this.slotWidth * (slot % maxRowSize);
        y = this.slotYOffset + y + this.slotHeight * (slot / maxRowSize);
        try {
            itemRenderer.method_4023(stack, x, y);
            itemRenderer.method_4022(textRenderer, stack, x, y, countLabel);
        }
        finally {
            stack.method_7939(prevCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawItems(int x, int y, int z, class_327 textRenderer, class_918 itemRenderer) {
        float prevOffset = itemRenderer.field_4730;
        itemRenderer.field_4730 = z;
        try {
            if (this.previewType == PreviewType.COMPACT) {
                boolean shortItemCounts = ShulkerBoxTooltip.config.preview.shortItemCounts;
                int size = this.items.size();
                for (int slot = 0; slot < size; ++slot) {
                    this.drawItem(this.items.get(slot).get(), x, y, textRenderer, itemRenderer, slot, shortItemCounts);
                }
            } else {
                for (MergedItemStack compactor : this.items) {
                    int size = compactor.size();
                    for (int slot = 0; slot < size; ++slot) {
                        this.drawItem(compactor.getSubStack(slot), x, y, textRenderer, itemRenderer, slot, false);
                    }
                }
            }
        }
        finally {
            itemRenderer.field_4730 = prevOffset;
        }
    }
}

