/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network;

import com.misterpemodder.shulkerboxtooltip.impl.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.network.C2SPackets;
import com.misterpemodder.shulkerboxtooltip.impl.network.EnderChestInventoryListener;
import com.misterpemodder.shulkerboxtooltip.impl.network.ProtocolVersion;
import com.misterpemodder.shulkerboxtooltip.impl.network.S2CPackets;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public final class ServerNetworking {
    private static final Set<class_3222> CLIENTS = new HashSet<class_3222>();

    public static void init() {
        if (!ShulkerBoxTooltip.config.server.clientIntegration) {
            return;
        }
        ServerPlayConnectionEvents.INIT.register((handler, server) -> C2SPackets.registerReceivers(handler));
        ServerPlayConnectionEvents.DISCONNECT.register(ServerNetworking::onPlayerDisconnected);
    }

    private static void onPlayerDisconnected(class_3244 handler, MinecraftServer server) {
        class_3222 player = handler.field_14140;
        EnderChestInventoryListener.detachFrom(player);
        CLIENTS.remove(player);
    }

    static void onHandshakeAttempt(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        ProtocolVersion clientVersion = ProtocolVersion.readFromPacketBuf(buf);
        if (clientVersion == null) {
            ShulkerBoxTooltip.LOGGER.error("[" + ShulkerBoxTooltip.MOD_NAME + "] " + player.method_5820() + ": received invalid handshake packet");
            C2SPackets.unregisterReceivers(handler);
            return;
        }
        ShulkerBoxTooltip.LOGGER.info("[" + ShulkerBoxTooltip.MOD_NAME + "] " + player.method_5820() + ": protocol version: " + clientVersion);
        S2CPackets.sendHandshakeResponse(sender);
        if (clientVersion.major != ProtocolVersion.CURRENT.major) {
            ShulkerBoxTooltip.LOGGER.error("[" + ShulkerBoxTooltip.MOD_NAME + "] " + player.method_5820() + ": incompatible client protocol version, expected " + ProtocolVersion.CURRENT.major + ", got " + clientVersion.major);
            C2SPackets.unregisterReceivers(handler);
            return;
        }
        CLIENTS.add(player);
        ServerPlayNetworking.unregisterReceiver((class_3244)handler, (class_2960)C2SPackets.HANDSHAKE_TO_SERVER);
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity instanceof class_3222) {
                class_3222 p = (class_3222)entity;
                ServerNetworking.onPlayerLoad(p);
            }
        });
        server.execute(() -> ServerNetworking.onPlayerLoad(player));
    }

    static void onEnderChestUpdateRequest(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender sender) {
        S2CPackets.sendEnderChestUpdate(sender, player.method_7274());
    }

    public static boolean hasModAvailable(class_3222 player) {
        return CLIENTS.contains(player);
    }

    private static void onPlayerLoad(class_3222 player) {
        class_3244 handler = player.field_13987;
        if (handler == null) {
            return;
        }
        ShulkerBoxTooltip.initPreviewItemsMap();
        PacketSender sender = ServerPlayNetworking.getSender((class_3244)handler);
        Configuration.EnderChestSyncType ecSyncType = ShulkerBoxTooltip.config.server.enderChestSyncType;
        if (ecSyncType != Configuration.EnderChestSyncType.NONE) {
            S2CPackets.sendEnderChestUpdate(sender, player.method_7274());
        }
        if (ecSyncType == Configuration.EnderChestSyncType.ACTIVE) {
            EnderChestInventoryListener.attachTo(player);
        }
    }
}

